/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class prefJPanel
extends JPanel {
    private TableModel model;
    private static int[] modifInts = new int[]{-1, 0, 64, 128, 512, 256, 192, 576, 320, 640, 384, 768, 704, 832};
    private static String[] modifList = new String[]{I18n.tr("disabled"), I18n.tr("no modifier"), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[2]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[3]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[4]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[5]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[6]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[7]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[8]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[9]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[10]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[11]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[12]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[13]).getModifiers())};
    private static String SHIFT = KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, 64).getModifiers());
    private static String CTRL = KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, 128).getModifiers());
    private static String ALT = KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, 512).getModifiers());
    private static String META = KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, 256).getModifiers());
    private static Map<Integer, String> keyList = prefJPanel.setKeyList();
    private JComboBox bxPrim1;
    private JComboBox bxPrim2;
    private JComboBox bxPrim3;
    private JComboBox bxPrim4;
    private JComboBox bxSec1;
    private JComboBox bxSec2;
    private JComboBox bxSec3;
    private JComboBox bxSec4;
    private JComboBox bxTer1;
    private JComboBox bxTer2;
    private JComboBox bxTer3;
    private JComboBox bxTer4;
    private JCheckBox cbAlt;
    private JCheckBox cbCtrl;
    private JCheckBox cbDefault;
    private JCheckBox cbDisable;
    private JCheckBox cbMeta;
    private JCheckBox cbShift;
    private JPanel editGroupPane;
    private JPanel hotkeyGroupPane;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel listPane;
    private JScrollPane listScrollPane;
    private JPanel menuGroupPane;
    private JPanel modifierTab;
    private JTabbedPane prefTabPane;
    private JPanel shortcutEditPane;
    private JPanel shortcutTab;
    private JTable shortcutTable;
    private JPanel subwindowGroupPane;
    private JComboBox tfKey;
    private JLabel tfKeyLabel;
    private JPanel infoTab;

    private static Map<Integer, String> setKeyList() {
        LinkedHashMap<Integer, String> linkedHashMap = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < 65534; ++i) {
            String string = KeyEvent.getKeyText(i);
            if (string == null || string.length() <= 0 || string.contains("Unknown")) continue;
            linkedHashMap.put(i, string);
        }
        linkedHashMap.put(-1, "");
        return linkedHashMap;
    }

    public prefJPanel(TableModel tableModel) {
        this.model = tableModel;
        this.initComponents();
    }

    private void initComponents() {
        this.prefTabPane = new JTabbedPane();
        this.shortcutTab = new JPanel();
        this.listPane = new JPanel();
        this.listScrollPane = new JScrollPane();
        this.shortcutTable = new JTable();
        this.shortcutEditPane = new JPanel();
        this.cbDefault = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.cbShift = new JCheckBox();
        this.cbDisable = new JCheckBox();
        this.cbCtrl = new JCheckBox();
        this.tfKeyLabel = new JLabel();
        this.cbAlt = new JCheckBox();
        this.tfKey = new JComboBox();
        this.cbMeta = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.modifierTab = new JPanel();
        this.editGroupPane = new JPanel();
        this.jLabel1 = new JLabel();
        this.bxPrim1 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.bxSec1 = new JComboBox();
        this.jLabel3 = new JLabel();
        this.bxTer1 = new JComboBox();
        this.menuGroupPane = new JPanel();
        this.jLabel7 = new JLabel();
        this.bxPrim2 = new JComboBox();
        this.jLabel8 = new JLabel();
        this.bxSec2 = new JComboBox();
        this.jLabel9 = new JLabel();
        this.bxTer2 = new JComboBox();
        this.hotkeyGroupPane = new JPanel();
        this.jLabel10 = new JLabel();
        this.bxPrim3 = new JComboBox();
        this.jLabel11 = new JLabel();
        this.bxSec3 = new JComboBox();
        this.jLabel12 = new JLabel();
        this.bxTer3 = new JComboBox();
        this.subwindowGroupPane = new JPanel();
        this.jLabel13 = new JLabel();
        this.bxPrim4 = new JComboBox();
        this.jLabel14 = new JLabel();
        this.bxSec4 = new JComboBox();
        this.jLabel15 = new JLabel();
        this.bxTer4 = new JComboBox();
        this.infoTab = new JPanel();
        cbAction cbAction2 = new cbAction(this);
        bxAction bxAction2 = new bxAction();
        this.setLayout(new BoxLayout(this, 1));
        this.infoTab.setLayout(new BoxLayout(this.shortcutTab, 1));
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setContentType("text/html");
        jEditorPane.setText(I18n.tr("<h1><a name=\"top\">Keyboard Shortcuts</a></h1>") + I18n.tr("<p>Please note that shortcuts keys are assigned to the actions when JOSM is started. So you need to <b>restart</b> JOSM to see your changes.</p>") + I18n.tr("<p>Furthermore, the shortcuts are activated when the actions are assigned to a menu entry of button for the first time. So some of your changes may become active even without restart --- but also without collistion handling. This is another reason to <b>restart</b> JOSM after making any changes here.</p>") + I18n.tr("<p>You may notice that the key selection list on the next page lists all keys that exist on all kinds of keyboards Java knows about, not just those keys that exist on your keyboard. Please use only those values that correspond to a real key on your keyboard. So if your keyboard has no 'Copy' key (PC keyboard don't have them, Sun keyboards do), the do not use it. Also there will be 'keys' listed that correspond to a shortcut on your keyboard (e.g. ':'/Colon). Please also do not use them, use the base key (';'/Semicolon on US keyboards, '.'/Period on German keyboards, ...) instead. Not doing so may result in conflicts, as there is no way for JOSM to know that Ctrl+Shift+; and Ctrl+: actually is the same thing on an US keyboard...</p>") + I18n.tr("<p>Thank you for your understanding</p>") + I18n.tr("<h1>Modifier Groups</h1>") + I18n.tr("<p>The last page lists the modifier keys JOSM will automatically assign to shortcuts. For every of the four kinds of shortcuts there are three alternatives. JOSM will try those alternative in the listed order when managing a conflict. If all alternatives would result in shortcuts that are already taken, it will assign a random shortcut instead.</p>") + I18n.tr("<p>The pseudo-modifier 'disabled' will disable the shortcut when encountered.</p>"));
        jEditorPane.setCaretPosition(0);
        this.prefTabPane.addTab(I18n.tr("Read First"), new JScrollPane(jEditorPane));
        this.shortcutTab.setLayout(new BoxLayout(this.shortcutTab, 1));
        this.listPane.setLayout(new GridLayout());
        this.shortcutTable.setModel(this.model);
        this.shortcutTable.getSelectionModel().addListSelectionListener(new cbAction(this));
        this.shortcutTable.setSelectionMode(0);
        this.listScrollPane.setViewportView(this.shortcutTable);
        this.listPane.add(this.listScrollPane);
        this.shortcutTab.add(this.listPane);
        this.shortcutEditPane.setLayout(new GridLayout(5, 2));
        this.cbDefault.setAction(cbAction2);
        this.cbDefault.setText(I18n.tr("Use default"));
        this.shortcutEditPane.add(this.cbDefault);
        this.shortcutEditPane.add(this.jLabel4);
        this.cbShift.setAction(cbAction2);
        this.cbShift.setText(SHIFT);
        this.shortcutEditPane.add(this.cbShift);
        this.cbDisable.setAction(cbAction2);
        this.cbDisable.setText(I18n.tr("Disable"));
        this.shortcutEditPane.add(this.cbDisable);
        this.cbCtrl.setAction(cbAction2);
        this.cbCtrl.setText(CTRL);
        this.shortcutEditPane.add(this.cbCtrl);
        this.tfKeyLabel.setHorizontalAlignment(2);
        this.tfKeyLabel.setText(I18n.tr("Key:"));
        this.shortcutEditPane.add(this.tfKeyLabel);
        this.cbAlt.setAction(cbAction2);
        this.cbAlt.setText(ALT);
        this.shortcutEditPane.add(this.cbAlt);
        this.tfKey.setAction(cbAction2);
        this.tfKey.setModel(new DefaultComboBoxModel<Object>(keyList.values().toArray()));
        this.shortcutEditPane.add(this.tfKey);
        this.cbMeta.setAction(cbAction2);
        this.cbMeta.setText(META);
        this.shortcutEditPane.add(this.cbMeta);
        this.jLabel6.setText(I18n.tr("Attention: Use real keyboard keys only!"));
        this.shortcutEditPane.add(this.jLabel6);
        cbAction2.actionPerformed(null);
        this.shortcutTab.add(this.shortcutEditPane);
        this.prefTabPane.addTab(I18n.tr("Keyboard Shortcuts"), this.shortcutTab);
        this.modifierTab.setLayout(new GridLayout(0, 1));
        JScrollPane jScrollPane = new JScrollPane(this.modifierTab);
        this.editGroupPane.setBorder(BorderFactory.createTitledBorder(I18n.tr("Edit Shortcuts")));
        this.editGroupPane.setLayout(new GridLayout(3, 5));
        this.jLabel1.setText(I18n.tr("Primary modifier:"));
        this.editGroupPane.add(this.jLabel1);
        this.bxPrim1.setModel(new DefaultComboBoxModel<String>(modifList));
        this.editGroupPane.add(this.bxPrim1);
        this.jLabel2.setText(I18n.tr("Secondary modifier:"));
        this.editGroupPane.add(this.jLabel2);
        this.bxSec1.setModel(new DefaultComboBoxModel<String>(modifList));
        this.editGroupPane.add(this.bxSec1);
        this.jLabel3.setText(I18n.tr("Tertiary modifier:"));
        this.editGroupPane.add(this.jLabel3);
        this.bxTer1.setModel(new DefaultComboBoxModel<String>(modifList));
        this.editGroupPane.add(this.bxTer1);
        this.modifierTab.add(this.editGroupPane);
        this.menuGroupPane.setBorder(BorderFactory.createTitledBorder(I18n.tr("Menu Shortcuts")));
        this.menuGroupPane.setLayout(new GridLayout(3, 5));
        this.jLabel7.setText(I18n.tr("Primary modifier:"));
        this.menuGroupPane.add(this.jLabel7);
        this.bxPrim2.setModel(new DefaultComboBoxModel<String>(modifList));
        this.menuGroupPane.add(this.bxPrim2);
        this.jLabel8.setText(I18n.tr("Secondary modifier:"));
        this.menuGroupPane.add(this.jLabel8);
        this.bxSec2.setModel(new DefaultComboBoxModel<String>(modifList));
        this.menuGroupPane.add(this.bxSec2);
        this.jLabel9.setText(I18n.tr("Tertiary modifier:"));
        this.menuGroupPane.add(this.jLabel9);
        this.bxTer2.setModel(new DefaultComboBoxModel<String>(modifList));
        this.menuGroupPane.add(this.bxTer2);
        this.modifierTab.add(this.menuGroupPane);
        this.hotkeyGroupPane.setBorder(BorderFactory.createTitledBorder(I18n.tr("Hotkey Shortcuts")));
        this.hotkeyGroupPane.setLayout(new GridLayout(3, 5));
        this.jLabel10.setText(I18n.tr("Primary modifier:"));
        this.hotkeyGroupPane.add(this.jLabel10);
        this.bxPrim3.setModel(new DefaultComboBoxModel<String>(modifList));
        this.hotkeyGroupPane.add(this.bxPrim3);
        this.jLabel11.setText(I18n.tr("Secondary modifier:"));
        this.hotkeyGroupPane.add(this.jLabel11);
        this.bxSec3.setModel(new DefaultComboBoxModel<String>(modifList));
        this.hotkeyGroupPane.add(this.bxSec3);
        this.jLabel12.setText(I18n.tr("Tertiary modifier:"));
        this.hotkeyGroupPane.add(this.jLabel12);
        this.bxTer3.setModel(new DefaultComboBoxModel<String>(modifList));
        this.hotkeyGroupPane.add(this.bxTer3);
        this.modifierTab.add(this.hotkeyGroupPane);
        this.subwindowGroupPane.setBorder(BorderFactory.createTitledBorder(I18n.tr("Subwindow Shortcuts")));
        this.subwindowGroupPane.setLayout(new GridLayout(3, 5));
        this.jLabel13.setText(I18n.tr("Primary modifier:"));
        this.subwindowGroupPane.add(this.jLabel13);
        this.bxPrim4.setModel(new DefaultComboBoxModel<String>(modifList));
        this.subwindowGroupPane.add(this.bxPrim4);
        this.jLabel14.setText(I18n.tr("Secondary modifier:"));
        this.subwindowGroupPane.add(this.jLabel14);
        this.bxSec4.setModel(new DefaultComboBoxModel<String>(modifList));
        this.subwindowGroupPane.add(this.bxSec4);
        this.jLabel15.setText(I18n.tr("Tertiary modifier:"));
        this.subwindowGroupPane.add(this.jLabel15);
        this.bxTer4.setModel(new DefaultComboBoxModel<String>(modifList));
        this.subwindowGroupPane.add(this.bxTer4);
        this.initbx();
        this.bxPrim1.setAction(bxAction2);
        this.bxSec1.setAction(bxAction2);
        this.bxTer1.setAction(bxAction2);
        this.bxPrim2.setAction(bxAction2);
        this.bxSec2.setAction(bxAction2);
        this.bxTer2.setAction(bxAction2);
        this.bxPrim3.setAction(bxAction2);
        this.bxSec3.setAction(bxAction2);
        this.bxTer3.setAction(bxAction2);
        this.bxPrim4.setAction(bxAction2);
        this.bxSec4.setAction(bxAction2);
        this.bxTer4.setAction(bxAction2);
        this.modifierTab.add(this.subwindowGroupPane);
        this.prefTabPane.addTab(I18n.tr("Modifier Groups"), jScrollPane);
        this.add(this.prefTabPane);
    }

    private void initbx() {
        this.setBx(this.bxPrim1, "shortcut.groups.3");
        this.setBx(this.bxSec1, "shortcut.groups.10");
        this.setBx(this.bxTer1, "shortcut.groups.17");
        this.setBx(this.bxPrim2, "shortcut.groups.2");
        this.setBx(this.bxSec2, "shortcut.groups.9");
        this.setBx(this.bxTer2, "shortcut.groups.16");
        this.setBx(this.bxPrim3, "shortcut.groups.1");
        this.setBx(this.bxSec3, "shortcut.groups.8");
        this.setBx(this.bxTer3, "shortcut.groups.15");
        this.setBx(this.bxPrim4, "shortcut.groups.4");
        this.setBx(this.bxSec4, "shortcut.groups.11");
        this.setBx(this.bxTer4, "shortcut.groups.18");
    }

    private void setBx(JComboBox jComboBox, String string) {
        int n = Main.pref.getInteger(string, -1);
        for (int i = 0; i < modifInts.length; ++i) {
            if (modifInts[i] != n) continue;
            jComboBox.setSelectedIndex(i);
        }
    }

    private class bxAction
    extends AbstractAction {
        private bxAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Main.pref.put("shortcut.groups.3", Integer.toString(modifInts[prefJPanel.this.bxPrim1.getSelectedIndex()]));
            Main.pref.put("shortcut.groups.10", Integer.toString(modifInts[prefJPanel.this.bxSec1.getSelectedIndex()]));
            Main.pref.put("shortcut.groups.17", Integer.toString(modifInts[prefJPanel.this.bxTer1.getSelectedIndex()]));
            Main.pref.put("shortcut.groups.2", Integer.toString(modifInts[prefJPanel.this.bxPrim2.getSelectedIndex()]));
            Main.pref.put("shortcut.groups.9", Integer.toString(modifInts[prefJPanel.this.bxSec2.getSelectedIndex()]));
            Main.pref.put("shortcut.groups.16", Integer.toString(modifInts[prefJPanel.this.bxTer2.getSelectedIndex()]));
            Main.pref.put("shortcut.groups.1", Integer.toString(modifInts[prefJPanel.this.bxPrim3.getSelectedIndex()]));
            Main.pref.put("shortcut.groups.8", Integer.toString(modifInts[prefJPanel.this.bxSec3.getSelectedIndex()]));
            Main.pref.put("shortcut.groups.15", Integer.toString(modifInts[prefJPanel.this.bxTer3.getSelectedIndex()]));
            Main.pref.put("shortcut.groups.4", Integer.toString(modifInts[prefJPanel.this.bxPrim4.getSelectedIndex()]));
            Main.pref.put("shortcut.groups.11", Integer.toString(modifInts[prefJPanel.this.bxSec4.getSelectedIndex()]));
            Main.pref.put("shortcut.groups.18", Integer.toString(modifInts[prefJPanel.this.bxTer4.getSelectedIndex()]));
        }
    }

    private class cbAction
    extends AbstractAction
    implements ListSelectionListener {
        private prefJPanel panel;

        public cbAction(prefJPanel prefJPanel3) {
            this.panel = prefJPanel3;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = this.panel.shortcutTable.getSelectionModel();
            if (!listSelectionModel.isSelectionEmpty()) {
                int n = listSelectionModel.getMinSelectionIndex();
                Shortcut shortcut = (Shortcut)this.panel.model.getValueAt(n, -1);
                this.panel.cbDefault.setSelected(!shortcut.getAssignedUser());
                this.panel.cbDisable.setSelected(shortcut.getKeyStroke() == null);
                this.panel.cbShift.setSelected(shortcut.getAssignedModifier() != -1 && (shortcut.getAssignedModifier() & 0x40) != 0);
                this.panel.cbCtrl.setSelected(shortcut.getAssignedModifier() != -1 && (shortcut.getAssignedModifier() & 0x80) != 0);
                this.panel.cbAlt.setSelected(shortcut.getAssignedModifier() != -1 && (shortcut.getAssignedModifier() & 0x200) != 0);
                this.panel.cbMeta.setSelected(shortcut.getAssignedModifier() != -1 && (shortcut.getAssignedModifier() & 0x100) != 0);
                if (shortcut.getKeyStroke() != null) {
                    prefJPanel.this.tfKey.setSelectedItem(keyList.get(shortcut.getKeyStroke().getKeyCode()));
                } else {
                    prefJPanel.this.tfKey.setSelectedItem(keyList.get(-1));
                }
                if (!shortcut.isChangeable()) {
                    this.panel.cbDefault.setEnabled(false);
                    this.panel.cbDisable.setEnabled(false);
                    this.panel.cbShift.setEnabled(false);
                    this.panel.cbCtrl.setEnabled(false);
                    this.panel.cbAlt.setEnabled(false);
                    this.panel.cbMeta.setEnabled(false);
                    this.panel.tfKey.setEnabled(false);
                } else {
                    this.panel.cbDefault.setEnabled(true);
                    this.actionPerformed(null);
                }
            } else {
                this.panel.cbDefault.setEnabled(false);
                this.panel.cbDisable.setEnabled(false);
                this.panel.cbShift.setEnabled(false);
                this.panel.cbCtrl.setEnabled(false);
                this.panel.cbAlt.setEnabled(false);
                this.panel.cbMeta.setEnabled(false);
                this.panel.tfKey.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ListSelectionModel listSelectionModel = this.panel.shortcutTable.getSelectionModel();
            if (listSelectionModel != null && !listSelectionModel.isSelectionEmpty()) {
                if (actionEvent != null) {
                    int bl = listSelectionModel.getMinSelectionIndex();
                    Shortcut shortcut = (Shortcut)this.panel.model.getValueAt(bl, -1);
                    shortcut.setAssignedUser(!this.panel.cbDefault.isSelected());
                    if (this.panel.cbDisable.isSelected()) {
                        shortcut.setAssignedModifier(-1);
                    } else if (this.panel.tfKey.getSelectedItem().equals("")) {
                        shortcut.setAssignedModifier(3);
                    } else {
                        shortcut.setAssignedModifier((this.panel.cbShift.isSelected() ? 64 : 0) | (this.panel.cbCtrl.isSelected() ? 128 : 0) | (this.panel.cbAlt.isSelected() ? 512 : 0) | (this.panel.cbMeta.isSelected() ? 256 : 0));
                        for (Map.Entry entry : keyList.entrySet()) {
                            if (!((String)entry.getValue()).equals(this.panel.tfKey.getSelectedItem())) continue;
                            shortcut.setAssignedKey((Integer)entry.getKey());
                        }
                    }
                    this.valueChanged(null);
                }
                boolean bl = !this.panel.cbDefault.isSelected();
                this.panel.cbDisable.setEnabled(bl);
                boolean bl2 = bl && !this.panel.cbDisable.isSelected();
                this.panel.cbShift.setEnabled(bl2);
                this.panel.cbCtrl.setEnabled(bl2);
                this.panel.cbAlt.setEnabled(bl2);
                this.panel.cbMeta.setEnabled(bl2);
                this.panel.tfKey.setEnabled(bl2);
            } else {
                this.panel.cbDefault.setEnabled(false);
                this.panel.cbDisable.setEnabled(false);
                this.panel.cbShift.setEnabled(false);
                this.panel.cbCtrl.setEnabled(false);
                this.panel.cbAlt.setEnabled(false);
                this.panel.cbMeta.setEnabled(false);
                this.panel.tfKey.setEnabled(false);
            }
        }
    }
}

