/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ProjectionPreference
implements PreferenceSetting {
    private JComboBox projectionCombo = new JComboBox<Projection>(Projection.allProjections);
    private JComboBox coordinatesCombo = new JComboBox<LatLon.CoordinateFormat>(LatLon.CoordinateFormat.values());

    public void addGui(PreferenceDialog preferenceDialog) {
        int n;
        for (n = 0; n < this.projectionCombo.getItemCount(); ++n) {
            if (!this.projectionCombo.getItemAt(n).getClass().getName().equals(Main.pref.get("projection", Mercator.class.getName()))) continue;
            this.projectionCombo.setSelectedIndex(n);
            break;
        }
        for (n = 0; n < this.coordinatesCombo.getItemCount(); ++n) {
            if (!((LatLon.CoordinateFormat)((Object)this.coordinatesCombo.getItemAt(n))).name().equals(Main.pref.get("coordinates"))) continue;
            this.coordinatesCombo.setSelectedIndex(n);
            break;
        }
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Display coordinates as")), GBC.std().insets(5, 5, 0, 5));
        jPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        jPanel.add((Component)this.coordinatesCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        jPanel.add((Component)new JLabel(I18n.tr("Projection method")), GBC.std().insets(5, 5, 0, 5));
        jPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        jPanel.add((Component)this.projectionCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        jPanel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        preferenceDialog.mapcontent.addTab(I18n.tr("Map Projection"), jScrollPane);
    }

    public boolean ok() {
        String string = this.projectionCombo.getSelectedItem().getClass().getName();
        if (Main.pref.put("projection", string)) {
            Main.setProjection(string);
        }
        if (Main.pref.put("coordinates", ((LatLon.CoordinateFormat)((Object)this.coordinatesCombo.getSelectedItem())).name())) {
            Node.setCoordinateFormat();
        }
        return false;
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new ProjectionPreference();
        }
    }
}

