/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.mappaint.ElemStyleHandler;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.ImageProvider;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MapPaintStyles {
    private static ElemStyles styles = new ElemStyles();
    private static Collection<String> iconDirs;

    public static ElemStyles getStyles() {
        return styles;
    }

    public static ImageIcon getIcon(String string, String string2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string3 : iconDirs) {
            String[] stringArray = string3.indexOf("=") >= 0 ? string3.split("=", 2) : new String[]{"", string3};
            if (stringArray[0].length() != 0 && !string2.equals(stringArray[0])) continue;
            linkedList.add(stringArray[1]);
        }
        Object object = ImageProvider.getIfAvailable(linkedList, "mappaint." + string2, null, string);
        if (object == null) {
            System.out.println("Mappaint-Style \"" + string2 + "\" icon \"" + string + "\" not found.");
            object = ImageProvider.getIfAvailable(linkedList, "mappaint." + string2, null, "misc/no_icon.png");
        }
        return object;
    }

    public static void readFromPreferences() {
        Object object;
        Object object2;
        iconDirs = Main.pref.getCollection("mappaint.icon.sources", Collections.<String>emptySet());
        if (Main.pref.getBoolean("mappaint.icon.enable-defaults", true)) {
            object2 = new LinkedList<String>(iconDirs);
            ((LinkedList)object2).add((String)"resource://images/styles/standard/");
            ((LinkedList)object2).add((String)"resource://images/styles/");
            iconDirs = object2;
        }
        object2 = Main.pref.getCollection("mappaint.style.sources", Collections.<String>emptySet());
        if (Main.pref.getBoolean("mappaint.style.enable-defaults", true)) {
            object = new LinkedList();
            ((LinkedList)object).add("resource://styles/standard/elemstyles.xml");
            ((LinkedList)object).addAll(object2);
            object2 = object;
        }
        object = object2.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            String[] stringArray = null;
            try {
                stringArray = string.indexOf("=") >= 0 ? string.split("=", 2) : new String[]{null, string};
                XMLReader xMLReader = XMLReaderFactory.createXMLReader();
                ElemStyleHandler elemStyleHandler = new ElemStyleHandler(stringArray[0]);
                xMLReader.setContentHandler(elemStyleHandler);
                xMLReader.setErrorHandler(elemStyleHandler);
                xMLReader.parse(new InputSource(new MirroredInputStream(stringArray[1])));
            }
            catch (Exception exception) {
                System.out.println("Mappaint-Style \"" + stringArray[0] + "\" file \"" + stringArray[1] + "\"");
                System.out.println("Mappaint-Style problems: " + exception);
                exception.printStackTrace();
            }
        }
        iconDirs = null;
    }
}

