/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.NodeListViewer;
import org.openstreetmap.josm.gui.history.RelationMemberListViewer;
import org.openstreetmap.josm.gui.history.TagInfoViewer;
import org.openstreetmap.josm.gui.history.VersionTable;
import org.openstreetmap.josm.tools.I18n;

public class HistoryBrowser
extends JPanel {
    private HistoryBrowserModel model = new HistoryBrowserModel();

    protected JScrollPane embeddInScrollPane(JTable jTable) {
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        return jScrollPane;
    }

    protected JPanel createVersionTablePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        VersionTable versionTable = new VersionTable(this.model);
        jPanel.add((Component)this.embeddInScrollPane(versionTable), "Center");
        return jPanel;
    }

    protected JPanel createVersionComparePanel() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(new TagInfoViewer(this.model));
        jTabbedPane.setTitleAt(0, I18n.tr("Tags"));
        jTabbedPane.add(new NodeListViewer(this.model));
        jTabbedPane.setTitleAt(1, I18n.tr("Nodes"));
        jTabbedPane.add(new RelationMemberListViewer(this.model));
        jTabbedPane.setTitleAt(2, I18n.tr("Members"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTabbedPane, "Center");
        return jPanel;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.createVersionTablePanel();
        JPanel jPanel2 = this.createVersionComparePanel();
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, jPanel2);
        this.add((Component)jSplitPane, "Center");
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(150);
        Dimension dimension = new Dimension(100, 50);
        jPanel.setMinimumSize(dimension);
        jPanel2.setMinimumSize(dimension);
    }

    public HistoryBrowser() {
        this.build();
    }

    public HistoryBrowser(History history) {
        this();
        this.populate(history);
    }

    public void populate(History history) {
        this.model.setHistory(history);
    }

    public History getHistory() {
        return this.model.getHistory();
    }

    public HistoryBrowserModel getModel() {
        return this.model;
    }
}

