/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Adjustable;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBox;
import org.openstreetmap.josm.tools.I18n;

public class AdjustmentSynchronizer
implements AdjustmentListener {
    private final ArrayList<Adjustable> synchronizedAdjustables = new ArrayList();
    private final HashMap<Adjustable, Boolean> enabledMap = new HashMap();
    private final Observable observable = new Observable();

    public void participateInSynchronizedScrolling(Adjustable adjustable) {
        if (adjustable == null) {
            return;
        }
        if (this.synchronizedAdjustables.contains(adjustable)) {
            return;
        }
        this.synchronizedAdjustables.add(adjustable);
        this.setParticipatingInSynchronizedScrolling(adjustable, true);
        adjustable.addAdjustmentListener(this);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (!this.enabledMap.get(adjustmentEvent.getAdjustable()).booleanValue()) {
            return;
        }
        for (Adjustable adjustable : this.synchronizedAdjustables) {
            if (adjustable == adjustmentEvent.getAdjustable() || !this.isParticipatingInSynchronizedScrolling(adjustable)) continue;
            adjustable.setValue(adjustmentEvent.getValue());
        }
    }

    protected void setParticipatingInSynchronizedScrolling(Adjustable adjustable, boolean bl) {
        if (adjustable == null) {
            throw new IllegalArgumentException(I18n.tr("parameter '{0}' must not be null", "adjustable"));
        }
        if (!this.synchronizedAdjustables.contains(adjustable)) {
            throw new IllegalStateException(I18n.tr("adjustable {0} not registered yet. Can't set participation in synchronized adjustment", adjustable));
        }
        this.enabledMap.put(adjustable, bl);
        this.observable.notifyObservers();
    }

    protected boolean isParticipatingInSynchronizedScrolling(Adjustable adjustable) throws IllegalStateException {
        if (!this.synchronizedAdjustables.contains(adjustable)) {
            throw new IllegalStateException(I18n.tr("adjustable {0} not registered yet", adjustable));
        }
        return this.enabledMap.get(adjustable);
    }

    protected void adapt(final JCheckBox jCheckBox, final Adjustable adjustable) throws IllegalArgumentException, IllegalStateException {
        if (adjustable == null) {
            throw new IllegalArgumentException(I18n.tr("parameter '{0}' must not be null", "adjustable"));
        }
        if (jCheckBox == null) {
            throw new IllegalArgumentException(I18n.tr("parameter '{0}' must not be null", "view"));
        }
        if (!this.synchronizedAdjustables.contains(adjustable)) {
            this.participateInSynchronizedScrolling(adjustable);
        }
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                switch (itemEvent.getStateChange()) {
                    case 1: {
                        if (AdjustmentSynchronizer.this.isParticipatingInSynchronizedScrolling(adjustable)) break;
                        AdjustmentSynchronizer.this.setParticipatingInSynchronizedScrolling(adjustable, true);
                        break;
                    }
                    case 2: {
                        if (!AdjustmentSynchronizer.this.isParticipatingInSynchronizedScrolling(adjustable)) break;
                        AdjustmentSynchronizer.this.setParticipatingInSynchronizedScrolling(adjustable, false);
                    }
                }
            }
        });
        this.observable.addObserver(new Observer(){

            public void update(Observable observable, Object object) {
                boolean bl = AdjustmentSynchronizer.this.isParticipatingInSynchronizedScrolling(adjustable);
                if (jCheckBox.isSelected() != bl) {
                    jCheckBox.setSelected(bl);
                }
            }
        });
        this.setParticipatingInSynchronizedScrolling(adjustable, true);
        jCheckBox.setSelected(true);
    }
}

