/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.Vector;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationNodeMap {
    private HashMap<Node, TreeSet<Integer>> points;
    private HashMap<Node, Integer> nodes;
    private Vector<Integer> remaining;
    private Relation relation;

    RelationNodeMap(Relation relation) {
        this.relation = relation;
        this.points = new HashMap();
        this.nodes = new HashMap();
        this.remaining = new Vector();
        for (int i = 0; i < relation.members.size(); ++i) {
            RelationMember relationMember = relation.members.get(i);
            if (relationMember.member.incomplete) {
                return;
            }
            this.add(i, relationMember);
        }
    }

    Integer find(Node node, int n) {
        Integer n2 = null;
        try {
            n2 = this.nodes.get(node);
            if (n2 == null) {
                n2 = this.points.get(node).first();
                if (this.relation.members.get((int)n).member == this.relation.members.get((int)n2.intValue()).member) {
                    n2 = this.points.get(node).last();
                }
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return n2;
    }

    void add(int n, RelationMember relationMember) {
        try {
            Way way = (Way)relationMember.member;
            if (!this.points.containsKey(way.firstNode())) {
                this.points.put(way.firstNode(), new TreeSet());
            }
            this.points.get(way.firstNode()).add(n);
            if (!this.points.containsKey(way.lastNode())) {
                this.points.put(way.lastNode(), new TreeSet());
            }
            this.points.get(way.lastNode()).add(n);
        }
        catch (ClassCastException classCastException) {
            try {
                Node node = (Node)relationMember.member;
                this.nodes.put(node, n);
            }
            catch (ClassCastException classCastException2) {
                this.remaining.add(n);
            }
        }
    }

    boolean remove(int n, RelationMember relationMember) {
        boolean bl;
        try {
            bl = this.points.get(((Way)relationMember.member).firstNode()).remove(n);
            bl &= this.points.get(((Way)relationMember.member).lastNode()).remove(n);
        }
        catch (ClassCastException classCastException) {
            bl = this.nodes.remove(relationMember.member) != null;
        }
        return bl;
    }

    void move(int n, int n2) {
        if (n != n2) {
            RelationMember relationMember = this.relation.members.get(n);
            RelationMember relationMember2 = this.relation.members.get(n2);
            this.remove(n2, relationMember);
            this.add(n2, relationMember2);
        }
    }

    boolean isEmpty() {
        return this.points.isEmpty() && this.nodes.isEmpty();
    }

    Vector<Integer> getRemaining() {
        return this.remaining;
    }

    Integer pop() {
        Integer n = null;
        if (!this.nodes.isEmpty()) {
            n = this.nodes.values().iterator().next();
            this.nodes.remove(n);
        } else if (!this.points.isEmpty()) {
            for (TreeSet<Integer> treeSet : this.points.values()) {
                if (treeSet.isEmpty()) continue;
                n = treeSet.first();
                break;
            }
        }
        return n;
    }
}

