/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserListDialog
extends ToggleDialog
implements SelectionChangedListener,
MouseListener {
    private final DefaultTableModel data = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return n == 0 ? String.class : Integer.class;
        }
    };
    private JTable userTable = new JTable(this.data);
    private static User anonymousUser = User.get("(anonymous users)");

    public UserListDialog() {
        super(I18n.tr("Authors"), "userlist", I18n.tr("Open a list of people working on the selected objects."), Shortcut.registerShortcut("subwindow:authors", I18n.tr("Toggle: {0}", I18n.tr("Authors")), 65, 4, 1), 150);
        this.data.setColumnIdentifiers(new String[]{I18n.tr("Author"), I18n.tr("# Objects"), "%"});
        this.userTable.setSelectionMode(0);
        this.add((Component)new JScrollPane(this.userTable), "Center");
        this.selectionChanged(Main.ds.getSelected());
        this.userTable.addMouseListener(this);
        DataSet.selListeners.add(this);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.selectionChanged(Main.ds.getSelected());
        }
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        if (!this.isVisible()) {
            return;
        }
        if (this.data == null) {
            return;
        }
        this.data.setRowCount(0);
        class UserCount {
            User user;
            int count;

            UserCount(User user, int n) {
                this.user = user;
                this.count = n;
            }
        }
        HashMap<User, UserCount> hashMap = new HashMap<User, UserCount>();
        int n = 0;
        for (OsmPrimitive userCountArray : collection) {
            UserCount userCount;
            User user = userCountArray.user;
            if (user == null) {
                user = anonymousUser;
            }
            if ((userCount = (UserCount)hashMap.get(user)) == null) {
                userCount = new UserCount(user, 0);
                hashMap.put(user, userCount);
            }
            ++userCount.count;
            ++n;
        }
        UserCount[] userCountArray = new UserCount[hashMap.size()];
        hashMap.values().toArray(userCountArray);
        Arrays.sort(userCountArray, new Comparator<UserCount>(){

            @Override
            public int compare(UserCount userCount, UserCount userCount2) {
                return userCount.count < userCount2.count ? 1 : (userCount.count > userCount2.count ? -1 : 0);
            }
        });
        for (UserCount userCount : userCountArray) {
            this.data.addRow(new Object[]{userCount.user.name, userCount.count, userCount.count * 100 / n});
        }
        if (userCountArray.length != 0) {
            this.setTitle(I18n.tr("Authors: {0}", userCountArray.length), true);
        } else {
            this.setTitle(I18n.tr("Authors"), false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
            int n = this.userTable.getSelectedRow();
            String string = (String)this.data.getValueAt(n, 0);
            if (string == null) {
                return;
            }
            Collection<OsmPrimitive> collection = Main.ds.getSelected();
            LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
            for (OsmPrimitive osmPrimitive : collection) {
                if (osmPrimitive.user == null || !string.equals(osmPrimitive.user.name)) continue;
                linkedList.add(osmPrimitive);
            }
            Main.ds.setSelected(linkedList);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

