/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.nodes;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.WayNodesConflictResolverCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.ListMergeModel;
import org.openstreetmap.josm.gui.conflict.ListRole;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeListMergeModel
extends ListMergeModel<Node> {
    private static final Logger logger = Logger.getLogger(NodeListMergeModel.class.getName());

    public void populate(Way way, Way way2) {
        if (way == null) {
            throw new IllegalArgumentException(I18n.tr("parameter '{0}' must not be null", "my"));
        }
        if (way2 == null) {
            throw new IllegalArgumentException(I18n.tr("parameter '{0}' must not be null", "their"));
        }
        this.getMergedEntries().clear();
        this.getMyEntries().clear();
        this.getTheirEntries().clear();
        for (Node node : way.nodes) {
            this.getMyEntries().add(node);
        }
        for (Node node : way2.nodes) {
            this.getTheirEntries().add(node);
        }
        if (this.myAndTheirEntriesEqual()) {
            this.entries.put(ListRole.MERGED_ENTRIES, new ArrayList(this.getMyEntries()));
            this.setFrozen(true);
        } else {
            this.setFrozen(false);
        }
        this.fireModelDataChanged();
    }

    public WayNodesConflictResolverCommand buildResolveCommand(Way way, Way way2) {
        if (way == null) {
            throw new IllegalArgumentException(I18n.tr("parameter '{0}' must not be null", "my"));
        }
        if (way2 == null) {
            throw new IllegalArgumentException(I18n.tr("parameter '{0}' must not be null", "their"));
        }
        if (!this.isFrozen()) {
            throw new IllegalArgumentException(I18n.tr("Merged nodes not frozen yet. Can't build resolution command"));
        }
        return new WayNodesConflictResolverCommand(way, way2, this.getMergedEntries());
    }

    @Override
    public boolean isEqualEntry(Node node, Node node2) {
        if (node.id > 0L) {
            return node.id == node2.id;
        }
        return node == node2;
    }

    @Override
    protected void setValueAt(DefaultTableModel defaultTableModel, Object object, int n, int n2) {
    }

    @Override
    protected Node cloneEntryForMergedList(Node node) {
        return node;
    }
}

