/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.MoveAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapMover;
import org.openstreetmap.josm.gui.MapScaler;
import org.openstreetmap.josm.gui.MapSlider;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapView
extends NavigatableComponent {
    private ArrayList<Layer> layers = new ArrayList();
    public PlayHeadMarker playHeadMarker = null;
    private Layer activeLayer;
    public MouseEvent lastMEvent;
    private LinkedList<MapViewPaintable> temporaryLayers = new LinkedList();
    private BufferedImage offscreenBuffer;
    private boolean virtualNodesEnabled = false;

    public MapView() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MapView.this.removeComponentListener(this);
                MapSlider mapSlider = new MapSlider(MapView.this);
                MapView.this.add(mapSlider);
                mapSlider.setBounds(3, 0, 114, 30);
                MapScaler mapScaler = new MapScaler(MapView.this);
                MapView.this.add(mapScaler);
                mapScaler.setLocation(10, 30);
                if (!MapView.this.zoomToEditLayerBoundingBox()) {
                    new AutoScaleAction("data").actionPerformed(null);
                }
                new MapMover(MapView.this, Main.contentPane);
                MoveAction moveAction = new MoveAction(MoveAction.Direction.UP);
                if (moveAction.getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(moveAction.getShortcut().getKeyStroke(), "UP");
                    Main.contentPane.getActionMap().put("UP", moveAction);
                }
                if ((moveAction = new MoveAction(MoveAction.Direction.DOWN)).getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(moveAction.getShortcut().getKeyStroke(), "DOWN");
                    Main.contentPane.getActionMap().put("DOWN", moveAction);
                }
                if ((moveAction = new MoveAction(MoveAction.Direction.LEFT)).getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(moveAction.getShortcut().getKeyStroke(), "LEFT");
                    Main.contentPane.getActionMap().put("LEFT", moveAction);
                }
                if ((moveAction = new MoveAction(MoveAction.Direction.RIGHT)).getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(moveAction.getShortcut().getKeyStroke(), "RIGHT");
                    Main.contentPane.getActionMap().put("RIGHT", moveAction);
                }
            }
        });
        DataSet.selListeners.add(new SelectionChangedListener(){

            @Override
            public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
                MapView.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
                this.mouseMoved(mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                MapView.this.lastMEvent = mouseEvent;
            }
        });
    }

    public void addLayer(Layer layer) {
        int n;
        if (layer instanceof OsmDataLayer) {
            OsmDataLayer osmDataLayer = (OsmDataLayer)layer;
            Main.ds = osmDataLayer.data;
            osmDataLayer.listenerModified.add(new OsmDataLayer.ModifiedChangedListener(){

                public void modifiedChanged(boolean bl, OsmDataLayer osmDataLayer) {
                    JOptionPane.getFrameForComponent(Main.parent).setTitle((bl ? "*" : "") + I18n.tr("Java OpenStreetMap Editor"));
                }
            });
        }
        if (layer instanceof MarkerLayer && this.playHeadMarker == null) {
            this.playHeadMarker = PlayHeadMarker.create();
        }
        for (n = this.layers.size(); n > 0 && this.layers.get((int)(n - 1)).background; --n) {
        }
        this.layers.add(n, layer);
        for (Layer.LayerChangeListener object : Layer.listeners) {
            object.layerAdded(layer);
        }
        if (layer instanceof OsmDataLayer || this.activeLayer == null) {
            Layer layer2 = this.activeLayer;
            this.setActiveLayer(layer);
            for (Layer.LayerChangeListener layerChangeListener : Layer.listeners) {
                layerChangeListener.activeLayerChange(layer2, layer);
            }
        }
        AudioPlayer.reset();
        this.repaint();
    }

    @Override
    protected DataSet getData() {
        if (this.activeLayer != null && this.activeLayer instanceof OsmDataLayer) {
            return ((OsmDataLayer)this.activeLayer).data;
        }
        return new DataSet();
    }

    public boolean isActiveLayerDrawable() {
        return this.activeLayer != null && this.activeLayer instanceof OsmDataLayer;
    }

    public boolean isActiveLayerVisible() {
        return this.isActiveLayerDrawable() && this.activeLayer.visible;
    }

    public void removeLayer(Layer layer) {
        if (this.layers.remove(layer)) {
            for (Layer.LayerChangeListener layerChangeListener : Layer.listeners) {
                layerChangeListener.layerRemoved(layer);
            }
        }
        if (layer == this.activeLayer && layer instanceof OsmDataLayer) {
            Main.ds = null;
        }
        layer.destroy();
        AudioPlayer.reset();
    }

    public void setVirtualNodesEnabled(boolean bl) {
        if (this.virtualNodesEnabled != bl) {
            this.virtualNodesEnabled = bl;
            this.repaint();
        }
    }

    public boolean isVirtualNodesEnabled() {
        return this.virtualNodesEnabled;
    }

    public void moveLayer(Layer layer, int n) {
        int n2 = this.layers.indexOf(layer);
        if (n2 == -1) {
            throw new IllegalArgumentException(I18n.tr("layer not in list."));
        }
        if (n == n2) {
            return;
        }
        this.layers.remove(n2);
        if (n >= this.layers.size()) {
            this.layers.add(layer);
        } else {
            this.layers.add(n, layer);
        }
        AudioPlayer.reset();
    }

    public int getLayerPos(Layer layer) {
        int n = this.layers.indexOf(layer);
        if (n == -1) {
            throw new IllegalArgumentException(I18n.tr("layer not in list."));
        }
        return n;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.center == null) {
            return;
        }
        if (null == this.offscreenBuffer || this.offscreenBuffer.getWidth() != this.getWidth() || this.offscreenBuffer.getHeight() != this.getHeight()) {
            this.offscreenBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        }
        Graphics2D graphics2D = this.offscreenBuffer.createGraphics();
        graphics2D.setColor(Main.pref.getColor("background", Color.BLACK));
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            Layer object2 = this.layers.get(i);
            if (!object2.visible) continue;
            object2.paint(graphics2D, this);
        }
        for (MapViewPaintable mapViewPaintable : this.temporaryLayers) {
            mapViewPaintable.paint(graphics2D, this);
        }
        graphics2D.setColor(Color.WHITE);
        ProjectionBounds projectionBounds = this.getProjection().getWorldBounds();
        Point point = this.getPoint(projectionBounds.min);
        Point point2 = this.getPoint(projectionBounds.max);
        int n = Math.min(point.x, point2.x);
        int n2 = Math.min(point.y, point2.y);
        int n3 = Math.max(point.x, point2.x);
        int n4 = Math.max(point.y, point2.y);
        if (n > 0 || n2 > 0 || n3 < this.getWidth() || n4 < this.getHeight()) {
            graphics2D.drawRect(n, n2, n3 - n + 1, n4 - n2 + 1);
        }
        if (this.playHeadMarker != null) {
            this.playHeadMarker.paint(graphics2D, this);
        }
        graphics.drawImage(this.offscreenBuffer, 0, 0, null);
        super.paint(graphics);
    }

    public void recalculateCenterScale(BoundingXYVisitor boundingXYVisitor) {
        if (boundingXYVisitor == null) {
            boundingXYVisitor = new BoundingXYVisitor();
        }
        if (boundingXYVisitor.getBounds() == null) {
            boundingXYVisitor.visit(this.getProjection().getWorldBounds());
        }
        if (!boundingXYVisitor.hasExtend()) {
            boundingXYVisitor.enlargeBoundingBox();
        }
        this.zoomTo(boundingXYVisitor.getBounds());
    }

    public Collection<Layer> getAllLayers() {
        return Collections.unmodifiableCollection(this.layers);
    }

    public void setActiveLayer(Layer layer) {
        Layer layer2;
        if (!this.layers.contains(layer)) {
            throw new IllegalArgumentException(I18n.tr("Layer {0} must be in list of layers", layer.toString()));
        }
        if (layer instanceof OsmDataLayer) {
            layer2 = (OsmDataLayer)layer;
            Main.ds = layer2.data;
        } else {
            Main.ds.setSelected(new OsmPrimitive[0]);
        }
        DataSet.fireSelectionChanged(Main.ds.getSelected());
        layer2 = this.activeLayer;
        this.activeLayer = layer;
        if (layer2 != layer) {
            for (Layer.LayerChangeListener object : Layer.listeners) {
                object.activeLayerChange(layer2, layer);
            }
        }
        Enumeration<AbstractButton> enumeration = Main.map.toolGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = (AbstractButton)enumeration.nextElement();
            abstractButton.setEnabled(((MapMode)abstractButton.getAction()).layerIsSupported(layer));
        }
        AudioPlayer.reset();
        this.repaint();
    }

    public Layer getActiveLayer() {
        return this.activeLayer;
    }

    public OsmDataLayer getEditLayer() {
        if (this.activeLayer instanceof OsmDataLayer) {
            return (OsmDataLayer)this.activeLayer;
        }
        return null;
    }

    public boolean hasLayer(Layer layer) {
        return this.layers.contains(layer);
    }

    public boolean zoomToEditLayerBoundingBox() {
        Collection<DataSource> collection = Main.main.createOrGetEditLayer().data.dataSources;
        BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
        for (DataSource dataSource : collection) {
            boundingXYVisitor.visit(dataSource.bounds);
            if (!boundingXYVisitor.hasExtend()) continue;
            this.recalculateCenterScale(boundingXYVisitor);
            return true;
        }
        return false;
    }

    public boolean addTemporaryLayer(MapViewPaintable mapViewPaintable) {
        if (this.temporaryLayers.contains(mapViewPaintable)) {
            return false;
        }
        return this.temporaryLayers.add(mapViewPaintable);
    }

    public boolean removeTemporaryLayer(MapViewPaintable mapViewPaintable) {
        return this.temporaryLayers.remove(mapViewPaintable);
    }
}

