/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.HelpAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.NameVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MapStatus
extends JPanel
implements HelpAction.Helpful {
    final MapView mv;
    ImageLabel lonText = new ImageLabel("lon", I18n.tr("The geographic longitude at the mouse pointer."), 11);
    ImageLabel nameText = new ImageLabel("name", I18n.tr("The name of the object at the mouse pointer."), 20);
    JTextField helpText = new JTextField();
    ImageLabel latText = new ImageLabel("lat", I18n.tr("The geographic latitude at the mouse pointer."), 10);
    ImageLabel angleText = new ImageLabel("angle", I18n.tr("The angle between the previous and the current way segment."), 6);
    ImageLabel headingText = new ImageLabel("heading", I18n.tr("The (compass) heading of the line segment being drawn."), 6);
    ImageLabel distText = new ImageLabel("dist", I18n.tr("The length of the new way segment being drawn."), 8);
    public Thread thread;
    MouseState mouseState = new MouseState();

    public MapStatus(final MapFrame mapFrame) {
        this.mv = mapFrame.mapView;
        this.mv.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
                this.mouseMoved(mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (MapStatus.this.mv.center == null) {
                    return;
                }
                if ((mouseEvent.getModifiersEx() & 0x80) == 0) {
                    LatLon.CoordinateFormat coordinateFormat = Node.getCoordinateFormat();
                    LatLon latLon = MapStatus.this.mv.getLatLon(mouseEvent.getX(), mouseEvent.getY());
                    MapStatus.this.latText.setText(latLon.latToString(coordinateFormat));
                    MapStatus.this.lonText.setText(latLon.lonToString(coordinateFormat));
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.latText, GBC.std());
        this.add((Component)this.lonText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.headingText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.angleText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.distText, GBC.std().insets(3, 0, 0, 0));
        this.helpText.setEditable(false);
        this.add((Component)this.nameText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.helpText, GBC.eol().insets(3, 0, 0, 0).fill(2));
        final Collector collector = new Collector(mapFrame);
        this.thread = new Thread((Runnable)collector, "Map Status Collector");
        this.thread.setDaemon(true);
        this.thread.start();
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void eventDispatched(AWTEvent aWTEvent) {
                    if (aWTEvent instanceof ComponentEvent && ((ComponentEvent)aWTEvent).getComponent() == mapFrame.mapView) {
                        Collector collector2 = collector;
                        synchronized (collector2) {
                            MapStatus.this.mouseState.modifiers = ((InputEvent)aWTEvent).getModifiersEx();
                            if (aWTEvent instanceof MouseEvent) {
                                MapStatus.this.mouseState.mousePos = ((MouseEvent)aWTEvent).getPoint();
                            }
                            collector.notify();
                        }
                    }
                }
            }, 56L);
        }
        catch (SecurityException securityException) {
            mapFrame.mapView.addMouseMotionListener(new MouseMotionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void mouseMoved(MouseEvent mouseEvent) {
                    Collector collector2 = collector;
                    synchronized (collector2) {
                        MapStatus.this.mouseState.modifiers = mouseEvent.getModifiersEx();
                        MapStatus.this.mouseState.mousePos = mouseEvent.getPoint();
                        collector.notify();
                    }
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    this.mouseMoved(mouseEvent);
                }
            });
            mapFrame.mapView.addKeyListener(new KeyAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void keyPressed(KeyEvent keyEvent) {
                    Collector collector2 = collector;
                    synchronized (collector2) {
                        MapStatus.this.mouseState.modifiers = keyEvent.getModifiersEx();
                        collector.notify();
                    }
                }

                public void keyReleased(KeyEvent keyEvent) {
                    this.keyPressed(keyEvent);
                }
            });
        }
    }

    public String helpTopic() {
        return "Statusline";
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.lonText.addMouseListener(mouseListener);
        this.latText.addMouseListener(mouseListener);
    }

    public void setHelpText(String string) {
        this.helpText.setText(string);
        this.helpText.setToolTipText(string);
    }

    public void setAngle(double d) {
        this.angleText.setText(d < 0.0 ? "--" : (double)Math.round(d * 10.0) / 10.0 + " \u00c2\u00b0");
    }

    public void setHeading(double d) {
        this.headingText.setText(d < 0.0 ? "--" : (double)Math.round(d * 10.0) / 10.0 + " \u00c2\u00b0");
    }

    public void setDist(double d) {
        String string = d > 1000.0 ? (double)Math.round(d / 100.0) / 10.0 + " km" : (double)Math.round(d * 10.0) / 10.0 + " m";
        this.distText.setText(d < 0.0 ? "--" : string);
    }

    class MouseState {
        Point mousePos;
        int modifiers;

        MouseState() {
        }
    }

    private final class Collector
    implements Runnable {
        Collection<OsmPrimitive> osmStatus;
        private int oldModifiers;
        private Popup popup;
        private MapFrame parent;

        public Collector(MapFrame mapFrame) {
            this.parent = mapFrame;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                MouseState mouseState = new MouseState();
                Object object = this;
                synchronized (object) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    mouseState.modifiers = MapStatus.this.mouseState.modifiers;
                    mouseState.mousePos = MapStatus.this.mouseState.mousePos;
                }
                if (this.parent != Main.map) {
                    return;
                }
                if ((mouseState.modifiers & 0x80) != 0 || mouseState.mousePos == null || MapStatus.this.mv.center == null) continue;
                try {
                    Collection<OsmPrimitive> collection;
                    object = null;
                    object = MapStatus.this.mv.getNearest(mouseState.mousePos);
                    if (object != null) {
                        collection = new NameVisitor();
                        ((OsmPrimitive)object).visit((Visitor)((Object)collection));
                        MapStatus.this.nameText.setText(((NameVisitor)((Object)collection)).name);
                    } else {
                        MapStatus.this.nameText.setText(I18n.tr("(no object)"));
                    }
                    if ((mouseState.modifiers & 0x800) != 0) {
                        collection = MapStatus.this.mv.getAllNearest(mouseState.mousePos);
                        if (collection == null || collection != null && ((Object)collection).equals(this.osmStatus) && mouseState.modifiers == this.oldModifiers) continue;
                        if (this.popup != null) {
                            try {
                                EventQueue.invokeAndWait(new Runnable(){

                                    public void run() {
                                        Collector.this.popup.hide();
                                    }
                                });
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                throw new RuntimeException(invocationTargetException);
                            }
                        }
                        JPanel jPanel = new JPanel(new GridBagLayout());
                        for (final OsmPrimitive osmPrimitive : collection) {
                            NameVisitor nameVisitor = new NameVisitor();
                            osmPrimitive.visit(nameVisitor);
                            final StringBuilder stringBuilder = new StringBuilder();
                            if (osmPrimitive.id == 0L || osmPrimitive.modified) {
                                nameVisitor.name = "<i><b>" + nameVisitor.name + "*</b></i>";
                            }
                            stringBuilder.append(nameVisitor.name);
                            if (osmPrimitive.id != 0L) {
                                stringBuilder.append("<br>id=" + osmPrimitive.id);
                            }
                            for (Map.Entry<String, String> entry : osmPrimitive.entrySet()) {
                                stringBuilder.append("<br>" + entry.getKey() + "=" + entry.getValue());
                            }
                            final JLabel jLabel = new JLabel("<html>" + stringBuilder.toString() + "</html>", nameVisitor.icon, 0);
                            jLabel.setFont(jLabel.getFont().deriveFont(0));
                            jLabel.setVerticalTextPosition(1);
                            jLabel.setCursor(Cursor.getPredefinedCursor(12));
                            jLabel.addMouseListener(new MouseAdapter(){

                                public void mouseEntered(MouseEvent mouseEvent) {
                                    jLabel.setText("<html><u color='blue'>" + stringBuilder.toString() + "</u></html>");
                                }

                                public void mouseExited(MouseEvent mouseEvent) {
                                    jLabel.setText("<html>" + stringBuilder.toString() + "</html>");
                                }

                                public void mouseClicked(MouseEvent mouseEvent) {
                                    Main.ds.setSelected(osmPrimitive);
                                    MapStatus.this.mv.repaint();
                                }
                            });
                            jPanel.add((Component)jLabel, GBC.eol());
                        }
                        Point point = MapStatus.this.mv.getLocationOnScreen();
                        final Popup object22 = this.popup = PopupFactory.getSharedInstance().getPopup(MapStatus.this.mv, jPanel, point.x + mouseState.mousePos.x + 16, point.y + mouseState.mousePos.y + 16);
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                object22.show();
                            }
                        });
                        continue;
                    }
                    if (this.popup == null) continue;
                    collection = this.popup;
                    this.popup = null;
                    EventQueue.invokeLater(new Runnable((Popup)((Object)collection)){
                        final /* synthetic */ Popup val$staticPopup;
                        {
                            this.val$staticPopup = popup;
                        }

                        public void run() {
                            this.val$staticPopup.hide();
                        }
                    });
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                }
                catch (NullPointerException nullPointerException) {
                }
            }
        }
    }

    class ImageLabel
    extends JPanel {
        private JLabel tf;
        private int chars;

        public ImageLabel(String string, String string2, int n) {
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.decode("#b8cfe5"));
            this.add((Component)new JLabel(ImageProvider.get("statusline/" + string + ".png")), GBC.std().anchor(17).insets(0, 1, 1, 0));
            this.tf = new JLabel();
            this.add((Component)this.tf, GBC.std().fill(1).anchor(17).insets(2, 1, 1, 0));
            this.setToolTipText(string2);
            this.chars = n;
        }

        public void setText(String string) {
            this.tf.setText(string);
        }

        public Dimension getPreferredSize() {
            return new Dimension(25 + this.chars * this.tf.getFontMetrics(this.tf.getFont()).charWidth('0'), super.getPreferredSize().height);
        }

        public Dimension getMinimumSize() {
            return new Dimension(25 + this.chars * this.tf.getFontMetrics(this.tf.getFont()).charWidth('0'), super.getMinimumSize().height);
        }
    }
}

