/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.tools.I18n;

public class UTM
implements Projection {
    private final double UTMScaleFactor = 0.9996;
    private final double sm_EccSquared = 0.00669437999013;

    private double ArcLengthOfMeridian(double d) {
        double d2 = (Ellipsoid.GRS80.a - Ellipsoid.GRS80.b) / (Ellipsoid.GRS80.a + Ellipsoid.GRS80.b);
        double d3 = (Ellipsoid.GRS80.a + Ellipsoid.GRS80.b) / 2.0 * (1.0 + Math.pow(d2, 2.0) / 4.0 + Math.pow(d2, 4.0) / 64.0);
        double d4 = -3.0 * d2 / 2.0 + 9.0 * Math.pow(d2, 3.0) / 16.0 + -3.0 * Math.pow(d2, 5.0) / 32.0;
        double d5 = 15.0 * Math.pow(d2, 2.0) / 16.0 + -15.0 * Math.pow(d2, 4.0) / 32.0;
        double d6 = -35.0 * Math.pow(d2, 3.0) / 48.0 + 105.0 * Math.pow(d2, 5.0) / 256.0;
        double d7 = 315.0 * Math.pow(d2, 4.0) / 512.0;
        return d3 * (d + d4 * Math.sin(2.0 * d) + d5 * Math.sin(4.0 * d) + d6 * Math.sin(6.0 * d) + d7 * Math.sin(8.0 * d));
    }

    private double UTMCentralMeridian(int n) {
        return Math.toRadians(-183.0 + (double)n * 6.0);
    }

    private double UTMCentralMeridianDeg(int n) {
        return -183.0 + (double)n * 6.0;
    }

    private double FootpointLatitude(double d) {
        double d2 = (Ellipsoid.GRS80.a - Ellipsoid.GRS80.b) / (Ellipsoid.GRS80.a + Ellipsoid.GRS80.b);
        double d3 = (Ellipsoid.GRS80.a + Ellipsoid.GRS80.b) / 2.0 * (1.0 + Math.pow(d2, 2.0) / 4.0 + Math.pow(d2, 4.0) / 64.0);
        double d4 = d / d3;
        double d5 = 3.0 * d2 / 2.0 + -27.0 * Math.pow(d2, 3.0) / 32.0 + 269.0 * Math.pow(d2, 5.0) / 512.0;
        double d6 = 21.0 * Math.pow(d2, 2.0) / 16.0 + -55.0 * Math.pow(d2, 4.0) / 32.0;
        double d7 = 151.0 * Math.pow(d2, 3.0) / 96.0 + -417.0 * Math.pow(d2, 5.0) / 128.0;
        double d8 = 1097.0 * Math.pow(d2, 4.0) / 512.0;
        return d4 + d5 * Math.sin(2.0 * d4) + d6 * Math.sin(4.0 * d4) + d7 * Math.sin(6.0 * d4) + d8 * Math.sin(8.0 * d4);
    }

    public EastNorth MapLatLonToXY(double d, double d2, double d3) {
        double d4 = (Math.pow(Ellipsoid.GRS80.a, 2.0) - Math.pow(Ellipsoid.GRS80.b, 2.0)) / Math.pow(Ellipsoid.GRS80.b, 2.0);
        double d5 = d4 * Math.pow(Math.cos(d), 2.0);
        double d6 = Math.pow(Ellipsoid.GRS80.a, 2.0) / (Ellipsoid.GRS80.b * Math.sqrt(1.0 + d5));
        double d7 = Math.tan(d);
        double d8 = d7 * d7;
        double d9 = d8 * d8 * d8 - Math.pow(d7, 6.0);
        double d10 = d2 - d3;
        double d11 = 1.0 - d8 + d5;
        double d12 = 5.0 - d8 + 9.0 * d5 + 4.0 * (d5 * d5);
        double d13 = 5.0 - 18.0 * d8 + d8 * d8 + 14.0 * d5 - 58.0 * d8 * d5;
        double d14 = 61.0 - 58.0 * d8 + d8 * d8 + 270.0 * d5 - 330.0 * d8 * d5;
        double d15 = 61.0 - 479.0 * d8 + 179.0 * (d8 * d8) - d8 * d8 * d8;
        double d16 = 1385.0 - 3111.0 * d8 + 543.0 * (d8 * d8) - d8 * d8 * d8;
        return new EastNorth(d6 * Math.cos(d) * d10 + d6 / 6.0 * Math.pow(Math.cos(d), 3.0) * d11 * Math.pow(d10, 3.0) + d6 / 120.0 * Math.pow(Math.cos(d), 5.0) * d13 * Math.pow(d10, 5.0) + d6 / 5040.0 * Math.pow(Math.cos(d), 7.0) * d15 * Math.pow(d10, 7.0), this.ArcLengthOfMeridian(d) + d7 / 2.0 * d6 * Math.pow(Math.cos(d), 2.0) * Math.pow(d10, 2.0) + d7 / 24.0 * d6 * Math.pow(Math.cos(d), 4.0) * d12 * Math.pow(d10, 4.0) + d7 / 720.0 * d6 * Math.pow(Math.cos(d), 6.0) * d14 * Math.pow(d10, 6.0) + d7 / 40320.0 * d6 * Math.pow(Math.cos(d), 8.0) * d16 * Math.pow(d10, 8.0));
    }

    public LatLon MapXYToLatLon(double d, double d2, double d3) {
        double d4;
        double d5 = this.FootpointLatitude(d2);
        double d6 = (Math.pow(Ellipsoid.GRS80.a, 2.0) - Math.pow(Ellipsoid.GRS80.b, 2.0)) / Math.pow(Ellipsoid.GRS80.b, 2.0);
        double d7 = Math.cos(d5);
        double d8 = d6 * Math.pow(d7, 2.0);
        double d9 = d4 = Math.pow(Ellipsoid.GRS80.a, 2.0) / (Ellipsoid.GRS80.b * Math.sqrt(1.0 + d8));
        double d10 = Math.tan(d5);
        double d11 = d10 * d10;
        double d12 = d11 * d11;
        double d13 = 1.0 / (d9 * d7);
        double d14 = d10 / (2.0 * (d9 *= d4));
        double d15 = 1.0 / (6.0 * (d9 *= d4) * d7);
        double d16 = d10 / (24.0 * (d9 *= d4));
        double d17 = 1.0 / (120.0 * (d9 *= d4) * d7);
        double d18 = d10 / (720.0 * (d9 *= d4));
        double d19 = 1.0 / (5040.0 * (d9 *= d4) * d7);
        double d20 = d10 / (40320.0 * (d9 *= d4));
        double d21 = -1.0 - d8;
        double d22 = -1.0 - 2.0 * d11 - d8;
        double d23 = 5.0 + 3.0 * d11 + 6.0 * d8 - 6.0 * d11 * d8 - 3.0 * (d8 * d8) - 9.0 * d11 * (d8 * d8);
        double d24 = 5.0 + 28.0 * d11 + 24.0 * d12 + 6.0 * d8 + 8.0 * d11 * d8;
        double d25 = -61.0 - 90.0 * d11 - 45.0 * d12 - 107.0 * d8 + 162.0 * d11 * d8;
        double d26 = -61.0 - 662.0 * d11 - 1320.0 * d12 - 720.0 * (d12 * d11);
        double d27 = 1385.0 + 3633.0 * d11 + 4095.0 * d12 + 1575.0 * (d12 * d11);
        return new LatLon(Math.toDegrees(d5 + d14 * d21 * (d * d) + d16 * d23 * Math.pow(d, 4.0) + d18 * d25 * Math.pow(d, 6.0) + d20 * d27 * Math.pow(d, 8.0)), Math.toDegrees(d3 + d13 * d + d15 * d22 * Math.pow(d, 3.0) + d17 * d24 * Math.pow(d, 5.0) + d19 * d26 * Math.pow(d, 7.0)));
    }

    public EastNorth latlon2eastNorth(LatLon latLon) {
        EastNorth eastNorth = this.MapLatLonToXY(Math.toRadians(latLon.lat()), Math.toRadians(latLon.lon()), this.UTMCentralMeridian(this.getzone()));
        return new EastNorth(eastNorth.east() * 0.9996 + 3500000.0, eastNorth.north() * 0.9996);
    }

    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        return this.MapXYToLatLon((eastNorth.east() - 3500000.0) / 0.9996, eastNorth.north() / 0.9996, this.UTMCentralMeridian(this.getzone()));
    }

    public String toString() {
        return I18n.tr("UTM Zone {0}", this.getzone());
    }

    public int getzone() {
        return 33;
    }

    public String toCode() {
        return "EPSG:325833";
    }

    public String getCacheDirectoryName() {
        return "epsg325833";
    }

    public ProjectionBounds getWorldBounds() {
        Bounds bounds = this.getWorldBoundsLatLon();
        return new ProjectionBounds(this.latlon2eastNorth(bounds.min), this.latlon2eastNorth(bounds.max));
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(-85.0, this.UTMCentralMeridianDeg(this.getzone()) - 5.0), new LatLon(85.0, this.UTMCentralMeridianDeg(this.getzone()) + 5.0));
    }
}

