/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.tools.I18n;

public class Lambert
implements Projection {
    public static final double[] n = new double[]{0.7604059656, 0.7289686274, 0.6959127966, 0.6712679322};
    public static final double[] c = new double[]{1.160379698E7, 1.174579339E7, 1.194799252E7, 1.213628199E7};
    public static final double[] Xs = new double[]{600000.0, 600000.0, 600000.0, 234.358};
    public static final double[] Ys = new double[]{5657616.674, 6199695.768, 6791905.085, 7239161.542};
    public static final double lg0 = 0.04079234433198;
    public static final double epsilon = 1.0E-11;
    public static final double cMaxLatZone1 = Math.toRadians(51.300000000000004);
    public static final double[] zoneLimits = new double[]{Math.toRadians(48.15), Math.toRadians(45.45), Math.toRadians(42.767667), Math.toRadians(41.560389)};
    public static final double cMinLonZones = Math.toRadians(-4.416666666666665);
    public static final double cMaxLonZones = Math.toRadians(9.18);
    public static final double cMaxOverlappingZones = Math.toRadians(1.35);
    public static int layoutZone = -1;
    private static int currentZone = 0;
    private static boolean dontDisplayErrors = false;

    public EastNorth latlon2eastNorth(LatLon latLon) {
        LatLon latLon2 = this.GRS802Clark(latLon);
        double d = latLon2.lat();
        double d2 = latLon2.lon();
        currentZone = 0;
        boolean bl = false;
        if (d >= zoneLimits[3] && d <= cMaxLatZone1 && d2 >= cMinLonZones && d2 <= cMaxLonZones) {
            if (d > zoneLimits[0]) {
                currentZone = 0;
            } else if (d > zoneLimits[1]) {
                currentZone = 1;
            } else if (d > zoneLimits[2]) {
                currentZone = 2;
            } else if (d > zoneLimits[3]) {
                currentZone = d2 < Math.toRadians(7.2) ? 2 : 3;
            }
        } else {
            bl = true;
        }
        if (!bl) {
            if (layoutZone == -1) {
                layoutZone = currentZone;
                dontDisplayErrors = false;
            } else if (layoutZone != currentZone) {
                if (currentZone < layoutZone && Math.abs(zoneLimits[currentZone] - d) > cMaxOverlappingZones || currentZone > layoutZone && Math.abs(zoneLimits[layoutZone] - d) > cMaxOverlappingZones) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("IMPORTANT : data positioned far away from\nthe current Lambert zone limits.\nDo not upload any data after this message.\nUndo your last action, save your work\nand start a new layer on the new zone."));
                    layoutZone = -1;
                    dontDisplayErrors = true;
                } else {
                    System.out.println("temporarily extend Lambert zone " + layoutZone + " projection at lat,lon:" + d + "," + d2);
                }
            }
        }
        if (layoutZone == -1) {
            return this.ConicProjection(d, d2, Xs[currentZone], Ys[currentZone], c[currentZone], n[currentZone]);
        }
        return this.ConicProjection(d, d2, Xs[layoutZone], Ys[layoutZone], c[layoutZone], n[layoutZone]);
    }

    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        LatLon latLon = layoutZone == -1 ? this.Geographic(eastNorth, Xs[currentZone], Ys[currentZone], c[currentZone], n[currentZone]) : this.Geographic(eastNorth, Xs[layoutZone], Ys[layoutZone], c[layoutZone], n[layoutZone]);
        LatLon latLon2 = this.Clark2GRS80(latLon);
        return new LatLon(Math.toDegrees(latLon2.lat()), Math.toDegrees(latLon2.lon()));
    }

    public String toString() {
        return I18n.tr("Lambert Zone (France)");
    }

    public String toCode() {
        return "EPSG::" + (27571 + currentZone);
    }

    public String getCacheDirectoryName() {
        return "lambert";
    }

    private EastNorth ConicProjection(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Ellipsoid.clarke.e * Math.sin(d);
        double d8 = Math.log(Math.tan(0.7853981633974483 + d / 2.0) * Math.pow((1.0 - d7) / (1.0 + d7), Ellipsoid.clarke.e / 2.0));
        double d9 = d3 + d5 * Math.exp(-d6 * d8) * Math.sin(d6 * (d2 - 0.04079234433198));
        double d10 = d4 - d5 * Math.exp(-d6 * d8) * Math.cos(d6 * (d2 - 0.04079234433198));
        return new EastNorth(d9, d10);
    }

    private LatLon Geographic(EastNorth eastNorth, double d, double d2, double d3, double d4) {
        double d5 = eastNorth.east() - d;
        double d6 = d2 - eastNorth.north();
        double d7 = Math.sqrt(d5 * d5 + d6 * d6);
        double d8 = Math.atan(d5 / d6);
        double d9 = -1.0 / d4 * Math.log(Math.abs(d7 / d3));
        d9 = Math.exp(d9);
        double d10 = 0.04079234433198 + d8 / d4;
        double d11 = 2.0 * Math.atan(d9) - 1.5707963267948966;
        double d12 = 1.0;
        while (d12 > 1.0E-11) {
            double d13 = Ellipsoid.clarke.e * Math.sin(d11);
            double d14 = 2.0 * Math.atan(Math.pow((1.0 + d13) / (1.0 - d13), Ellipsoid.clarke.e / 2.0) * d9) - 1.5707963267948966;
            d12 = Math.abs(d14 - d11);
            d11 = d14;
        }
        return new LatLon(d11, d10);
    }

    private LatLon GRS802Clark(LatLon latLon) {
        double d = Math.toRadians(latLon.lat());
        double d2 = Math.toRadians(latLon.lon());
        double d3 = Ellipsoid.GRS80.a / Math.sqrt(1.0 - Ellipsoid.GRS80.e2 * Math.sin(d) * Math.sin(d));
        double d4 = d3 * Math.cos(d) * Math.cos(d2);
        double d5 = d3 * Math.cos(d) * Math.sin(d2);
        double d6 = d3 * (1.0 - Ellipsoid.GRS80.e2) * Math.sin(d);
        return this.Geographic(d4 += 168.0, d5 += 60.0, d6 += -320.0, Ellipsoid.clarke);
    }

    private LatLon Clark2GRS80(LatLon latLon) {
        double d = latLon.lat();
        double d2 = latLon.lon();
        double d3 = Ellipsoid.clarke.a / Math.sqrt(1.0 - Ellipsoid.clarke.e2 * Math.sin(d) * Math.sin(d));
        double d4 = d3 * Math.cos(d) * Math.cos(d2);
        double d5 = d3 * Math.cos(d) * Math.sin(d2);
        double d6 = d3 * (1.0 - Ellipsoid.clarke.e2) * Math.sin(d);
        return this.Geographic(d4 += -168.0, d5 += -60.0, d6 += 320.0, Ellipsoid.GRS80);
    }

    private LatLon Geographic(double d, double d2, double d3, Ellipsoid ellipsoid) {
        double d4;
        double d5 = Math.sqrt(d * d + d2 * d2);
        double d6 = 2.0 * Math.atan(d2 / (d + d5));
        double d7 = Math.atan(d3 / (d5 * (1.0 - ellipsoid.a * ellipsoid.e2 / Math.sqrt(d * d + d2 * d2 + d3 * d3))));
        double d8 = 1.0;
        while (d8 > 1.0E-11) {
            d4 = Math.sin(d7);
            d4 *= d4;
            double d9 = Math.atan(d3 / d5 / (1.0 - ellipsoid.a * ellipsoid.e2 * Math.cos(d7) / (d5 * Math.sqrt(1.0 - ellipsoid.e2 * d4))));
            d8 = Math.abs(d9 - d7);
            d7 = d9;
        }
        d4 = Math.sin(d7);
        d4 *= d4;
        return new LatLon(d7, d6);
    }

    public ProjectionBounds getWorldBounds() {
        Bounds bounds = this.getWorldBoundsLatLon();
        return new ProjectionBounds(this.latlon2eastNorth(bounds.min), this.latlon2eastNorth(bounds.max));
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(-90.0, -180.0), new LatLon(90.0, 180.0));
    }
}

