/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeVisitor
extends AbstractVisitor {
    private static Logger logger = Logger.getLogger(MergeVisitor.class.getName());
    private ConflictCollection conflicts;
    private final DataSet myDataSet;
    private final DataSet theirDataSet;
    private final HashMap<Long, Node> nodeshash = new HashMap();
    private final HashMap<Long, Way> wayshash = new HashMap();
    private final HashMap<Long, Relation> relshash = new HashMap();
    private Map<OsmPrimitive, OsmPrimitive> merged;

    public MergeVisitor(DataSet dataSet, DataSet dataSet2) {
        this.myDataSet = dataSet;
        this.theirDataSet = dataSet2;
        for (Node osmPrimitive : dataSet.nodes) {
            if (osmPrimitive.id == 0L) continue;
            this.nodeshash.put(osmPrimitive.id, osmPrimitive);
        }
        for (Way way : dataSet.ways) {
            if (way.id == 0L) continue;
            this.wayshash.put(way.id, way);
        }
        for (Relation relation : dataSet.relations) {
            if (relation.id == 0L) continue;
            this.relshash.put(relation.id, relation);
        }
        this.conflicts = new ConflictCollection();
        this.merged = new HashMap<OsmPrimitive, OsmPrimitive>();
    }

    protected <P extends OsmPrimitive> void mergePrimitive(P p, Collection<P> collection, Collection<P> collection2, HashMap<Long, P> hashMap) {
        if (p.id > 0L) {
            if (this.mergeById(collection, hashMap, p)) {
                return;
            }
        } else {
            for (OsmPrimitive osmPrimitive : collection) {
                if (osmPrimitive.id > 0L || !osmPrimitive.hasEqualSemanticAttributes(p)) continue;
                if (osmPrimitive.deleted != p.deleted) {
                    this.conflicts.add(osmPrimitive, p);
                } else {
                    osmPrimitive.visible = p.visible;
                    osmPrimitive.user = p.user;
                    osmPrimitive.setTimestamp(p.getTimestamp());
                    osmPrimitive.modified = p.modified;
                    this.merged.put(p, osmPrimitive);
                }
                return;
            }
        }
        collection.add(p);
    }

    @Override
    public void visit(Node node) {
        this.mergePrimitive(node, this.myDataSet.nodes, this.theirDataSet.nodes, this.nodeshash);
    }

    @Override
    public void visit(Way way) {
        this.fixWay(way);
        this.mergePrimitive(way, this.myDataSet.ways, this.theirDataSet.ways, this.wayshash);
    }

    @Override
    public void visit(Relation relation) {
        this.fixRelation(relation);
        this.mergePrimitive(relation, this.myDataSet.relations, this.theirDataSet.relations, this.relshash);
    }

    public void fixReferences() {
        for (Way osmPrimitive : this.myDataSet.ways) {
            this.fixWay(osmPrimitive);
        }
        for (Relation relation : this.myDataSet.relations) {
            this.fixRelation(relation);
        }
        for (OsmPrimitive osmPrimitive : this.conflicts.getMyConflictParties()) {
            if (osmPrimitive instanceof Way) {
                this.fixWay((Way)osmPrimitive);
                continue;
            }
            if (!(osmPrimitive instanceof Relation)) continue;
            this.fixRelation((Relation)osmPrimitive);
        }
    }

    private void fixWay(Way way) {
        boolean bl = false;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Node node : way.nodes) {
            Node node2 = (Node)this.merged.get(node);
            if (node2 != null) {
                if (!node2.deleted) {
                    linkedList.add(node2);
                }
                bl = true;
                continue;
            }
            linkedList.add(node);
        }
        if (bl) {
            way.nodes.clear();
            way.nodes.addAll(linkedList);
        }
    }

    private void fixRelation(Relation relation) {
        boolean bl = false;
        LinkedList<RelationMember> linkedList = new LinkedList<RelationMember>();
        for (RelationMember relationMember : relation.members) {
            OsmPrimitive osmPrimitive = this.merged.get(relationMember.member);
            if (osmPrimitive == null) {
                linkedList.add(relationMember);
                continue;
            }
            if (!osmPrimitive.deleted) {
                RelationMember relationMember2 = new RelationMember(relationMember);
                relationMember2.member = osmPrimitive;
                linkedList.add(relationMember2);
            }
            bl = true;
        }
        if (bl) {
            relation.members.clear();
            relation.members.addAll(linkedList);
        }
    }

    private <P extends OsmPrimitive> boolean mergeById(Collection<P> collection, HashMap<Long, P> hashMap, P p) {
        if (hashMap.containsKey(p.id)) {
            OsmPrimitive osmPrimitive = (OsmPrimitive)hashMap.get(p.id);
            if (osmPrimitive.version <= p.version) {
                if (!osmPrimitive.visible && p.visible) {
                    logger.warning(I18n.tr("My primitive with id {0} and version {1} is visible although their primitive with lower version {2} is not visible. Can't deal with this inconsistency. Keeping my primitive. ", Long.toString(osmPrimitive.id), Long.toString(osmPrimitive.version), Long.toString(p.version)));
                    this.merged.put(p, osmPrimitive);
                } else if (osmPrimitive.visible && !p.visible) {
                    this.conflicts.add(osmPrimitive, p);
                } else if (osmPrimitive.incomplete) {
                    osmPrimitive.incomplete = false;
                    osmPrimitive.cloneFrom(p);
                    this.merged.put(p, osmPrimitive);
                } else if (osmPrimitive.deleted && !p.deleted && osmPrimitive.version == p.version) {
                    this.merged.put(p, osmPrimitive);
                } else if (osmPrimitive.deleted != p.deleted) {
                    this.conflicts.add(osmPrimitive, p);
                } else if (!osmPrimitive.modified && p.modified) {
                    if (p.deleted) {
                        this.myDataSet.unlinkReferencesToPrimitive(osmPrimitive);
                    }
                    osmPrimitive.cloneFrom(p);
                    this.merged.put(p, osmPrimitive);
                } else if (!osmPrimitive.modified && !p.modified && osmPrimitive.version == p.version) {
                    this.merged.put(p, osmPrimitive);
                } else if (!osmPrimitive.modified && !p.modified && osmPrimitive.version < p.version) {
                    osmPrimitive.cloneFrom(p);
                    this.merged.put(p, osmPrimitive);
                } else if (osmPrimitive.modified && !p.modified && osmPrimitive.version == p.version) {
                    this.merged.put(p, osmPrimitive);
                } else if (!osmPrimitive.hasEqualSemanticAttributes(p)) {
                    this.conflicts.add(osmPrimitive, p);
                } else {
                    osmPrimitive.cloneFrom(p);
                    osmPrimitive.modified = true;
                    this.merged.put(p, osmPrimitive);
                }
            } else {
                this.merged.put(p, osmPrimitive);
            }
            return true;
        }
        return false;
    }

    public void merge() {
        for (OsmPrimitive osmPrimitive : this.theirDataSet.allPrimitives()) {
            osmPrimitive.visit(this);
        }
        this.fixReferences();
    }

    public DataSet getMyDataSet() {
        return this.myDataSet;
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }
}

