/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

public class HistoryDataSet {
    private static HistoryDataSet historyDataSet;
    private HashMap<Long, ArrayList<HistoryOsmPrimitive>> data = new HashMap();

    public static HistoryDataSet getInstance() {
        if (historyDataSet == null) {
            historyDataSet = new HistoryDataSet();
        }
        return historyDataSet;
    }

    public HistoryOsmPrimitive get(long l, long l2) {
        ArrayList<HistoryOsmPrimitive> arrayList = this.data.get(l);
        if (arrayList == null) {
            throw new NoSuchElementException(I18n.tr("Didn't find an  primitive with id {0} in this dataset", l));
        }
        for (HistoryOsmPrimitive historyOsmPrimitive : arrayList) {
            if (!historyOsmPrimitive.matches(l, l2)) continue;
            return historyOsmPrimitive;
        }
        throw new NoSuchElementException(I18n.tr("Didn't find an primitive with id {0} and version {1} in this dataset", l, l2));
    }

    public void put(HistoryOsmPrimitive historyOsmPrimitive) {
        if (this.data.get(historyOsmPrimitive.getId()) == null) {
            this.data.put(historyOsmPrimitive.getId(), new ArrayList());
        }
        this.data.get(historyOsmPrimitive.getId()).add(historyOsmPrimitive);
    }

    public History getHistory(long l) {
        ArrayList<HistoryOsmPrimitive> arrayList = this.data.get(l);
        if (arrayList == null) {
            return null;
        }
        return new History(l, arrayList);
    }

    public void mergeInto(HistoryDataSet historyDataSet) {
        if (historyDataSet == null) {
            return;
        }
        for (Long l : historyDataSet.data.keySet()) {
            if (this.data.keySet().contains(l)) continue;
            this.data.put(l, historyDataSet.data.get(l));
        }
    }
}

