/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Area;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSet
implements Cloneable {
    public String version;
    public Collection<Node> nodes = new LinkedList<Node>();
    public Collection<Way> ways = new LinkedList<Way>();
    public Collection<Relation> relations = new LinkedList<Relation>();
    public Collection<DataSource> dataSources = new LinkedList<DataSource>();
    public static Collection<SelectionChangedListener> selListeners = new LinkedList<SelectionChangedListener>();

    public List<OsmPrimitive> allPrimitives() {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        linkedList.addAll(this.nodes);
        linkedList.addAll(this.ways);
        linkedList.addAll(this.relations);
        return linkedList;
    }

    public Collection<OsmPrimitive> allNonDeletedPrimitives() {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : this.allPrimitives()) {
            if (!osmPrimitive.visible || osmPrimitive.deleted) continue;
            linkedList.add(osmPrimitive);
        }
        return linkedList;
    }

    public Collection<OsmPrimitive> allNonDeletedCompletePrimitives() {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : this.allPrimitives()) {
            if (!osmPrimitive.visible || osmPrimitive.deleted || osmPrimitive.incomplete) continue;
            linkedList.add(osmPrimitive);
        }
        return linkedList;
    }

    public Collection<OsmPrimitive> allNonDeletedPhysicalPrimitives() {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : this.allPrimitives()) {
            if (!osmPrimitive.visible || osmPrimitive.deleted || osmPrimitive.incomplete || osmPrimitive instanceof Relation) continue;
            linkedList.add(osmPrimitive);
        }
        return linkedList;
    }

    public void addPrimitive(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Node) {
            this.nodes.add((Node)osmPrimitive);
        } else if (osmPrimitive instanceof Way) {
            this.ways.add((Way)osmPrimitive);
        } else if (osmPrimitive instanceof Relation) {
            this.relations.add((Relation)osmPrimitive);
        }
    }

    public Collection<OsmPrimitive> getSelectedNodesAndWays() {
        Collection<OsmPrimitive> collection = this.getSelected(this.nodes);
        collection.addAll(this.getSelected(this.ways));
        return collection;
    }

    public Collection<OsmPrimitive> getSelected() {
        Collection<OsmPrimitive> collection = this.getSelected(this.nodes);
        collection.addAll(this.getSelected(this.ways));
        collection.addAll(this.getSelected(this.relations));
        return collection;
    }

    public Collection<OsmPrimitive> getSelectedNodes() {
        return this.getSelected(this.nodes);
    }

    public Collection<OsmPrimitive> getSelectedWays() {
        return this.getSelected(this.ways);
    }

    public Collection<OsmPrimitive> getSelectedRelations() {
        return this.getSelected(this.relations);
    }

    public void setSelected(Collection<? extends OsmPrimitive> collection) {
        this.clearSelection(this.nodes);
        this.clearSelection(this.ways);
        this.clearSelection(this.relations);
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.selected = true;
        }
        DataSet.fireSelectionChanged(collection);
    }

    public void setSelected(OsmPrimitive ... osmPrimitiveArray) {
        if (osmPrimitiveArray.length == 1 && osmPrimitiveArray[0] == null) {
            this.setSelected(new OsmPrimitive[0]);
            return;
        }
        this.clearSelection(this.nodes);
        this.clearSelection(this.ways);
        this.clearSelection(this.relations);
        for (OsmPrimitive osmPrimitive : osmPrimitiveArray) {
            if (osmPrimitive == null) continue;
            osmPrimitive.selected = true;
        }
        DataSet.fireSelectionChanged(Arrays.asList(osmPrimitiveArray));
    }

    private void clearSelection(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.selected = false;
        }
    }

    private Collection<OsmPrimitive> getSelected(Collection<? extends OsmPrimitive> collection) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        if (collection == null) {
            return hashSet;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (!osmPrimitive.selected || osmPrimitive.deleted) continue;
            hashSet.add(osmPrimitive);
        }
        return hashSet;
    }

    public static void fireSelectionChanged(Collection<? extends OsmPrimitive> collection) {
        for (SelectionChangedListener selectionChangedListener : selListeners) {
            selectionChangedListener.selectionChanged(collection);
        }
    }

    public DataSet clone() {
        DataSet dataSet = new DataSet();
        for (Node object : this.nodes) {
            dataSet.nodes.add(new Node(object));
        }
        for (Way way : this.ways) {
            dataSet.ways.add(new Way(way));
        }
        for (Relation relation : this.relations) {
            dataSet.relations.add(new Relation(relation));
        }
        for (DataSource dataSource : this.dataSources) {
            dataSet.dataSources.add(new DataSource(dataSource.bounds, dataSource.origin));
        }
        dataSet.version = this.version;
        return dataSet;
    }

    public Area getDataSourceArea() {
        if (this.dataSources.isEmpty()) {
            return null;
        }
        Area area = new Area();
        for (DataSource dataSource : this.dataSources) {
            area.add(new Area(dataSource.bounds.asRect()));
        }
        return area;
    }

    public static OsmPrimitive[] sort(Collection<? extends OsmPrimitive> collection) {
        OsmPrimitive[] osmPrimitiveArray = new OsmPrimitive[collection.size()];
        final HashMap hashMap = new HashMap();
        osmPrimitiveArray = collection.toArray(osmPrimitiveArray);
        Arrays.sort(osmPrimitiveArray, new Comparator<OsmPrimitive>(){

            @Override
            public int compare(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
                if (osmPrimitive.getClass() == osmPrimitive2.getClass()) {
                    int n;
                    String string;
                    String string2 = (String)hashMap.get(osmPrimitive);
                    if (string2 == null) {
                        string2 = osmPrimitive.getName();
                        hashMap.put(osmPrimitive, string2);
                    }
                    if ((string = (String)hashMap.get(osmPrimitive2)) == null) {
                        string = osmPrimitive2.getName();
                        hashMap.put(osmPrimitive2, string);
                    }
                    if ((n = string2.compareTo(string)) != 0) {
                        return n;
                    }
                }
                return osmPrimitive.compareTo(osmPrimitive2);
            }
        });
        return osmPrimitiveArray;
    }

    public OsmPrimitive getPrimitiveById(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException(I18n.tr("parameter {0} > 0 required. Got {1}.", "id", l));
        }
        for (Node osmPrimitive : this.nodes) {
            if (osmPrimitive.id != l) continue;
            return osmPrimitive;
        }
        for (Way way : this.ways) {
            if (way.id != l) continue;
            return way;
        }
        for (Relation relation : this.relations) {
            if (relation.id != l) continue;
            return relation;
        }
        return null;
    }

    public Set<Long> getPrimitiveIds() {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (Node osmPrimitive : this.nodes) {
            hashSet.add(osmPrimitive.id);
        }
        for (Way way : this.ways) {
            hashSet.add(way.id);
        }
        for (Relation relation : this.relations) {
            hashSet.add(relation.id);
        }
        return hashSet;
    }

    public Set<Long> getCompletePrimitiveIds() {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (Node osmPrimitive : this.nodes) {
            if (osmPrimitive.incomplete) continue;
            hashSet.add(osmPrimitive.id);
        }
        for (Way way : this.ways) {
            if (way.incomplete) continue;
            hashSet.add(way.id);
        }
        for (Relation relation : this.relations) {
            if (relation.incomplete) continue;
            hashSet.add(relation.id);
        }
        return hashSet;
    }

    protected void deleteWay(Way way) {
        way.nodes.clear();
        way.delete(true);
    }

    public void unlinkNodeFromWays(Node node) {
        for (Way way : this.ways) {
            if (!way.nodes.contains(node)) continue;
            way.nodes.remove(node);
            if (way.nodes.size() >= 2) continue;
            this.deleteWay(way);
        }
    }

    public void unlinkPrimitiveFromRelations(OsmPrimitive osmPrimitive) {
        for (Relation relation : this.relations) {
            Iterator<RelationMember> iterator = relation.members.iterator();
            while (iterator.hasNext()) {
                RelationMember relationMember = iterator.next();
                if (!relationMember.member.equals(osmPrimitive)) continue;
                iterator.remove();
            }
        }
    }

    public void unlinkReferencesToPrimitive(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Node) {
            this.unlinkNodeFromWays((Node)osmPrimitive);
            this.unlinkPrimitiveFromRelations(osmPrimitive);
        } else {
            this.unlinkPrimitiveFromRelations(osmPrimitive);
        }
    }
}

