/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.logging.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

public abstract class ConflictResolveCommand
extends Command {
    private static final Logger logger = Logger.getLogger(ConflictResolveCommand.class.getName());
    private ConflictCollection resolvedConflicts = new ConflictCollection();

    protected void rememberConflict(Conflict conflict) {
        if (!this.resolvedConflicts.hasConflictForMy((OsmPrimitive)conflict.getMy())) {
            this.resolvedConflicts.add(conflict);
        }
    }

    protected void reconstituteConflicts() {
        OsmDataLayer osmDataLayer = this.getLayer();
        for (Conflict<?> conflict : this.resolvedConflicts) {
            if (osmDataLayer.getConflicts().hasConflictForMy((OsmPrimitive)conflict.getMy())) continue;
            osmDataLayer.getConflicts().add(conflict);
        }
    }

    public void undoCommand() {
        super.undoCommand();
        if (!Main.map.mapView.hasLayer(this.getLayer())) {
            logger.warning(I18n.tr("Can't undo command ''{0}'' because layer ''{1}'' is not present anymore", this.toString(), this.getLayer().toString()));
            return;
        }
        Main.map.mapView.setActiveLayer(this.getLayer());
        this.reconstituteConflicts();
    }
}

