/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.EventQueue;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadOsmTaskList
implements Runnable {
    private List<DownloadDialog.DownloadTask> osmTasks = new LinkedList<DownloadDialog.DownloadTask>();

    public void download(boolean bl, List<Rectangle2D> list) {
        if (bl) {
            OsmDataLayer osmDataLayer = new OsmDataLayer(new DataSet(), OsmDataLayer.createNewName(), null);
            Main.main.addLayer(osmDataLayer);
            Main.map.mapView.setActiveLayer(osmDataLayer);
        }
        int n = 0;
        for (Rectangle2D rectangle2D : list) {
            DownloadOsmTask downloadOsmTask = new DownloadOsmTask();
            downloadOsmTask.download(null, rectangle2D.getMinY(), rectangle2D.getMinX(), rectangle2D.getMaxY(), rectangle2D.getMaxX(), true, I18n.tr("Download {0} of {1} ({2} left)", ++n, list.size(), list.size() - n));
            this.osmTasks.add(downloadOsmTask);
        }
        Main.worker.execute(this);
    }

    public void download(boolean bl, Collection<Area> collection) {
        LinkedList<Rectangle2D> linkedList = new LinkedList<Rectangle2D>();
        for (Area area : collection) {
            linkedList.add(area.getBounds2D());
        }
        this.download(bl, (List<Rectangle2D>)linkedList);
    }

    @Override
    public void run() {
        String string = "";
        for (DownloadDialog.DownloadTask object2 : this.osmTasks) {
            String string2 = object2.getErrorMessage();
            if (string2.equals("")) continue;
            string = string + "* " + string2 + "\r\n";
        }
        if (!string.equals("")) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The following errors occurred during mass download:") + "\r\n" + string, I18n.tr("Errors during Download"), 0);
            return;
        }
        Set<Long> set = Main.map.mapView.getEditLayer().data.getCompletePrimitiveIds();
        Set<Long> set2 = this.getDownloadedIds();
        set.removeAll(set2);
        set.remove(new Long(0L));
        if (!set.isEmpty()) {
            this.handlePotentiallyDeletedPrimitives(set);
        }
    }

    protected void updatePotentiallyDeletedPrimitives(Set<Long> set) {
        DataSet dataSet = Main.map.mapView.getEditLayer().data;
        final ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        for (Long l : set) {
            OsmPrimitive osmPrimitive = dataSet.getPrimitiveById(l);
            if (osmPrimitive == null) continue;
            arrayList.add(osmPrimitive);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new UpdateSelectionAction().updatePrimitives(arrayList);
            }
        });
    }

    protected void handlePotentiallyDeletedPrimitives(Set<Long> set) {
        Object[] objectArray = new String[]{"Check on the server", "Ignore"};
        String string = I18n.tr("<html>There are {0} primitives in your local dataset which<br>might be deleted on the server. If you later try to delete or<br>update them the server is likely to report a<br>conflict.<br><br>Click <strong>{1}</strong> to check the state of these primitives<br>on the server.<br>Click <strong>{2}</strong> to ignore.<br></html>", set.size(), objectArray[0], objectArray[1]);
        int n = JOptionPane.showOptionDialog(Main.parent, string, I18n.tr("Deleted or moved primitives"), 0, 2, null, objectArray, objectArray[0]);
        switch (n) {
            case -1: {
                return;
            }
            case 1: {
                return;
            }
            case 0: {
                this.updatePotentiallyDeletedPrimitives(set);
            }
        }
    }

    protected boolean wasDownloaded(long l, DataSet dataSet) {
        OsmPrimitive osmPrimitive = dataSet.getPrimitiveById(l);
        return osmPrimitive != null;
    }

    public boolean wasDownloaded(long l) {
        for (DownloadDialog.DownloadTask downloadTask : this.osmTasks) {
            DataSet dataSet;
            if (!(downloadTask instanceof DownloadOsmTask) || !this.wasDownloaded(l, dataSet = ((DownloadOsmTask)downloadTask).getDownloadedData())) continue;
            return true;
        }
        return false;
    }

    public Set<Long> getDownloadedIds() {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (DownloadDialog.DownloadTask downloadTask : this.osmTasks) {
            if (!(downloadTask instanceof DownloadOsmTask)) continue;
            DataSet dataSet = ((DownloadOsmTask)downloadTask).getDownloadedData();
            hashSet.addAll(dataSet.getPrimitiveIds());
        }
        return hashSet;
    }
}

