/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ApiPreconditionChecker;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.UpdateDataAction;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.historycombobox.JHistoryComboBox;
import org.openstreetmap.josm.gui.historycombobox.SuggestingJHistoryComboBox;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmServerWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class UploadAction
extends JosmAction {
    private static Logger logger = Logger.getLogger(UploadAction.class.getName());
    public static final String HISTORY_KEY = "upload.comment.history";
    public final LinkedList<UploadHook> uploadHooks = new LinkedList();

    public UploadAction() {
        super(I18n.tr("Upload to OSM..."), "upload", I18n.tr("Upload all changes to the OSM server."), Shortcut.registerShortcut("file:upload", I18n.tr("File: {0}", I18n.tr("Upload to OSM...")), 85, 8), true);
        this.uploadHooks.add(new ApiPreconditionChecker());
        this.uploadHooks.add(new UploadHook(){

            @Override
            public boolean checkUpload(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
                JComponent jComponent;
                JPanel jPanel = new JPanel(new GridBagLayout());
                OsmPrimitivRenderer osmPrimitivRenderer = new OsmPrimitivRenderer();
                if (!collection.isEmpty()) {
                    jPanel.add((Component)new JLabel(I18n.tr("Objects to add:")), GBC.eol());
                    jComponent = new JList<Object>(collection.toArray());
                    ((JList)jComponent).setCellRenderer(osmPrimitivRenderer);
                    ((JList)jComponent).setVisibleRowCount(((JList)jComponent).getModel().getSize() < 6 ? ((JList)jComponent).getModel().getSize() : 10);
                    jPanel.add((Component)new JScrollPane(jComponent), GBC.eol().fill());
                }
                if (!collection2.isEmpty()) {
                    jPanel.add((Component)new JLabel(I18n.tr("Objects to modify:")), GBC.eol());
                    jComponent = new JList<Object>(collection2.toArray());
                    ((JList)jComponent).setCellRenderer(osmPrimitivRenderer);
                    ((JList)jComponent).setVisibleRowCount(((JList)jComponent).getModel().getSize() < 6 ? ((JList)jComponent).getModel().getSize() : 10);
                    jPanel.add((Component)new JScrollPane(jComponent), GBC.eol().fill());
                }
                if (!collection3.isEmpty()) {
                    jPanel.add((Component)new JLabel(I18n.tr("Objects to delete:")), GBC.eol());
                    jComponent = new JList<Object>(collection3.toArray());
                    ((JList)jComponent).setCellRenderer(osmPrimitivRenderer);
                    ((JList)jComponent).setVisibleRowCount(((JList)jComponent).getModel().getSize() < 6 ? ((JList)jComponent).getModel().getSize() : 10);
                    jPanel.add((Component)new JScrollPane(jComponent), GBC.eol().fill());
                }
                jPanel.add((Component)new JLabel(I18n.tr("Provide a brief comment for the changes you are uploading:")), GBC.eol().insets(0, 5, 10, 3));
                jComponent = new SuggestingJHistoryComboBox();
                LinkedList<String> linkedList = new LinkedList<String>(Main.pref.getCollection(UploadAction.HISTORY_KEY, new LinkedList<String>()));
                ((JHistoryComboBox)jComponent).setHistory(linkedList);
                jPanel.add((Component)jComponent, GBC.eol().fill(2));
                do {
                    int n;
                    if ((n = new ExtendedDialog(Main.parent, I18n.tr("Upload these changes?"), jPanel, new String[]{I18n.tr("Upload Changes"), I18n.tr("Cancel")}, new String[]{"upload.png", "cancel.png"}).getValue()) == 1) continue;
                    return false;
                } while (((JHistoryComboBox)jComponent).getText().trim().length() < 3);
                ((JHistoryComboBox)jComponent).addCurrentItemToHistory();
                Main.pref.putCollection(UploadAction.HISTORY_KEY, ((JHistoryComboBox)jComponent).getHistory());
                return true;
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (Main.map == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Nothing to upload. Get some data first."));
            return;
        }
        ConflictCollection conflictCollection = Main.main.createOrGetEditLayer().getConflicts();
        if (conflictCollection != null && !conflictCollection.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There are unresolved conflicts. You have to resolve these first."));
            Main.map.conflictDialog.action.button.setSelected(true);
            Main.map.conflictDialog.action.actionPerformed(null);
            return;
        }
        final LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        LinkedList<OsmPrimitive> linkedList2 = new LinkedList<OsmPrimitive>();
        LinkedList<OsmPrimitive> linkedList3 = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive object2 : Main.ds.allPrimitives()) {
            if (object2.get("josm/ignore") != null) continue;
            if (object2.id == 0L && !object2.deleted) {
                linkedList.addLast(object2);
                continue;
            }
            if (object2.modified && !object2.deleted) {
                linkedList2.addLast(object2);
                continue;
            }
            if (!object2.deleted || object2.id == 0L) continue;
            linkedList3.addFirst(object2);
        }
        if (linkedList.isEmpty() && linkedList2.isEmpty() && linkedList3.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No changes to upload."));
            return;
        }
        for (UploadHook uploadHook : this.uploadHooks) {
            if (uploadHook.checkUpload(linkedList, linkedList2, linkedList3)) continue;
            return;
        }
        final OsmServerWriter osmServerWriter = new OsmServerWriter();
        final LinkedList<OsmPrimitive> linkedList4 = new LinkedList<OsmPrimitive>();
        linkedList4.addAll(linkedList);
        linkedList4.addAll(linkedList2);
        linkedList4.addAll(linkedList3);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UploadDiffTask
        extends PleaseWaitRunnable {
            private boolean uploadCancelled;
            private boolean uploadFailed;
            private Exception lastException;

            public UploadDiffTask() {
                super(I18n.tr("Uploading"), false);
                this.uploadCancelled = false;
                this.uploadFailed = false;
                this.lastException = null;
            }

            @Override
            protected void realRun() throws SAXException, IOException {
                try {
                    osmServerWriter.uploadOsm(Main.ds.version, linkedList4);
                    Main.main.createOrGetEditLayer().cleanData(osmServerWriter.processed, !linkedList.isEmpty());
                }
                catch (Exception exception) {
                    if (this.uploadCancelled) {
                        System.out.println("Ignoring exception caught because upload is cancelled. Exception is: " + exception.toString());
                        return;
                    }
                    this.uploadFailed = true;
                    this.lastException = exception;
                }
            }

            @Override
            protected void finish() {
                if (this.uploadFailed) {
                    UploadAction.this.handleFailedUpload(this.lastException);
                }
            }

            @Override
            protected void cancel() {
                osmServerWriter.disconnectActiveConnection();
                this.uploadCancelled = true;
            }
        }
        Main.worker.execute(new UploadDiffTask());
    }

    protected void synchronizePrimitive(final String string) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UpdatePrimitiveTask
        extends PleaseWaitRunnable {
            private boolean uploadCancelled;
            private boolean uploadFailed;
            private Exception lastException;

            public UpdatePrimitiveTask() {
                super(I18n.tr("Updating primitive"), false);
                this.uploadCancelled = false;
                this.uploadFailed = false;
                this.lastException = null;
            }

            @Override
            protected void realRun() throws SAXException, IOException {
                try {
                    UpdateSelectionAction updateSelectionAction = new UpdateSelectionAction();
                    updateSelectionAction.updatePrimitive(Long.parseLong(string));
                }
                catch (Exception exception) {
                    if (this.uploadCancelled) {
                        System.out.println("Ignoring exception caught because upload is cancelled. Exception is: " + exception.toString());
                        return;
                    }
                    this.uploadFailed = true;
                    this.lastException = exception;
                }
            }

            @Override
            protected void finish() {
                if (this.uploadFailed) {
                    UploadAction.this.handleFailedUpload(this.lastException);
                }
            }

            @Override
            protected void cancel() {
                OsmApi.getOsmApi().cancel();
                this.uploadCancelled = true;
            }
        }
        Main.worker.execute(new UpdatePrimitiveTask());
    }

    protected void synchronizeDataSet() {
        UpdateDataAction updateDataAction = new UpdateDataAction();
        updateDataAction.actionPerformed(new ActionEvent(this, 0, ""));
    }

    protected void handleUploadConflictForKnownConflict(String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[]{I18n.tr("Synchronize {0} {1} only", I18n.tr(string), string2), I18n.tr("Synchronize entire dataset"), I18n.tr("Cancel")};
        Object object = objectArray[0];
        String string5 = I18n.tr("<html>Uploading <strong>failed</strong> because the server has a newer version of one<br>of your nodes, ways, or relations.<br>The conflict is caused by the <strong>{0}</strong> with id <strong>{1}</strong>,<br>the server has version {2}, your version is {3}.<br><br>Click <strong>{4}</strong> to synchronize the conflicting primitive only.<br>Click <strong>{5}</strong> to synchronize the entire local dataset with the server.<br>Click <strong>{6}</strong> to abort and continue editing.<br></html>", I18n.tr(string), string2, string3, string4, objectArray[0], objectArray[1], objectArray[2]);
        int n = 1;
        int n2 = JOptionPane.showOptionDialog(null, string5, I18n.tr("Conflict detected"), n, 0, null, objectArray, object);
        switch (n2) {
            case -1: {
                return;
            }
            case 2: {
                return;
            }
            case 0: {
                this.synchronizePrimitive(string2);
                break;
            }
            case 1: {
                this.synchronizeDataSet();
                break;
            }
            default: {
                throw new IllegalStateException(I18n.tr("unexpected return value. Got {0}", n2));
            }
        }
    }

    protected void handleUploadConflictForUnknownConflict() {
        Object[] objectArray = new Object[]{I18n.tr("Synchronize entire dataset"), I18n.tr("Cancel")};
        Object object = objectArray[0];
        String string = I18n.tr("<html>Uploading <strong>failed</strong> because the server has a newer version of one<br>of your nodes, ways, or relations.<br><br>Click <strong>{0}</strong> to synchronize the entire local dataset with the server.<br>Click <strong>{1}</strong> to abort and continue editing.<br></html>", objectArray[0], objectArray[1]);
        int n = 0;
        int n2 = JOptionPane.showOptionDialog(null, string, I18n.tr("Conflict detected"), n, 0, null, objectArray, object);
        switch (n2) {
            case -1: {
                return;
            }
            case 1: {
                return;
            }
            case 0: {
                this.synchronizeDataSet();
                break;
            }
            default: {
                throw new IllegalStateException(I18n.tr("unexpected return value. Got {0}", n2));
            }
        }
    }

    protected void handleUploadConflict(OsmApiException osmApiException) {
        String string = "Version mismatch: Provided (\\d+), server had: (\\d+) of (\\S+) (\\d+)";
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(osmApiException.getErrorHeader());
        if (matcher.matches()) {
            this.handleUploadConflictForKnownConflict(matcher.group(3), matcher.group(4), matcher.group(2), matcher.group(1));
        } else {
            logger.warning(I18n.tr("Warning: error header \"{0}\" did not match expected pattern \"{1}\"", osmApiException.getErrorHeader(), string));
            this.handleUploadConflictForUnknownConflict();
        }
    }

    protected void handlePreconditionFailed(OsmApiException osmApiException) {
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Uploading to the server <strong>failed</strong> because your current<br>dataset violates a precondition.<br>The error message is:<br>{0}</html>", osmApiException.getMessage().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;")), I18n.tr("Precondition violation"), 0);
        osmApiException.printStackTrace();
    }

    protected void handleGoneForKnownPrimitive(String string, String string2) {
        UpdateSelectionAction updateSelectionAction = new UpdateSelectionAction();
        updateSelectionAction.handlePrimitiveGoneException(Long.parseLong(string2));
    }

    protected void handleGoneForUnknownPrimitive(OsmApiException osmApiException) {
        String string = I18n.tr("<html>Uploading <strong>failed</strong> because a primitive you tried to<br>delete on the server is already deleted.<br><br>The error message is:<br>{0}</html>", osmApiException.getMessage().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;"));
        JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Primitive already deleted"), 0);
    }

    protected void handleGone(OsmApiException osmApiException) {
        String string = "The (\\S+) with the id (\\d+) has already been deleted";
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(osmApiException.getErrorHeader());
        if (matcher.matches()) {
            this.handleGoneForKnownPrimitive(matcher.group(1), matcher.group(2));
        } else {
            logger.warning(I18n.tr("Error header \"{0}\" does not match expected pattern \"{1}\"", osmApiException.getErrorHeader(), string));
            this.handleGoneForUnknownPrimitive(osmApiException);
        }
    }

    protected void handleFailedUpload(Exception exception) {
        if (exception instanceof OsmApiInitializationException) {
            this.handleOsmApiInitializationException((OsmApiInitializationException)exception);
            return;
        }
        if (exception instanceof OsmApiException) {
            OsmApiException osmApiException = (OsmApiException)exception;
            if (osmApiException.getResponseCode() == 409) {
                this.handleUploadConflict(osmApiException);
                return;
            }
            if (osmApiException.getResponseCode() == 412) {
                this.handlePreconditionFailed(osmApiException);
                return;
            }
            if (osmApiException.getResponseCode() == 410) {
                this.handleGone(osmApiException);
                return;
            }
            osmApiException.printStackTrace();
            String string = I18n.tr("<html>Uploading <strong>failed</strong>.<br>{0}</html>", osmApiException.getDisplayMessage());
            JOptionPane.showMessageDialog(Main.map, string, I18n.tr("Upload to OSM API failed"), 0);
            return;
        }
        String string = exception.getMessage();
        if (string == null) {
            string = exception.toString();
        }
        exception.printStackTrace();
        JOptionPane.showMessageDialog(Main.map, string, I18n.tr("Upload to OSM API failed"), 0);
    }

    protected void handleOsmApiInitializationException(OsmApiInitializationException osmApiInitializationException) {
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Failed to initialize communication with the OSM server {0}.\nCheck the server URL in your preferences and your internet connection.", Main.pref.get("osm-server.url", "http://api.openstreetmap.org/api")), I18n.tr("Error"), 0);
        osmApiInitializationException.printStackTrace();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface UploadHook {
        public boolean checkUpload(Collection<OsmPrimitive> var1, Collection<OsmPrimitive> var2, Collection<OsmPrimitive> var3);
    }
}

