/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTaskList;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UpdateDataAction
extends JosmAction {
    public UpdateDataAction() {
        super(I18n.tr("Update Data"), "updatedata", I18n.tr("Updates the current data layer from the server (re-downloads data)"), Shortcut.registerShortcut("file:updatedata", I18n.tr("Update Data"), 85, 1), true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2 = 0;
        ArrayList<Area> arrayList = new ArrayList<Area>();
        for (DataSource dataSource : Main.main.createOrGetEditLayer().data.dataSources) {
            arrayList.add(new Area(dataSource.bounds.asRect()));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            for (int i = n + 1; i < arrayList.size(); ++i) {
                ((Area)arrayList.get(n)).subtract((Area)arrayList.get(i));
            }
        }
        for (n = arrayList.size() - 1; n > 0; --n) {
            for (int i = n - 1; i > 0; --i) {
                ((Area)arrayList.get(n)).subtract((Area)arrayList.get(i));
            }
        }
        for (Area area : arrayList) {
            if (area.isEmpty()) continue;
            ++n2;
        }
        if (n2 == 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No data to update found. Have you already opened or downloaded a data layer?"), I18n.tr("No data"), 2);
            return;
        }
        new DownloadOsmTaskList().download(false, (Collection<Area>)arrayList);
    }
}

