/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AboutAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class ShowStatusReportAction
extends JosmAction {
    public ShowStatusReportAction() {
        super(I18n.tr("Show Status Report"), "clock", I18n.tr("Show status report with useful information that can be attached to bugs"), Shortcut.registerShortcut("help:showstatusreport", I18n.tr("Help: {0}", I18n.tr("Show Status Report")), 82, 0), true);
    }

    public static String getReportHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(AboutAction.getTextBlock());
        stringBuilder.append("\n");
        stringBuilder.append("Memory Usage: ");
        stringBuilder.append(Runtime.getRuntime().totalMemory() / 1024L / 1024L);
        stringBuilder.append(" MB / ");
        stringBuilder.append(Runtime.getRuntime().maxMemory() / 1024L / 1024L);
        stringBuilder.append(" MB (");
        stringBuilder.append(Runtime.getRuntime().freeMemory() / 1024L / 1024L);
        stringBuilder.append(" MB allocated, but free)");
        stringBuilder.append("\n");
        stringBuilder.append("Java version: " + System.getProperty("java.version"));
        stringBuilder.append("\n\n");
        stringBuilder.append(PluginHandler.getBugReportText());
        stringBuilder.append("\n\n");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ShowStatusReportAction.getReportHeader());
        try {
            object2 = new BufferedReader(new FileReader(Main.pref.getPreferencesDirFile() + File.separator + "preferences"));
            try {
                object = null;
                while ((object = ((BufferedReader)object2).readLine()) != null) {
                    if (((String)object).trim().toLowerCase().startsWith("osm-server.username") || ((String)object).trim().toLowerCase().startsWith("osm-server.password") || ((String)object).trim().toLowerCase().startsWith("marker.show")) continue;
                    stringBuilder.append((String)object);
                    stringBuilder.append("\n");
                }
            }
            finally {
                ((BufferedReader)object2).close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object2 = new JTextArea(stringBuilder.toString());
        ((JTextArea)object2).setWrapStyleWord(true);
        ((JTextArea)object2).setLineWrap(true);
        ((JTextComponent)object2).setEditable(false);
        object = new JScrollPane((Component)object2);
        ((JComponent)object).setPreferredSize(new Dimension(600, 500));
        int n = new ExtendedDialog(Main.parent, I18n.tr(I18n.tr("Status Report")), (Component)object, new String[]{I18n.tr("Copy to clipboard and close"), I18n.tr("Close")}, new String[]{"copy.png", "cancel.png"}).getValue();
        if (n != 1) {
            return;
        }
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(stringBuilder.toString()), new ClipboardOwner(){

                public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

