/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.Shortcut;

public class PlatformHookOsx
extends PlatformHookUnixoid
implements PlatformHook,
InvocationHandler {
    private static PlatformHookOsx ivhandler = new PlatformHookOsx();

    public void preStartupHook() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
    }

    public void startupHook() {
        try {
            Class<?> clazz = Class.forName("com.apple.eawt.Application");
            Object obj = clazz.getConstructor(null).newInstance(null);
            Class<?> clazz2 = Class.forName("com.apple.eawt.ApplicationListener");
            Method method = clazz.getDeclaredMethod("addApplicationListener", clazz2);
            Object object = Proxy.newProxyInstance(PlatformHookOsx.class.getClassLoader(), new Class[]{clazz2}, (InvocationHandler)ivhandler);
            method.invoke(obj, object);
            Method method2 = clazz.getDeclaredMethod("setEnabledPreferencesMenu", Boolean.TYPE);
            method2.invoke(obj, Boolean.TRUE);
        }
        catch (Exception exception) {
            System.out.println("Failed to register with OSX: " + exception);
        }
        SelectAction.needMouseMove = true;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Boolean bl = Boolean.TRUE;
        if (method.getName().equals("handleQuit")) {
            bl = !Main.breakBecauseUnsavedChanges();
        } else if (method.getName().equals("handleAbout")) {
            Main.main.menu.about.actionPerformed(null);
        } else if (method.getName().equals("handlePreferences")) {
            Main.main.menu.preferences.actionPerformed(null);
        } else {
            return null;
        }
        if (objectArray[0] != null) {
            try {
                objectArray[0].getClass().getDeclaredMethod("setHandled", Boolean.TYPE).invoke(objectArray[0], bl);
            }
            catch (Exception exception) {
                System.out.println("Failed to report handled event: " + exception);
            }
        }
        return null;
    }

    public void openUrl(String string) throws IOException {
        Runtime.getRuntime().exec("open " + string);
    }

    public void initShortcutGroups() {
        Main.pref.put("shortcut.groups.0", Integer.toString(-1));
        Main.pref.put("shortcut.groups.1", Integer.toString(128));
        Main.pref.put("shortcut.groups.2", Integer.toString(256));
        Main.pref.put("shortcut.groups.3", Integer.toString(0));
        Main.pref.put("shortcut.groups.4", Integer.toString(512));
        Main.pref.put("shortcut.groups.5", Integer.toString(0));
        Main.pref.put("shortcut.groups.6", Integer.toString(512));
        Main.pref.put("shortcut.groups.7", Integer.toString(-1));
        Main.pref.put("shortcut.groups.8", Integer.toString(192));
        Main.pref.put("shortcut.groups.9", Integer.toString(320));
        Main.pref.put("shortcut.groups.10", Integer.toString(64));
        Main.pref.put("shortcut.groups.11", Integer.toString(576));
        Main.pref.put("shortcut.groups.12", Integer.toString(64));
        Main.pref.put("shortcut.groups.13", Integer.toString(512));
        Main.pref.put("shortcut.groups.14", Integer.toString(-1));
        Main.pref.put("shortcut.groups.15", Integer.toString(640));
        Main.pref.put("shortcut.groups.16", Integer.toString(768));
        Main.pref.put("shortcut.groups.17", Integer.toString(576));
        Main.pref.put("shortcut.groups.18", Integer.toString(512));
        Main.pref.put("shortcut.groups.19", Integer.toString(576));
        Main.pref.put("shortcut.groups.20", Integer.toString(512));
    }

    public void initSystemShortcuts() {
        Shortcut.registerSystemShortcut("apple-reserved-01", "reserved", 32, 256).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-02", "reserved", 32, 320).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-03", "reserved", 32, 768).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-04", "reserved", 32, 384).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-05", "reserved", 9, 64).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-06", "reserved", 9, 256).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-07", "reserved", 9, 320).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-08", "reserved", 9, 128).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-09", "reserved", 9, 192).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-10", "reserved", 27, 256).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-11", "reserved", 27, 768).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-12", "reserved", 112, 128).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-13", "reserved", 113, 128).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-14", "reserved", 114, 128).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-15", "reserved", 115, 128).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-16", "reserved", 115, 192).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-17", "reserved", 116, 128).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-18", "reserved", 116, 256).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-19", "reserved", 117, 128).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-20", "reserved", 117, 192).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-21", "reserved", 118, 128).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-22", "reserved", 120, 0).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-23", "reserved", 121, 0).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-24", "reserved", 122, 0).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-25", "reserved", 123, 0).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-26", "reserved", 128, 256).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-27", "reserved", 128, 320).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-28", "reserved", 128, 768).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-29", "reserved", 45, 256).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-30", "reserved", 45, 768).setAutomatic();
        Shortcut.registerSystemShortcut("system:align-left", "reserved", 91, 256);
        Shortcut.registerSystemShortcut("system:align-right", "reserved", 93, 256);
        Shortcut.registerSystemShortcut("system:spelling", "reserved", 513, 256);
        Shortcut.registerSystemShortcut("system:spellcheck", "reserved", 59, 256);
        Shortcut.registerSystemShortcut("system:preferences", "reserved", 44, 256).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-31", "reserved", 44, 832).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-32", "reserved", 46, 832).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-33", "reserved", 47, 768).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-34", "reserved", 61, 320).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-35", "reserved", 61, 768).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-36", "reserved", 51, 320).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-37", "reserved", 51, 448).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-38", "reserved", 52, 320).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-39", "reserved", 52, 448).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-40", "reserved", 56, 768).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-41", "reserved", 56, 896).setAutomatic();
        Shortcut.registerSystemShortcut("system:selectall", "reserved", 65, 256);
        Shortcut.registerSystemShortcut("system:bold", "reserved", 66, 256);
        Shortcut.registerSystemShortcut("system:copy", "reserved", 67, 256);
        Shortcut.registerSystemShortcut("system:colors", "reserved", 67, 320);
        Shortcut.registerSystemShortcut("system:copystyle", "reserved", 67, 768);
        Shortcut.registerSystemShortcut("system:copyformat", "reserved", 67, 384).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-42", "reserved", 68, 768).setAutomatic();
        Shortcut.registerSystemShortcut("system:dictionarylookup", "reserved", 68, 384);
        Shortcut.registerSystemShortcut("system:findselected", "reserved", 69, 256);
        Shortcut.registerSystemShortcut("system:find", "reserved", 70, 256);
        Shortcut.registerSystemShortcut("system:search", "reserved", 70, 768);
        Shortcut.registerSystemShortcut("system:findnext", "reserved", 71, 256);
        Shortcut.registerSystemShortcut("system:findprev", "reserved", 71, 320);
        Shortcut.registerSystemShortcut("system:hide", "reserved", 72, 256).setAutomatic();
        Shortcut.registerSystemShortcut("system:hideothers", "reserved", 72, 768).setAutomatic();
        Shortcut.registerSystemShortcut("system:info", "reserved", 73, 256);
        Shortcut.registerSystemShortcut("system:inspector", "reserved", 73, 768);
        Shortcut.registerSystemShortcut("system:toselection", "reserved", 74, 256);
        Shortcut.registerSystemShortcut("system:minimize", "reserved", 77, 256);
        Shortcut.registerSystemShortcut("system:minimizeall", "reserved", 77, 768);
        Shortcut.registerSystemShortcut("system:new", "reserved", 78, 256);
        Shortcut.registerSystemShortcut("system:open", "reserved", 79, 256);
        Shortcut.registerSystemShortcut("system:print", "reserved", 80, 256);
        Shortcut.registerSystemShortcut("system:printsetup", "reserved", 80, 320);
        Shortcut.registerSystemShortcut("system:menuexit", "reserved", 81, 256).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-43", "reserved", 81, 320).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-44", "reserved", 81, 832).setAutomatic();
        Shortcut.registerSystemShortcut("system:save", "reserved", 83, 256);
        Shortcut.registerSystemShortcut("system:saveas", "reserved", 83, 320);
        Shortcut.registerSystemShortcut("system:fonts", "reserved", 84, 256);
        Shortcut.registerSystemShortcut("system:toggletoolbar", "reserved", 84, 768);
        Shortcut.registerSystemShortcut("system:underline", "reserved", 85, 256);
        Shortcut.registerSystemShortcut("system:paste", "reserved", 86, 256);
        Shortcut.registerSystemShortcut("system:pastestyle", "reserved", 86, 768);
        Shortcut.registerSystemShortcut("system:pastemwithoutstyle", "reserved", 86, 832);
        Shortcut.registerSystemShortcut("system:pasteformatting", "reserved", 86, 384);
        Shortcut.registerSystemShortcut("system:closewindow", "reserved", 87, 256);
        Shortcut.registerSystemShortcut("system:closefile", "reserved", 87, 320);
        Shortcut.registerSystemShortcut("system:closeallwindows", "reserved", 87, 768);
        Shortcut.registerSystemShortcut("system:cut", "reserved", 88, 256);
        Shortcut.registerSystemShortcut("system:undo", "reserved", 90, 256);
        Shortcut.registerSystemShortcut("system:redo", "reserved", 90, 320);
        Shortcut.registerSystemShortcut("apple-reserved-45", "reserved", 39, 256).setAutomatic();
        Shortcut.registerSystemShortcut("system:movefocusright", "reserved", 39, 128);
        Shortcut.registerSystemShortcut("apple-reserved-49", "reserved", 37, 256).setAutomatic();
        Shortcut.registerSystemShortcut("system:movefocusleft", "reserved", 37, 128);
        Shortcut.registerSystemShortcut("system:movefocusup", "reserved", 38, 128);
        Shortcut.registerSystemShortcut("system:movefocusdown", "reserved", 40, 128);
        Shortcut.registerSystemShortcut("system:about", "reserved", 0, -1).setAutomatic();
        Shortcut.registerSystemShortcut("view:zoomin", "reserved", 107, 256);
        Shortcut.registerSystemShortcut("view:zoomout", "reserved", 109, 256);
    }

    public String makeTooltip(String string, Shortcut shortcut) {
        String string2 = UIManager.getLookAndFeel().getID();
        boolean bl = true;
        if (string2.contains("Mac") || string2.contains("Aqua")) {
            bl = false;
        }
        String string3 = "";
        if (bl) {
            string3 = string3 + "<html>";
        }
        string3 = string3 + string;
        if (shortcut != null && shortcut.getKeyText().length() != 0) {
            string3 = string3 + " ";
            if (bl) {
                string3 = string3 + "<font size='-2'>";
            }
            string3 = string3 + "(" + shortcut.getKeyText() + ")";
            if (bl) {
                string3 = string3 + "</font>";
            }
        }
        if (bl) {
            string3 = string3 + "&nbsp;</html>";
        }
        return string3;
    }
}

