/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AboutAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginDownloader {
    private static final String[] pluginSites = new String[]{"http://josm.openstreetmap.de/plugin"};

    public static Collection<String> getSites() {
        return Main.pref.getCollection("pluginmanager.sites", Arrays.asList(pluginSites));
    }

    public static void setSites(Collection<String> collection) {
        Main.pref.putCollection("pluginmanager.sites", collection);
    }

    public static int downloadDescription() {
        int n = 0;
        for (String string : PluginDownloader.getSites()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new URL(string).openStream(), "utf-8"));
                new File(Main.pref.getPreferencesDir() + "plugins").mkdir();
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(Main.pref.getPluginsDirFile(), n + "-site-" + string.replaceAll("[/:\\\\ <>|]", "_") + ".txt")), "utf-8"));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    bufferedWriter.append(string2 + "\n");
                    string2 = bufferedReader.readLine();
                }
                bufferedReader.close();
                bufferedWriter.close();
                ++n;
            }
            catch (IOException iOException) {}
        }
        return n;
    }

    private static boolean download(PluginInformation pluginInformation, File file) {
        int n;
        if (pluginInformation.mainversion > AboutAction.getVersionNumber() && (n = new ExtendedDialog(Main.parent, I18n.tr("Skip download"), I18n.tr("JOSM version {0} required for plugin {1}.", pluginInformation.mainversion, pluginInformation.name), new String[]{I18n.tr("Download Plugin"), I18n.tr("Skip Download")}, new String[]{"download.png", "cancel.png"}).getValue()) != 1) {
            return false;
        }
        try {
            InputStream inputStream = new URL(pluginInformation.downloadlink).openStream();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[8192];
            int n2 = inputStream.read(byArray);
            while (n2 != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
            ((OutputStream)fileOutputStream).close();
            inputStream.close();
            new PluginInformation(file);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            file.delete();
            return false;
        }
    }

    public static void update(Collection<PluginInformation> collection) {
        Main.worker.execute(new UpdateTask(collection, true));
    }

    public Collection<PluginInformation> download(Collection<PluginInformation> collection) {
        UpdateTask updateTask = new UpdateTask(collection, false);
        try {
            Future<UpdateTask> future = Main.worker.submit(updateTask, updateTask);
            updateTask = future.get();
            return updateTask.failed;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return collection;
    }

    public static boolean moveUpdatedPlugins() {
        File file = Main.pref.getPluginsDirFile();
        boolean bl = true;
        if (file.exists() && file.isDirectory() && file.canWrite()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".new");
                }
            })) {
                String string = file2.getPath();
                File file3 = new File(string.substring(0, string.length() - 4));
                bl = (file3.delete() || !file3.exists()) && file2.renameTo(file3) && bl;
            }
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UpdateTask
    extends PleaseWaitRunnable {
        private final Collection<PluginInformation> toUpdate;
        public final Collection<PluginInformation> failed = new LinkedList<PluginInformation>();
        private String errors = "";
        private int count = 0;
        private boolean update;

        private UpdateTask(Collection<PluginInformation> collection, boolean bl) {
            super(bl ? I18n.tr("Update Plugins") : I18n.tr("Download Plugins"));
            this.update = bl;
            this.toUpdate = collection;
        }

        @Override
        protected void cancel() {
            this.finish();
        }

        @Override
        protected void finish() {
            Main.pleaseWaitDlg.setVisible(false);
            if (this.errors.length() > 0) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("There were problems with the following plugins:\n\n {0}", this.errors));
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.trn("{0} Plugin successfully downloaded. Please restart JOSM.", "{0} Plugins successfully downloaded. Please restart JOSM.", this.count, this.count));
            }
        }

        @Override
        protected void realRun() throws SAXException, IOException {
            File file = Main.pref.getPluginsDirFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            for (PluginInformation pluginInformation : this.toUpdate) {
                Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Downloading Plugin {0}...", pluginInformation.name));
                File file2 = new File(file, pluginInformation.name + ".jar.new");
                if (PluginDownloader.download(pluginInformation, file2)) {
                    ++this.count;
                    this.failed.add(pluginInformation);
                    continue;
                }
                this.errors = this.errors + pluginInformation.name + "\n";
            }
            PluginDownloader.moveUpdatedPlugins();
        }
    }
}

