/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.openstreetmap.josm.gui.PleaseWaitDialog;
import org.openstreetmap.josm.tools.I18n;

public class ProgressInputStream
extends InputStream {
    private final InputStream in;
    private int readSoFar = 0;
    private int lastDialogUpdate = 0;
    private final URLConnection connection;
    private PleaseWaitDialog pleaseWaitDlg;

    public ProgressInputStream(URLConnection uRLConnection, PleaseWaitDialog pleaseWaitDialog) throws IOException, OsmServerException {
        this.connection = uRLConnection;
        try {
            this.in = uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            if (uRLConnection.getHeaderField("Error") != null) {
                throw new OsmServerException(I18n.tr(uRLConnection.getHeaderField("Error")));
            }
            throw iOException;
        }
        int n = uRLConnection.getContentLength();
        this.pleaseWaitDlg = pleaseWaitDialog;
        if (pleaseWaitDialog == null) {
            return;
        }
        if (n > 0) {
            pleaseWaitDialog.progress.setMaximum(n);
        } else {
            pleaseWaitDialog.progress.setMaximum(0);
        }
        pleaseWaitDialog.progress.setValue(0);
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 != -1) {
            this.advanceTicker(n3);
        }
        return n3;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n != -1) {
            this.advanceTicker(1);
        }
        return n;
    }

    private void advanceTicker(int n) {
        if (this.pleaseWaitDlg == null) {
            return;
        }
        if (this.pleaseWaitDlg.progress.getMaximum() == 0 && this.connection.getContentLength() != -1) {
            this.pleaseWaitDlg.progress.setMaximum(this.connection.getContentLength());
        }
        this.readSoFar += n;
        if (this.readSoFar / 1024 != this.lastDialogUpdate) {
            ++this.lastDialogUpdate;
            String string = " " + this.readSoFar / 1024 + "/";
            string = string + (this.pleaseWaitDlg.progress.getMaximum() == 0 ? "??? KB" : this.pleaseWaitDlg.progress.getMaximum() / 1024 + " KB");
            this.pleaseWaitDlg.progress.setValue(this.readSoFar);
            String string2 = this.pleaseWaitDlg.currentAction.getText();
            int n2 = string2.indexOf(32);
            string2 = n2 != -1 ? string2.substring(0, n2) + string : string2 + string;
            this.pleaseWaitDlg.currentAction.setText(string2);
        }
    }

    public class OsmServerException
    extends IOException {
        private OsmServerException(String string) {
            super(string);
        }
    }
}

