/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class LafPreference
implements PreferenceSetting {
    private JComboBox lafCombo;
    public JPanel panel;
    private JCheckBox showSplashScreen = new JCheckBox(I18n.tr("Show splash screen at startup"));
    private JCheckBox showID = new JCheckBox(I18n.tr("Show object ID in selection lists"));
    private JCheckBox drawHelperLine = new JCheckBox(I18n.tr("Draw rubber-band helper line"));
    private JCheckBox modeless = new JCheckBox(I18n.tr("Modeless working (Potlatch style)"));

    public void addGui(PreferenceDialog preferenceDialog) {
        Object object;
        this.lafCombo = new JComboBox<UIManager.LookAndFeelInfo>(UIManager.getInstalledLookAndFeels());
        try {
            object = Class.forName("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            Object obj = ((Class)object).getConstructor(null).newInstance(null);
            this.lafCombo.addItem(new UIManager.LookAndFeelInfo(((LookAndFeel)obj).getName(), "ch.randelshofer.quaqua.QuaquaLookAndFeel"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = Main.pref.get("laf");
        for (int i = 0; i < this.lafCombo.getItemCount(); ++i) {
            if (!((UIManager.LookAndFeelInfo)this.lafCombo.getItemAt(i)).getClassName().equals(object)) continue;
            this.lafCombo.setSelectedIndex(i);
            break;
        }
        final ListCellRenderer listCellRenderer = this.lafCombo.getRenderer();
        this.lafCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                return listCellRenderer.getListCellRendererComponent(jList, ((UIManager.LookAndFeelInfo)object).getName(), n, bl, bl2);
            }
        });
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.showSplashScreen.setToolTipText(I18n.tr("Show splash screen at startup"));
        this.showSplashScreen.setSelected(Main.pref.getBoolean("draw.splashscreen", true));
        this.panel.add((Component)this.showSplashScreen, GBC.eop().insets(20, 0, 0, 0));
        this.showID.setToolTipText(I18n.tr("Show object ID in selection lists"));
        this.showID.setSelected(Main.pref.getBoolean("osm-primitives.showid", false));
        this.panel.add((Component)this.showID, GBC.eop().insets(20, 0, 0, 0));
        this.drawHelperLine.setToolTipText(I18n.tr("Draw rubber-band helper line"));
        this.drawHelperLine.setSelected(Main.pref.getBoolean("draw.helper-line", true));
        this.panel.add((Component)this.drawHelperLine, GBC.eop().insets(20, 0, 0, 0));
        this.modeless.setToolTipText(I18n.tr("Do not require to switch modes (potlatch style workflow)"));
        this.modeless.setSelected(Main.pref.getBoolean("modeless", false));
        this.panel.add((Component)this.modeless, GBC.eop().insets(20, 0, 0, 0));
        this.panel.add(Box.createVerticalGlue(), GBC.eol().insets(0, 20, 0, 0));
        this.panel.add((Component)new JLabel(I18n.tr("Look and Feel")), GBC.std().insets(20, 0, 0, 0));
        this.panel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.panel.add((Component)this.lafCombo, GBC.eol().fill(2));
        JScrollPane jScrollPane = new JScrollPane(this.panel);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        preferenceDialog.displaycontent.addTab(I18n.tr("Look and Feel"), jScrollPane);
    }

    public boolean ok() {
        Main.pref.put("draw.splashscreen", this.showSplashScreen.isSelected());
        Main.pref.put("osm-primitives.showid", this.showID.isSelected());
        Main.pref.put("draw.helper-line", this.drawHelperLine.isSelected());
        Main.pref.put("modeless", this.modeless.isSelected());
        return Main.pref.put("laf", ((UIManager.LookAndFeelInfo)this.lafCombo.getSelectedItem()).getClassName());
    }
}

