/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.ConflictResolver;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ConflictResolutionDialog;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConflictDialog
extends ToggleDialog {
    public final Map<OsmPrimitive, OsmPrimitive> conflicts = new HashMap<OsmPrimitive, OsmPrimitive>();
    private final DefaultListModel model = new DefaultListModel();
    private final JList displaylist = new JList(this.model);
    private final SideButton sbSelect = new SideButton(I18n.marktr("Select"), "select", "Conflict", I18n.tr("Set the selected elements on the map to the selected items in the list above."), new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
            for (Object object : ConflictDialog.this.displaylist.getSelectedValues()) {
                linkedList.add((OsmPrimitive)object);
            }
            Main.ds.setSelected(linkedList);
        }
    });
    private final SideButton sbResolve = new SideButton(I18n.marktr("Resolve"), "conflict", "Conflict", I18n.tr("Open a merge dialog of all selected items in the list above."), new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ConflictDialog.this.resolve();
        }
    });

    public ConflictDialog() {
        super(I18n.tr("Conflict"), "conflict", I18n.tr("Merging conflicts."), Shortcut.registerShortcut("subwindow:conflict", I18n.tr("Toggle: {0}", I18n.tr("Conflict")), 67, 4), 100);
        this.displaylist.setCellRenderer(new OsmPrimitivRenderer());
        this.displaylist.setSelectionMode(2);
        this.displaylist.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    ConflictDialog.this.resolve();
                }
            }
        });
        this.add((Component)new JScrollPane(this.displaylist), "Center");
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(this.sbResolve);
        jPanel.add(this.sbSelect);
        this.add((Component)jPanel, "South");
        DataSet.selListeners.add(new SelectionChangedListener(){

            @Override
            public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
                ConflictDialog.this.displaylist.clearSelection();
                for (OsmPrimitive osmPrimitive : collection) {
                    if (!ConflictDialog.this.conflicts.containsKey(osmPrimitive)) continue;
                    int n = ConflictDialog.this.model.indexOf(osmPrimitive);
                    ConflictDialog.this.displaylist.addSelectionInterval(n, n);
                }
            }
        });
        this.displaylist.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Main.map.mapView.repaint();
            }
        });
        this.rebuildList();
    }

    private final void resolve() {
        String string = Main.pref.get("conflict.resolution", "extended");
        if ((string = string.trim().toLowerCase()).equals("traditional")) {
            this.resolveTraditional();
        } else if (string.equals("extended")) {
            this.resolveExtended();
        } else {
            System.out.println(I18n.tr("WARNING: unexpected value for preference conflict.resolution, got " + string));
            this.resolveTraditional();
        }
    }

    private final void resolveExtended() {
        if (this.model.size() == 1) {
            this.displaylist.setSelectedIndex(0);
        }
        if (this.displaylist.getSelectedIndex() == -1) {
            return;
        }
        int[] nArray = this.displaylist.getSelectedIndices();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        int n = nArray[0];
        OsmPrimitive osmPrimitive = (OsmPrimitive)this.model.get(n);
        OsmPrimitive osmPrimitive2 = this.conflicts.get(osmPrimitive);
        ConflictResolutionDialog conflictResolutionDialog = new ConflictResolutionDialog(Main.parent);
        conflictResolutionDialog.getConflictResolver().populate(osmPrimitive, osmPrimitive2);
        conflictResolutionDialog.setVisible(true);
        Main.map.mapView.repaint();
    }

    private final void resolveTraditional() {
        if (this.model.size() == 1) {
            this.displaylist.setSelectedIndex(0);
        }
        if (this.displaylist.getSelectedIndex() == -1) {
            return;
        }
        HashMap<OsmPrimitive, OsmPrimitive> hashMap = new HashMap<OsmPrimitive, OsmPrimitive>();
        for (int n : this.displaylist.getSelectedIndices()) {
            OsmPrimitive osmPrimitive = (OsmPrimitive)this.model.get(n);
            hashMap.put(osmPrimitive, this.conflicts.get(osmPrimitive));
        }
        ConflictResolver conflictResolver = new ConflictResolver(hashMap);
        int n = new ExtendedDialog(Main.parent, I18n.tr("Resolve Conflicts"), conflictResolver, new String[]{I18n.tr("Solve Conflict"), I18n.tr("Cancel")}, new String[]{"dialogs/conflict.png", "cancel.png"}).getValue();
        if (n != 1) {
            return;
        }
        Main.main.undoRedo.add(new ConflictResolveCommand(conflictResolver.conflicts, hashMap));
        Main.map.mapView.repaint();
    }

    public final void rebuildList() {
        this.model.removeAllElements();
        for (OsmPrimitive osmPrimitive : this.conflicts.keySet()) {
            this.model.addElement(osmPrimitive);
        }
        if (this.model.size() != 0) {
            this.setTitle(I18n.tr("Conflicts: {0}", this.model.size()), true);
        } else {
            this.setTitle(I18n.tr("Conflicts"), false);
        }
        this.sbSelect.setEnabled(this.model.size() > 0);
        this.sbResolve.setEnabled(this.model.size() > 0);
    }

    public final void add(Map<OsmPrimitive, OsmPrimitive> map) {
        this.conflicts.putAll(map);
        this.rebuildList();
    }

    public void removeConflictForPrimitive(OsmPrimitive osmPrimitive) {
        if (!this.conflicts.keySet().contains(osmPrimitive)) {
            return;
        }
        this.conflicts.remove(osmPrimitive);
        this.rebuildList();
        this.repaint();
    }

    public void addConflict(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        this.conflicts.put(osmPrimitive, osmPrimitive2);
        this.rebuildList();
        this.repaint();
    }

    public static Color getColor() {
        return Main.pref.getColor(I18n.marktr("conflict"), Color.gray);
    }

    public void paintConflicts(final Graphics graphics, final NavigatableComponent navigatableComponent) {
        Color color = ConflictDialog.getColor();
        if (color.equals(Main.pref.getColor(I18n.marktr("background"), Color.black))) {
            return;
        }
        graphics.setColor(color);
        AbstractVisitor abstractVisitor = new AbstractVisitor(){

            public void visit(Node node) {
                Point point = navigatableComponent.getPoint(node.getEastNorth());
                graphics.drawRect(point.x - 1, point.y - 1, 2, 2);
            }

            public void visit(Node node, Node node2) {
                Point point = navigatableComponent.getPoint(node.getEastNorth());
                Point point2 = navigatableComponent.getPoint(node2.getEastNorth());
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }

            public void visit(Way way) {
                Node node = null;
                for (Node node2 : way.nodes) {
                    if (node == null) {
                        node = node2;
                        continue;
                    }
                    this.visit(node, node2);
                    node = node2;
                }
            }

            public void visit(Relation relation) {
                for (RelationMember relationMember : relation.members) {
                    relationMember.member.visit(this);
                }
            }
        };
        for (Object object : this.displaylist.getSelectedValues()) {
            if (this.conflicts.get(object) == null) continue;
            this.conflicts.get(object).visit(abstractVisitor);
        }
    }
}

