/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.gui.conflict.ComparePairListCellRenderer;
import org.openstreetmap.josm.gui.conflict.ListMergeModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListMerger<T>
extends JPanel
implements PropertyChangeListener,
Observer {
    private static final Logger logger = Logger.getLogger(ListMerger.class.getName());
    protected JTable myEntriesTable;
    protected JTable mergedEntriesTable;
    protected JTable theirEntriesTable;
    protected ListMergeModel<T> model;
    private CopyStartLeftAction copyStartLeftAction;
    private CopyBeforeCurrentLeftAction copyBeforeCurrentLeftAction;
    private CopyAfterCurrentLeftAction copyAfterCurrentLeftAction;
    private CopyEndLeftAction copyEndLeftAction;
    private CopyStartRightAction copyStartRightAction;
    private CopyBeforeCurrentRightAction copyBeforeCurrentRightAction;
    private CopyAfterCurrentRightAction copyAfterCurrentRightAction;
    private CopyEndRightAction copyEndRightAction;
    private MoveUpMergedAction moveUpMergedAction;
    private MoveDownMergedAction moveDownMergedAction;
    private RemoveMergedAction removeMergedAction;
    private FreezeAction freezeAction;
    private AdjustmentSynchronizer adjustmentSynchronizer;
    private JCheckBox cbLockMyScrolling;
    private JCheckBox cbLockMergedScrolling;
    private JCheckBox cbLockTheirScrolling;
    private JLabel lblMyVersion;
    private JLabel lblMergedVersion;
    private JLabel lblTheirVersion;
    private JLabel lblFrozenState;

    protected abstract JScrollPane buildMyElementsTable();

    protected abstract JScrollPane buildMergedElementsTable();

    protected abstract JScrollPane buildTheirElementsTable();

    protected JScrollPane embeddInScrollPane(JTable jTable) {
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        if (this.adjustmentSynchronizer == null) {
            this.adjustmentSynchronizer = new AdjustmentSynchronizer();
        }
        return jScrollPane;
    }

    protected void wireActionsToSelectionModels() {
        this.myEntriesTable.getSelectionModel().addListSelectionListener(this.copyStartLeftAction);
        this.myEntriesTable.getSelectionModel().addListSelectionListener(this.copyBeforeCurrentLeftAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.copyBeforeCurrentLeftAction);
        this.myEntriesTable.getSelectionModel().addListSelectionListener(this.copyAfterCurrentLeftAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.copyAfterCurrentLeftAction);
        this.myEntriesTable.getSelectionModel().addListSelectionListener(this.copyEndLeftAction);
        this.theirEntriesTable.getSelectionModel().addListSelectionListener(this.copyStartRightAction);
        this.theirEntriesTable.getSelectionModel().addListSelectionListener(this.copyBeforeCurrentRightAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.copyBeforeCurrentRightAction);
        this.theirEntriesTable.getSelectionModel().addListSelectionListener(this.copyAfterCurrentRightAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.copyAfterCurrentRightAction);
        this.theirEntriesTable.getSelectionModel().addListSelectionListener(this.copyEndRightAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.moveUpMergedAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.moveDownMergedAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.removeMergedAction);
    }

    protected JPanel buildLeftButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.copyStartLeftAction = new CopyStartLeftAction();
        JButton jButton = new JButton(this.copyStartLeftAction);
        jButton.setName("button.copystartleft");
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.copyBeforeCurrentLeftAction = new CopyBeforeCurrentLeftAction();
        jButton = new JButton(this.copyBeforeCurrentLeftAction);
        jButton.setName("button.copybeforecurrentleft");
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.copyAfterCurrentLeftAction = new CopyAfterCurrentLeftAction();
        jButton = new JButton(this.copyAfterCurrentLeftAction);
        jButton.setName("button.copyaftercurrentleft");
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.copyEndLeftAction = new CopyEndLeftAction();
        jButton = new JButton(this.copyEndLeftAction);
        jButton.setName("button.copyendleft");
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    protected JPanel buildRightButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.copyStartRightAction = new CopyStartRightAction();
        jPanel.add((Component)new JButton(this.copyStartRightAction), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.copyBeforeCurrentRightAction = new CopyBeforeCurrentRightAction();
        jPanel.add((Component)new JButton(this.copyBeforeCurrentRightAction), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.copyAfterCurrentRightAction = new CopyAfterCurrentRightAction();
        jPanel.add((Component)new JButton(this.copyAfterCurrentRightAction), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.copyEndRightAction = new CopyEndRightAction();
        jPanel.add((Component)new JButton(this.copyEndRightAction), gridBagConstraints);
        return jPanel;
    }

    protected JPanel buildMergedListControlButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 0.0;
        this.moveUpMergedAction = new MoveUpMergedAction();
        jPanel.add((Component)new JButton(this.moveUpMergedAction), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.moveDownMergedAction = new MoveDownMergedAction();
        jPanel.add((Component)new JButton(this.moveDownMergedAction), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.removeMergedAction = new RemoveMergedAction();
        jPanel.add((Component)new JButton(this.removeMergedAction), gridBagConstraints);
        return jPanel;
    }

    protected JPanel buildAdjustmentLockControlPanel(JCheckBox jCheckBox) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        jPanel.add(new JLabel(I18n.tr("lock scrolling")));
        jPanel.add(jCheckBox);
        return jPanel;
    }

    protected JPanel buildComparePairSelectionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(new JLabel(I18n.tr("Compare ")));
        JComboBox jComboBox = new JComboBox(this.model.getComparePairListModel());
        jComboBox.setRenderer(new ComparePairListCellRenderer());
        jPanel.add(jComboBox);
        return jPanel;
    }

    protected JPanel buildFrozeStateControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.lblFrozenState = new JLabel();
        jPanel.add(this.lblFrozenState);
        this.freezeAction = new FreezeAction();
        JToggleButton jToggleButton = new JToggleButton(this.freezeAction);
        this.freezeAction.adapt(jToggleButton);
        jToggleButton.setName("button.freeze");
        jPanel.add(jToggleButton);
        return jPanel;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.lblMyVersion = new JLabel(I18n.tr("My version"));
        this.lblMyVersion.setToolTipText(I18n.tr("List of elements in my dataset, i.e. the local dataset"));
        this.add((Component)this.lblMyVersion, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.lblMergedVersion = new JLabel(I18n.tr("Merged version"));
        this.lblMergedVersion.setToolTipText(I18n.tr("List of merged elements. They will replace the my elements when the merge decisions are applied."));
        this.add((Component)this.lblMergedVersion, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.lblTheirVersion = new JLabel(I18n.tr("Their version"));
        this.lblTheirVersion.setToolTipText(I18n.tr("List of elements in their dataset, i.e. the server dataset"));
        this.add((Component)this.lblTheirVersion, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.cbLockMyScrolling = new JCheckBox();
        this.cbLockMyScrolling.setName("checkbox.lockmyscrolling");
        this.add((Component)this.buildAdjustmentLockControlPanel(this.cbLockMyScrolling), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.cbLockMergedScrolling = new JCheckBox();
        this.cbLockMergedScrolling.setName("checkbox.lockmergedscrolling");
        this.add((Component)this.buildAdjustmentLockControlPanel(this.cbLockMergedScrolling), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        this.cbLockTheirScrolling = new JCheckBox();
        this.cbLockTheirScrolling.setName("checkbox.locktheirscrolling");
        this.add((Component)this.buildAdjustmentLockControlPanel(this.cbLockTheirScrolling), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JScrollPane jScrollPane = this.buildMyElementsTable();
        this.adjustmentSynchronizer.adapt(this.cbLockMyScrolling, jScrollPane.getVerticalScrollBar());
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.buildLeftButtonPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        jScrollPane = this.buildMergedElementsTable();
        this.adjustmentSynchronizer.adapt(this.cbLockMergedScrolling, jScrollPane.getVerticalScrollBar());
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.buildRightButtonPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        jScrollPane = this.buildTheirElementsTable();
        this.adjustmentSynchronizer.adapt(this.cbLockTheirScrolling, jScrollPane.getVerticalScrollBar());
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.buildMergedListControlButtons(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.buildComparePairSelectionPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.buildFrozeStateControlPanel(), gridBagConstraints);
        this.wireActionsToSelectionModels();
    }

    public ListMerger(ListMergeModel<T> listMergeModel) {
        this.model = listMergeModel;
        listMergeModel.addObserver(this);
        this.build();
        listMergeModel.addPropertyChangeListener(this);
    }

    protected void handlePropertyChangeFrozen(boolean bl, boolean bl2) {
        this.myEntriesTable.getSelectionModel().clearSelection();
        this.myEntriesTable.setEnabled(!bl2);
        this.theirEntriesTable.getSelectionModel().clearSelection();
        this.theirEntriesTable.setEnabled(!bl2);
        this.mergedEntriesTable.getSelectionModel().clearSelection();
        this.mergedEntriesTable.setEnabled(!bl2);
        if (this.freezeAction != null) {
            this.freezeAction.putValue(FreezeActionProperties.PROP_SELECTED, bl2);
        }
        if (bl2) {
            this.lblFrozenState.setText(I18n.tr("<html>Click <strong>{0}</strong> to start merging my and their entries</html>", this.freezeAction.getValue("Name")));
        } else {
            this.lblFrozenState.setText(I18n.tr("<html>Click <strong>{0}</strong> to finish merging my and their entries</html>", this.freezeAction.getValue("Name")));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(ListMergeModel.FROZEN_PROP)) {
            this.handlePropertyChangeFrozen((Boolean)propertyChangeEvent.getOldValue(), (Boolean)propertyChangeEvent.getNewValue());
        }
    }

    public ListMergeModel<T> getModel() {
        return this.model;
    }

    @Override
    public void update(Observable observable, Object object) {
        this.lblMyVersion.setText(I18n.trn("My version ({0} entry)", "My version ({0} entries)", this.model.getMyEntriesSize(), this.model.getMyEntriesSize()));
        this.lblMergedVersion.setText(I18n.trn("Merged version ({0} entry)", "Merged version ({0} entries)", this.model.getMergedEntriesSize(), this.model.getMergedEntriesSize()));
        this.lblTheirVersion.setText(I18n.trn("Their version ({0} entry)", "Their version ({0} entries)", this.model.getTheirEntriesSize(), this.model.getTheirEntriesSize()));
    }

    class AdjustmentSynchronizer
    implements AdjustmentListener {
        private final ArrayList<Adjustable> synchronizedAdjustables = new ArrayList();
        private final HashMap<Adjustable, Boolean> enabledMap = new HashMap();
        private final Observable observable = new Observable();

        public void participateInSynchronizedScrolling(Adjustable adjustable) {
            if (adjustable == null) {
                return;
            }
            if (this.synchronizedAdjustables.contains(adjustable)) {
                return;
            }
            this.synchronizedAdjustables.add(adjustable);
            this.setParticipatingInSynchronizedScrolling(adjustable, true);
            adjustable.addAdjustmentListener(this);
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (!this.enabledMap.get(adjustmentEvent.getAdjustable()).booleanValue()) {
                return;
            }
            for (Adjustable adjustable : this.synchronizedAdjustables) {
                if (adjustable == adjustmentEvent.getAdjustable() || !this.isParticipatingInSynchronizedScrolling(adjustable)) continue;
                adjustable.setValue(adjustmentEvent.getValue());
            }
        }

        protected void setParticipatingInSynchronizedScrolling(Adjustable adjustable, boolean bl) {
            if (adjustable == null) {
                throw new IllegalArgumentException(I18n.tr("parameter '{0}' must not be null", "adjustable"));
            }
            if (!this.synchronizedAdjustables.contains(adjustable)) {
                throw new IllegalStateException(I18n.tr("adjustable {0} not registered yet. Can't set participation in synchronized adjustment", adjustable));
            }
            this.enabledMap.put(adjustable, bl);
            this.observable.notifyObservers();
        }

        protected boolean isParticipatingInSynchronizedScrolling(Adjustable adjustable) throws IllegalStateException {
            if (!this.synchronizedAdjustables.contains(adjustable)) {
                throw new IllegalStateException(I18n.tr("adjustable {0} not registered yet", adjustable));
            }
            return this.enabledMap.get(adjustable);
        }

        protected void adapt(final JCheckBox jCheckBox, final Adjustable adjustable) throws IllegalArgumentException, IllegalStateException {
            if (adjustable == null) {
                throw new IllegalArgumentException(I18n.tr("parameter '{0}' must not be null", "adjustable"));
            }
            if (jCheckBox == null) {
                throw new IllegalArgumentException(I18n.tr("parameter '{0}' must not be null", "view"));
            }
            if (!this.synchronizedAdjustables.contains(adjustable)) {
                this.participateInSynchronizedScrolling(adjustable);
            }
            jCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    switch (itemEvent.getStateChange()) {
                        case 1: {
                            if (AdjustmentSynchronizer.this.isParticipatingInSynchronizedScrolling(adjustable)) break;
                            AdjustmentSynchronizer.this.setParticipatingInSynchronizedScrolling(adjustable, true);
                            break;
                        }
                        case 2: {
                            if (!AdjustmentSynchronizer.this.isParticipatingInSynchronizedScrolling(adjustable)) break;
                            AdjustmentSynchronizer.this.setParticipatingInSynchronizedScrolling(adjustable, false);
                        }
                    }
                }
            });
            this.observable.addObserver(new Observer(){

                public void update(Observable observable, Object object) {
                    boolean bl = AdjustmentSynchronizer.this.isParticipatingInSynchronizedScrolling(adjustable);
                    if (jCheckBox.isSelected() != bl) {
                        jCheckBox.setSelected(bl);
                    }
                }
            });
            this.setParticipatingInSynchronizedScrolling(adjustable, true);
            jCheckBox.setSelected(true);
        }
    }

    class FreezeAction
    extends AbstractAction
    implements ItemListener,
    FreezeActionProperties {
        public FreezeAction() {
            this.putValue("Name", I18n.tr("Freeze"));
            this.putValue("ShortDescription", I18n.tr("Freeze the current list of merged elements"));
            this.putValue(PROP_SELECTED, false);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void adapt(final JToggleButton jToggleButton) {
            jToggleButton.addItemListener(this);
            this.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals(FreezeActionProperties.PROP_SELECTED)) {
                        jToggleButton.setSelected((Boolean)propertyChangeEvent.getNewValue());
                    }
                }
            });
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            int n = itemEvent.getStateChange();
            if (n == 1) {
                this.putValue("Name", I18n.tr("Unfreeze"));
                this.putValue("ShortDescription", I18n.tr("Unfreeze the list of merged elements and start merging"));
                ListMerger.this.model.setFrozen(true);
            } else if (n == 2) {
                this.putValue("Name", I18n.tr("Freeze"));
                this.putValue("ShortDescription", I18n.tr("Freeze the current list of merged elements"));
                ListMerger.this.model.setFrozen(false);
            }
            boolean bl = (Boolean)this.getValue(PROP_SELECTED);
            if (bl != (itemEvent.getStateChange() == 1)) {
                this.putValue(PROP_SELECTED, itemEvent.getStateChange() == 1);
            }
        }
    }

    public static interface FreezeActionProperties {
        public static final String PROP_SELECTED = FreezeActionProperties.class.getName() + ".selected";
    }

    class RemoveMergedAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveMergedAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "remove.png");
            this.putValue("SmallIcon", imageIcon);
            if (imageIcon == null) {
                this.putValue("Name", I18n.tr("Remove"));
            }
            this.putValue("ShortDescription", I18n.tr("Remove the selected entries from the list of merged elements"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListMerger.this.mergedEntriesTable.getSelectedRows();
            ListMerger.this.model.removeMerged(nArray);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = ListMerger.this.mergedEntriesTable.getSelectedRows();
            this.setEnabled(nArray != null && nArray.length > 0);
        }
    }

    class MoveDownMergedAction
    extends AbstractAction
    implements ListSelectionListener {
        public MoveDownMergedAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "movedown.png");
            this.putValue("SmallIcon", imageIcon);
            if (imageIcon == null) {
                this.putValue("Name", I18n.tr("Down"));
            }
            this.putValue("ShortDescription", I18n.tr("Move down the selected entries by one position"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListMerger.this.mergedEntriesTable.getSelectedRows();
            ListMerger.this.model.moveDownMerged(nArray);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = ListMerger.this.mergedEntriesTable.getSelectedRows();
            this.setEnabled(nArray != null && nArray.length > 0 && nArray[nArray.length - 1] != ListMerger.this.mergedEntriesTable.getRowCount() - 1);
        }
    }

    class MoveUpMergedAction
    extends AbstractAction
    implements ListSelectionListener {
        public MoveUpMergedAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "moveup.png");
            this.putValue("SmallIcon", imageIcon);
            if (imageIcon == null) {
                this.putValue("Name", I18n.tr("Up"));
            }
            this.putValue("ShortDescription", I18n.tr("Move up the selected elements by one position"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListMerger.this.mergedEntriesTable.getSelectedRows();
            ListMerger.this.model.moveUpMerged(nArray);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = ListMerger.this.mergedEntriesTable.getSelectedRows();
            this.setEnabled(nArray != null && nArray.length > 0 && nArray[0] != 0);
        }
    }

    class CopyAfterCurrentRightAction
    extends AbstractAction
    implements ListSelectionListener {
        public CopyAfterCurrentRightAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "copyaftercurrentright.png");
            this.putValue("SmallIcon", imageIcon);
            if (imageIcon == null) {
                this.putValue("Name", "< after");
            }
            this.putValue("ShortDescription", I18n.tr("Copy their selected element after the first selected element in the list of merged elements"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListMerger.this.theirEntriesTable.getSelectedRows();
            int[] nArray2 = ListMerger.this.mergedEntriesTable.getSelectedRows();
            if (nArray2 == null || nArray2.length == 0) {
                return;
            }
            int n = nArray2[0];
            ListMerger.this.model.copyTheirAfterCurrent(nArray, n);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(!ListMerger.this.theirEntriesTable.getSelectionModel().isSelectionEmpty() && !ListMerger.this.mergedEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyBeforeCurrentRightAction
    extends AbstractAction
    implements ListSelectionListener {
        public CopyBeforeCurrentRightAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "copybeforecurrentright.png");
            this.putValue("SmallIcon", imageIcon);
            if (imageIcon == null) {
                this.putValue("Name", "< before");
            }
            this.putValue("ShortDescription", I18n.tr("Copy their selected elements before the first selected element in the list of merged elements"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListMerger.this.theirEntriesTable.getSelectedRows();
            int[] nArray2 = ListMerger.this.mergedEntriesTable.getSelectedRows();
            if (nArray2 == null || nArray2.length == 0) {
                return;
            }
            int n = nArray2[0];
            ListMerger.this.model.copyTheirBeforeCurrent(nArray, n);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(!ListMerger.this.theirEntriesTable.getSelectionModel().isSelectionEmpty() && !ListMerger.this.mergedEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyEndRightAction
    extends AbstractAction
    implements ListSelectionListener {
        public CopyEndRightAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "copyendright.png");
            this.putValue("SmallIcon", imageIcon);
            if (imageIcon == null) {
                this.putValue("Name", "< bottom");
            }
            this.putValue("ShortDescription", I18n.tr("Copy their selected elements to the end of the list of merged elements"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListMerger.this.theirEntriesTable.getSelectedRows();
            ListMerger.this.model.copyTheirToEnd(nArray);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(!ListMerger.this.theirEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyStartRightAction
    extends AbstractAction
    implements ListSelectionListener {
        public CopyStartRightAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "copystartright.png");
            this.putValue("SmallIcon", imageIcon);
            if (imageIcon == null) {
                this.putValue("Name", "< top");
            }
            this.putValue("ShortDescription", I18n.tr("Copy their selected element to the start of the list of merged elements"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListMerger.this.theirEntriesTable.getSelectedRows();
            ListMerger.this.model.copyTheirToTop(nArray);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(!ListMerger.this.theirEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyAfterCurrentLeftAction
    extends AbstractAction
    implements ListSelectionListener {
        public CopyAfterCurrentLeftAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "copyaftercurrentleft.png");
            this.putValue("SmallIcon", imageIcon);
            if (imageIcon == null) {
                this.putValue("Name", "> after");
            }
            this.putValue("ShortDescription", I18n.tr("Copy my selected elements after the first selected element in the list of merged elements"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListMerger.this.myEntriesTable.getSelectedRows();
            int[] nArray2 = ListMerger.this.mergedEntriesTable.getSelectedRows();
            if (nArray2 == null || nArray2.length == 0) {
                return;
            }
            int n = nArray2[0];
            ListMerger.this.model.copyMyAfterCurrent(nArray, n);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(!ListMerger.this.myEntriesTable.getSelectionModel().isSelectionEmpty() && !ListMerger.this.mergedEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyBeforeCurrentLeftAction
    extends AbstractAction
    implements ListSelectionListener {
        public CopyBeforeCurrentLeftAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "copybeforecurrentleft.png");
            this.putValue("SmallIcon", imageIcon);
            if (imageIcon == null) {
                this.putValue("Name", "> before");
            }
            this.putValue("ShortDescription", I18n.tr("Copy my selected elements before the first selected element in the list of merged elements"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListMerger.this.myEntriesTable.getSelectedRows();
            int[] nArray2 = ListMerger.this.mergedEntriesTable.getSelectedRows();
            if (nArray2 == null || nArray2.length == 0) {
                return;
            }
            int n = nArray2[0];
            ListMerger.this.model.copyMyBeforeCurrent(nArray, n);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(!ListMerger.this.myEntriesTable.getSelectionModel().isSelectionEmpty() && !ListMerger.this.mergedEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyEndLeftAction
    extends AbstractAction
    implements ListSelectionListener {
        public CopyEndLeftAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "copyendleft.png");
            this.putValue("SmallIcon", imageIcon);
            if (imageIcon == null) {
                this.putValue("Name", I18n.tr("> bottom"));
            }
            this.putValue("ShortDescription", I18n.tr("Copy my selected elements to the end of the list of merged elements"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListMerger.this.myEntriesTable.getSelectedRows();
            ListMerger.this.model.copyMyToEnd(nArray);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(!ListMerger.this.myEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyStartLeftAction
    extends AbstractAction
    implements ListSelectionListener {
        public CopyStartLeftAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "copystartleft.png");
            this.putValue("SmallIcon", imageIcon);
            if (imageIcon == null) {
                this.putValue("Name", I18n.tr("> top"));
            }
            this.putValue("ShortDescription", I18n.tr("Copy my selected nodes to the start of the merged node list"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListMerger.this.myEntriesTable.getSelectedRows();
            ListMerger.this.model.copyMyToTop(nArray);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(!ListMerger.this.myEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }
}

