/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.tags.TagMergeItem;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagConflictResolveCommand
extends Command {
    private final OsmPrimitive my;
    private final OsmPrimitive their;
    private final List<TagMergeItem> mergeItems;

    public int getNumDecidedConflicts() {
        int n = 0;
        for (TagMergeItem tagMergeItem : this.mergeItems) {
            if (tagMergeItem.getMergeDecision().equals((Object)MergeDecisionType.UNDECIDED)) continue;
            ++n;
        }
        return n;
    }

    protected String getPrimitiveTypeAsString(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Node) {
            return I18n.tr("node");
        }
        if (osmPrimitive instanceof Way) {
            return I18n.tr("way");
        }
        if (osmPrimitive instanceof Relation) {
            return I18n.tr("relation");
        }
        return "";
    }

    public TagConflictResolveCommand(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2, List<TagMergeItem> list) {
        this.my = osmPrimitive;
        this.their = osmPrimitive2;
        this.mergeItems = list;
    }

    @Override
    public MutableTreeNode description() {
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Resolve {0} tag conflicts in {1} {2}", this.getNumDecidedConflicts(), this.getPrimitiveTypeAsString(this.my), this.my.id), ImageProvider.get("data", "object"), 0));
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        for (TagMergeItem tagMergeItem : this.mergeItems) {
            if (tagMergeItem.getMergeDecision().equals((Object)MergeDecisionType.UNDECIDED)) continue;
            tagMergeItem.applyToMyPrimitive(this.my);
        }
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.my);
    }

    @Override
    public void undoCommand() {
        super.undoCommand();
        if (!Main.map.conflictDialog.conflicts.containsKey(this.my)) {
            Main.map.conflictDialog.addConflict(this.my, this.their);
        }
    }
}

