/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.AddVisitor;
import org.openstreetmap.josm.data.osm.visitor.DeleteVisitor;
import org.openstreetmap.josm.data.osm.visitor.NameVisitor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddCommand
extends Command {
    private final OsmPrimitive osm;
    private DataSet ds;

    public AddCommand(OsmPrimitive osmPrimitive) {
        this.osm = osmPrimitive;
        this.ds = Main.main.editLayer().data;
    }

    @Override
    public boolean executeCommand() {
        this.osm.visit(new AddVisitor(this.ds));
        return true;
    }

    @Override
    public void undoCommand() {
        this.osm.visit(new DeleteVisitor(this.ds));
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection3.add(this.osm);
    }

    @Override
    public boolean invalidBecauselayerRemoved(Layer layer) {
        return layer instanceof OsmDataLayer && ((OsmDataLayer)layer).data == this.ds;
    }

    @Override
    public MutableTreeNode description() {
        NameVisitor nameVisitor = new NameVisitor();
        this.osm.visit(nameVisitor);
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Add") + " " + I18n.tr(nameVisitor.className) + " " + nameVisitor.name, nameVisitor.icon, 0));
    }
}

