/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class CreateCircleAction
extends JosmAction {
    public CreateCircleAction() {
        super(I18n.tr("Create Circle"), "createcircle", I18n.tr("Create a circle from three selected nodes."), Shortcut.registerShortcut("tools:createcircle", I18n.tr("Tool: {0}", I18n.tr("Create Circle")), 79, 3, 1), true);
    }

    private double calcang(double d, double d2, double d3, double d4) {
        if (d == d3 && d2 == d4) {
            return 0.0;
        }
        double d5 = Math.abs(d4 - d2);
        if (d5 == 0.0 && d < d3) {
            return 0.0;
        }
        if (d5 == 0.0 && d > d3) {
            return Math.PI;
        }
        double d6 = Math.abs(d3 - d);
        double d7 = Math.atan2(d6, d5);
        if (d4 > d2) {
            d7 = Math.PI - d7;
        }
        if (d3 < d) {
            d7 = -d7;
        }
        if ((d7 = 4.71238898038469 + d7) < 0.0) {
            d7 += Math.PI * 2;
        }
        if (d7 >= Math.PI * 2) {
            d7 -= Math.PI * 2;
        }
        return d7;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Way way;
        Object object;
        double d;
        int n = Main.pref.getInteger("createcircle.nodecount", 8);
        if (n < 1) {
            n = 1;
        } else if (n > 100) {
            n = 100;
        }
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        Way way2 = null;
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Node)) continue;
            linkedList.add((Node)osmPrimitive);
        }
        if (linkedList.size() == 0 && collection.size() == 1) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (!(osmPrimitive instanceof Way)) continue;
                way2 = (Way)osmPrimitive;
                for (Node node : ((Way)osmPrimitive).nodes) {
                    if (linkedList.contains(node)) continue;
                    linkedList.add(node);
                }
            }
        }
        if (linkedList.size() != 3) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select exactly three nodes or one way with exactly three nodes."));
            return;
        }
        Object object2 = (Node)linkedList.toArray()[0];
        double d2 = ((Node)object2).getEastNorth().east();
        double d3 = ((Node)object2).getEastNorth().north();
        Object object3 = (Node)linkedList.toArray()[1];
        double d4 = ((Node)object3).getEastNorth().east();
        double d5 = ((Node)object3).getEastNorth().north();
        Object object4 = (Node)linkedList.toArray()[2];
        double d6 = ((Node)object4).getEastNorth().east();
        double d7 = ((Node)object4).getEastNorth().north();
        double d8 = 0.5 * ((d4 - d6) * (d2 - d6) - (d5 - d7) * (d7 - d3));
        double d9 = (d2 - d4) * (d7 - d3) - (d5 - d3) * (d2 - d6);
        if (d9 == 0.0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Those nodes are not in a circle."));
            return;
        }
        double d10 = 0.5 * (d2 + d4) + (d8 /= d9) * (d5 - d3);
        double d11 = 0.5 * (d3 + d5) + d8 * (d2 - d4);
        double d12 = Math.sqrt(Math.pow(d10 - d2, 2.0) + Math.pow(d11 - d3, 2.0));
        double d13 = this.calcang(d10, d11, d2, d3);
        double d14 = this.calcang(d10, d11, d4, d5);
        double d15 = this.calcang(d10, d11, d6, d7);
        if (d13 < d14) {
            d = d13;
            object = object2;
            d13 = d14;
            object2 = object3;
            d14 = d;
            object3 = object;
        }
        if (d14 < d15) {
            d = d14;
            object = object3;
            d14 = d15;
            object3 = object4;
            d15 = d;
            object4 = object;
        }
        if (d13 < d14) {
            d = d13;
            object = object2;
            d13 = d14;
            object2 = object3;
            d14 = d;
            object3 = object;
        }
        LinkedList<Command> linkedList2 = new LinkedList<Command>();
        if (way2 == null) {
            way = new Way();
        } else {
            way = new Way(way2);
            way.nodes.clear();
        }
        for (int i = 1; i <= n; ++i) {
            double d16 = Math.PI * 2 * (1.0 - (double)i / (double)n);
            if (d13 < 999.0 && d13 > d16) {
                way.nodes.add((Node)object2);
                d13 = 999.0;
            }
            if (d14 < 999.0 && d14 > d16) {
                way.nodes.add((Node)object3);
                d14 = 999.0;
            }
            if (d15 < 999.0 && d15 > d16) {
                way.nodes.add((Node)object4);
                d15 = 999.0;
            }
            double d17 = d10 + d12 * Math.cos(d16);
            double d18 = d11 + d12 * Math.sin(d16);
            Node node = new Node(Main.proj.eastNorth2latlon(new EastNorth(d17, d18)));
            way.nodes.add(node);
            linkedList2.add(new AddCommand(node));
        }
        way.nodes.add(way.nodes.get(0));
        if (way2 == null) {
            linkedList2.add(new AddCommand(way));
        } else {
            linkedList2.add(new ChangeCommand(way2, way));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Create Circle"), linkedList2));
        Main.map.repaint();
    }
}

