/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.MergeVisitor;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ConflictDialog;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericRelationEditor
extends RelationEditor {
    private JLabel status;
    private final DefaultTableModel propertyData = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    };
    private final DefaultTableModel memberData = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return n == 1 ? OsmPrimitive.class : String.class;
        }
    };
    private final JTable propertyTable = new JTable(this.propertyData);
    private final JTable memberTable = new JTable(this.memberData);
    protected static final String applyChangesText = I18n.tr("Apply Changes");

    public GenericRelationEditor(Relation relation, Collection<RelationMember> collection) {
        super(relation, collection);
        JPanel jPanel = this.setupBasicLayout(collection);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add((Component)jPanel, I18n.tr("Basic"));
        jTabbedPane.setPreferredSize(new Dimension(100, 100));
        this.contentConstraints = GBC.eol().fill().insets(5, 10, 5, 0);
        this.setupDialog(jTabbedPane, new String[]{"ok.png", "cancel.png"});
        this.setSize(this.findMaxDialogSize());
        try {
            this.setAlwaysOnTop(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.setVisible(true);
    }

    private JPanel setupBasicLayout(Collection<RelationMember> collection) {
        this.propertyData.setColumnIdentifiers(new String[]{I18n.tr("Key"), I18n.tr("Value")});
        this.propertyTable.setSelectionMode(0);
        this.propertyData.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 0) {
                    int n = tableModelEvent.getFirstRow();
                    if (tableModelEvent.getColumn() != 0 || n != GenericRelationEditor.this.propertyData.getRowCount() - 1) {
                        GenericRelationEditor.this.clone.entrySet().clear();
                        for (int i = 0; i < GenericRelationEditor.this.propertyData.getRowCount(); ++i) {
                            String string = GenericRelationEditor.this.propertyData.getValueAt(i, 0).toString();
                            String string2 = GenericRelationEditor.this.propertyData.getValueAt(i, 1).toString();
                            if (string.length() <= 0 || string2.length() <= 0) continue;
                            GenericRelationEditor.this.clone.put(string, string2);
                        }
                        GenericRelationEditor.this.refreshTables();
                    }
                }
            }
        });
        this.propertyTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.memberData.setColumnIdentifiers(new String[]{I18n.tr("Role"), I18n.tr("Occupied By"), I18n.tr("linked")});
        this.memberTable.setSelectionMode(2);
        this.memberTable.getColumnModel().getColumn(1).setCellRenderer(new OsmPrimitivRenderer());
        this.memberData.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 0 && tableModelEvent.getColumn() == 0) {
                    int n = tableModelEvent.getFirstRow();
                    GenericRelationEditor.this.clone.members.get((int)n).role = GenericRelationEditor.this.memberData.getValueAt(n, 0).toString();
                }
            }
        });
        ListSelectionModel listSelectionModel = this.memberTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ArrayList<OsmPrimitive> arrayList;
                int n = GenericRelationEditor.this.memberTable.getSelectedRowCount();
                if (n > 0) {
                    arrayList = new ArrayList<OsmPrimitive>(n);
                    for (int n2 : GenericRelationEditor.this.memberTable.getSelectedRows()) {
                        arrayList.add((OsmPrimitive)GenericRelationEditor.this.memberTable.getValueAt(n2, 1));
                    }
                } else {
                    n = GenericRelationEditor.this.memberTable.getRowCount();
                    arrayList = new ArrayList(n);
                    for (int i = 0; i < n; ++i) {
                        arrayList.add((OsmPrimitive)GenericRelationEditor.this.memberTable.getValueAt(i, 1));
                    }
                }
                Main.ds.setSelected(arrayList);
            }
        });
        this.memberTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Tags (empty value deletes tag)")), GBC.eol().fill(2));
        jPanel.add((Component)new JScrollPane(this.propertyTable), GBC.eop().fill(1));
        this.status = new JLabel(I18n.tr("Members"));
        jPanel.add((Component)this.status, GBC.eol().fill(2));
        JPanel jPanel2 = this.setupBasicButtons();
        jPanel.add((Component)new JScrollPane(this.memberTable), GBC.eol().fill(1));
        jPanel.add((Component)jPanel2, GBC.eop().fill(2));
        this.refreshTables();
        if (collection != null) {
            boolean bl = false;
            block0: for (int i = 0; i < this.memberData.getRowCount(); ++i) {
                for (RelationMember relationMember : collection) {
                    if (relationMember.member != this.memberData.getValueAt(i, 1) || !relationMember.role.equals(this.memberData.getValueAt(i, 0))) continue;
                    this.memberTable.addRowSelectionInterval(i, i);
                    if (bl) continue block0;
                    this.memberTable.scrollRectToVisible(this.memberTable.getCellRect(i, 0, true));
                    bl = true;
                    continue block0;
                }
            }
        }
        return jPanel;
    }

    private JPanel setupBasicButtons() {
        JPanel jPanel = new JPanel(new GridLayout(2, 3));
        jPanel.add(this.createButton(I18n.marktr("Move Up"), "moveup", I18n.tr("Move the currently selected members up"), 78, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenericRelationEditor.this.moveMembers(-1);
            }
        }));
        jPanel.add(this.createButton(I18n.marktr("Add Selected"), "addselected", I18n.tr("Add all currently selected objects as members"), 68, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenericRelationEditor.this.addSelected();
            }
        }));
        jPanel.add(this.createButton(I18n.marktr("Remove Selected"), "removeselected", I18n.tr("Remove all currently selected objects from relation"), 83, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenericRelationEditor.this.deleteSelected();
            }
        }));
        jPanel.add(this.createButton(I18n.marktr("Move Down"), "movedown", I18n.tr("Move the currently selected members down"), 74, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenericRelationEditor.this.moveMembers(1);
            }
        }));
        jPanel.add(this.createButton(I18n.marktr("Remove"), "remove", I18n.tr("Remove the member in the current table row from this relation"), 77, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = GenericRelationEditor.this.memberTable.getSelectedRows();
                RelationMember relationMember = new RelationMember();
                for (int n : nArray) {
                    relationMember.role = GenericRelationEditor.this.memberTable.getValueAt(n, 0).toString();
                    relationMember.member = (OsmPrimitive)GenericRelationEditor.this.memberTable.getValueAt(n, 1);
                    GenericRelationEditor.this.clone.members.remove(relationMember);
                }
                GenericRelationEditor.this.refreshTables();
            }
        }));
        jPanel.add(this.createButton(I18n.marktr("Download Members"), "downloadincomplete", I18n.tr("Download all incomplete ways and nodes in relation"), 75, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenericRelationEditor.this.downloadRelationMembers();
                GenericRelationEditor.this.refreshTables();
            }
        }));
        return jPanel;
    }

    private void applyChanges() {
        if (this.relation == null) {
            if (this.clone.members.size() == 0 && !this.clone.isTagged()) {
                return;
            }
            Main.main.undoRedo.add(new AddCommand(this.clone));
            DataSet.fireSelectionChanged(Main.ds.getSelected());
        } else if (!this.relation.realEqual(this.clone, true)) {
            Main.main.undoRedo.add(new ChangeCommand(this.relation, this.clone));
            DataSet.fireSelectionChanged(Main.ds.getSelected());
        }
    }

    @Override
    protected void buttonAction(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (applyChangesText.equals(string)) {
            this.applyChanges();
        }
        this.setVisible(false);
    }

    @Override
    protected Dimension findMaxDialogSize() {
        return new Dimension(600, 500);
    }

    private void refreshTables() {
        this.propertyData.setRowCount(0);
        for (Map.Entry<String, String> object : this.clone.entrySet()) {
            this.propertyData.addRow(new Object[]{object.getKey(), object.getValue()});
        }
        this.propertyData.addRow(new Object[]{"", ""});
        this.memberData.setRowCount(0);
        for (int i = 0; i < this.clone.members.size(); ++i) {
            RelationMember relationMember = this.clone.members.get(i);
            boolean bl = false;
            Node node = null;
            Node node2 = null;
            RelationMember relationMember2 = relationMember;
            while (relationMember2 != null) {
                if (relationMember2.member instanceof Way) {
                    node = ((Way)relationMember2.member).lastNode();
                    break;
                }
                if (!(relationMember.member instanceof Relation)) break;
                relationMember2 = ((Relation)relationMember2.member).lastMember();
            }
            if (i < this.clone.members.size() - 1) {
                relationMember2 = this.clone.members.get(i + 1);
                while (relationMember2 != null) {
                    if (relationMember2.member instanceof Way) {
                        node2 = ((Way)relationMember2.member).firstNode();
                        break;
                    }
                    if (!(relationMember.member instanceof Relation)) break;
                    relationMember2 = ((Relation)relationMember2.member).firstMember();
                }
            }
            bl = node != null && node.equals(node2);
            this.memberData.addRow(new Object[]{relationMember.role, relationMember.member, bl ? I18n.tr("yes") : I18n.tr("no")});
        }
        this.status.setText(I18n.tr("Members: {0}", this.clone.members.size()));
    }

    private SideButton createButton(String string, String string2, String string3, int n, ActionListener actionListener) {
        return new SideButton(string, string2, "relationEditor", string3, Shortcut.registerShortcut("relationeditor:" + string2, I18n.tr("Relation Editor: {0}", string == null ? string3 : string), n, 6), actionListener);
    }

    private void addSelected() {
        for (OsmPrimitive osmPrimitive : Main.ds.getSelected()) {
            RelationMember relationMember = new RelationMember();
            relationMember.member = osmPrimitive;
            relationMember.role = "";
            int[] nArray = this.memberTable.getSelectedRows();
            if (nArray.length > 0) {
                this.clone.members.add(nArray[0], relationMember);
                continue;
            }
            this.clone.members.add(relationMember);
        }
        this.refreshTables();
    }

    private void deleteSelected() {
        for (OsmPrimitive osmPrimitive : Main.ds.getSelected()) {
            Relation relation = new Relation(this.clone);
            for (RelationMember relationMember : relation.members) {
                if (relationMember.member != osmPrimitive) continue;
                RelationMember relationMember2 = new RelationMember();
                relationMember2.role = relationMember.role;
                relationMember2.member = relationMember.member;
                this.clone.members.remove(relationMember2);
            }
        }
        this.refreshTables();
    }

    private void moveMembers(int n) {
        int[] nArray = this.memberTable.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        if (nArray[0] + n < 0) {
            return;
        }
        if (nArray[nArray.length - 1] + n >= this.clone.members.size()) {
            return;
        }
        RelationMember[] relationMemberArray = new RelationMember[this.clone.members.size()];
        int[] nArray2 = nArray;
        int n2 = nArray2.length;
        for (int i = 0; i < n2; ++i) {
            Integer n3 = nArray2[i];
            relationMemberArray[n3.intValue() + n] = this.clone.members.get(n3);
            this.clone.members.set(n3, null);
        }
        int n4 = 0;
        for (RelationMember relationMember : this.clone.members) {
            if (relationMember == null) continue;
            while (relationMemberArray[n4] != null) {
                ++n4;
            }
            relationMemberArray[n4++] = relationMember;
        }
        this.clone.members.clear();
        this.clone.members.addAll(Arrays.asList(relationMemberArray));
        this.refreshTables();
        ListSelectionModel listSelectionModel = this.memberTable.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        int[] nArray3 = nArray;
        int n5 = nArray3.length;
        for (int i = 0; i < n5; ++i) {
            Integer n6 = nArray3[i];
            listSelectionModel.addSelectionInterval(n6 + n, n6 + n);
        }
        listSelectionModel.setValueIsAdjusting(false);
    }

    private void downloadRelationMembers() {
        boolean bl = false;
        for (RelationMember object : this.clone.members) {
            if (!object.member.incomplete) continue;
            bl = true;
            break;
        }
        if (bl) {
            OsmServerObjectReader osmServerObjectReader = new OsmServerObjectReader(this.clone.id, "relation", true);
            try {
                DataSet sAXException = osmServerObjectReader.parseOsm();
                if (sAXException != null) {
                    MergeVisitor mergeVisitor = new MergeVisitor(Main.main.editLayer().data, sAXException);
                    for (OsmPrimitive osmPrimitive : sAXException.allPrimitives()) {
                        osmPrimitive.visit(mergeVisitor);
                    }
                    mergeVisitor.fixReferences();
                    for (DataSource dataSource : sAXException.dataSources) {
                        Main.main.editLayer().data.dataSources.add(dataSource);
                    }
                    Main.main.editLayer().fireDataChange();
                    if (mergeVisitor.conflicts.isEmpty()) {
                        return;
                    }
                    ConflictDialog conflictDialog = Main.map.conflictDialog;
                    conflictDialog.add(mergeVisitor.conflicts);
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("There were conflicts during import."));
                    if (!conflictDialog.isVisible()) {
                        conflictDialog.action.actionPerformed(new ActionEvent(this, 0, ""));
                    }
                }
            }
            catch (SAXException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(this, I18n.tr("Error parsing server response.") + ": " + iOException.getMessage(), I18n.tr("Error"), 0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(this, I18n.tr("Cannot connect to server.") + ": " + iOException.getMessage(), I18n.tr("Error"), 0);
            }
        }
    }
}

