/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.DontShowAgainInfo;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class LayerListDialog
extends ToggleDialog
implements Layer.LayerChangeListener {
    static JList instance;
    private JScrollPane listScrollPane;
    DefaultListModel model = new DefaultListModel();
    private final SideButton mergeButton;
    private final SideButton upButton;
    private final SideButton downButton;
    private Action deleteAction = new DeleteLayerAction(null);

    public LayerListDialog(MapFrame mapFrame) {
        super(I18n.tr("Layers"), "layerlist", I18n.tr("Open a list of all loaded layers."), Shortcut.registerShortcut("subwindow:layers", I18n.tr("Toggle: {0}", I18n.tr("Layers")), 76, 4), 100);
        instance = new JList(this.model);
        this.listScrollPane = new JScrollPane(instance);
        this.add((Component)this.listScrollPane, "Center");
        instance.setBackground(UIManager.getColor("Button.background"));
        instance.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Layer layer = (Layer)object;
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, layer.name, n, bl, bl2);
                Icon icon = layer.getIcon();
                if (!layer.visible) {
                    icon = ImageProvider.overlay(icon, "overlay/invisible", ImageProvider.OverlayPosition.SOUTHEAST);
                }
                jLabel.setIcon(icon);
                jLabel.setToolTipText(layer.getToolTipText());
                return jLabel;
            }
        });
        final MapView mapView = mapFrame.mapView;
        Collection<Layer> collection = mapView.getAllLayers();
        for (Layer object2 : collection) {
            this.model.addElement(object2);
        }
        instance.setSelectedValue(mapView.getActiveLayer(), true);
        instance.setSelectionMode(0);
        instance.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (instance.getModel().getSize() == 0) {
                    return;
                }
                if (instance.getSelectedIndex() == -1) {
                    instance.setSelectedIndex(listSelectionEvent.getFirstIndex());
                }
                mapView.setActiveLayer((Layer)instance.getSelectedValue());
            }
        });
        Layer.listeners.add(this);
        instance.addMouseListener(new MouseAdapter(){

            private void openPopup(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = instance.locationToIndex(point);
                Layer layer = (Layer)instance.getModel().getElementAt(n);
                LayerListPopup layerListPopup = new LayerListPopup(instance, layer);
                layerListPopup.show(LayerListDialog.this.listScrollPane, point.x, point.y - 3);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.openPopup(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.openPopup(mouseEvent);
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = instance.locationToIndex(mouseEvent.getPoint());
                    Layer layer = (Layer)instance.getModel().getElementAt(n);
                    String string = Main.pref.get("marker.show " + layer.name, "show");
                    Main.pref.put("marker.show " + layer.name, string.equalsIgnoreCase("show") ? "hide" : "show");
                    layer.visible = !layer.visible;
                    Main.map.mapView.repaint();
                    instance.repaint();
                }
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 5));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Layer layer = (Layer)instance.getSelectedValue();
                int n = instance.getSelectedIndex();
                int n2 = actionEvent.getActionCommand().equals("up") ? n - 1 : n + 1;
                mapView.moveLayer(layer, n2);
                LayerListDialog.this.model.set(n, LayerListDialog.this.model.get(n2));
                LayerListDialog.this.model.set(n2, layer);
                instance.setSelectedIndex(n2);
                LayerListDialog.this.updateButtonEnabled();
                mapView.repaint();
            }
        };
        this.upButton = new SideButton("up", "LayerList", I18n.tr("Move the selected layer one row up."), actionListener);
        jPanel.add(this.upButton);
        this.downButton = new SideButton("down", "LayerList", I18n.tr("Move the selected layer one row down."), actionListener);
        jPanel.add(this.downButton);
        jPanel.add(new SideButton(new ShowHideLayerAction(null), "showhide"));
        jPanel.add(new SideButton(this.deleteAction, "delete"));
        this.mergeButton = new SideButton("mergedown", "LayerList", I18n.tr("Merge the layer directly below into the selected layer."), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Layer layer = (Layer)instance.getSelectedValue();
                Layer layer2 = (Layer)LayerListDialog.this.model.get(instance.getSelectedIndex() + 1);
                layer.mergeFrom(layer2);
                mapView.removeLayer(layer2);
                LayerListDialog.this.updateButtonEnabled();
                mapView.repaint();
            }
        });
        jPanel.add(this.mergeButton);
        this.add((Component)jPanel, "South");
        this.updateButtonEnabled();
    }

    void updateButtonEnabled() {
        int n = instance.getSelectedIndex();
        Layer layer = (Layer)instance.getSelectedValue();
        boolean bl = this.model.getSize() > 1;
        bl = bl && n < this.model.getSize() - 1;
        bl = bl && ((Layer)this.model.get(n + 1)).isMergable(layer);
        this.mergeButton.setEnabled(bl);
        this.upButton.setEnabled(n > 0);
        this.downButton.setEnabled(n >= 0 && n < this.model.getSize() - 1);
        this.deleteAction.setEnabled(!this.model.isEmpty());
        if (this.model.getSize() != 0) {
            this.setTitle(I18n.tr("Layers: {0}", this.model.getSize()), true);
        } else {
            this.setTitle(I18n.tr("Layers"), false);
        }
    }

    public void layerAdded(Layer layer) {
        int n = Main.map.mapView.getLayerPos(layer);
        this.model.add(n, layer);
        this.updateButtonEnabled();
    }

    public void layerRemoved(Layer layer) {
        this.model.removeElement(layer);
        if (this.model.isEmpty()) {
            Layer.listeners.remove(this);
            return;
        }
        if (instance.getSelectedIndex() == -1) {
            instance.setSelectedIndex(0);
        }
        this.updateButtonEnabled();
    }

    public void activeLayerChange(Layer layer, Layer layer2) {
        if (layer2 != instance.getSelectedValue()) {
            instance.setSelectedValue(layer2, true);
        }
        this.updateButtonEnabled();
    }

    public static final class ShowHideMarkerText
    extends AbstractAction {
        private final Layer layer;

        public ShowHideMarkerText(Layer layer) {
            super(I18n.tr("Show/Hide Text/Icons"), ImageProvider.get("dialogs", "showhide"));
            this.putValue("ShortDescription", I18n.tr("Toggle visible state of the marker text and icons."));
            this.putValue("help", "Action/ShowHideTextIcons");
            this.layer = layer;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Layer layer = this.layer == null ? (Layer)instance.getSelectedValue() : this.layer;
            String string = Main.pref.get("marker.show " + layer.name, "show");
            Main.pref.put("marker.show " + layer.name, string.equalsIgnoreCase("show") ? "hide" : "show");
            Main.map.mapView.repaint();
            instance.repaint();
        }
    }

    public static final class ShowHideLayerAction
    extends AbstractAction {
        private final Layer layer;

        public ShowHideLayerAction(Layer layer) {
            super(I18n.tr("Show/Hide"), ImageProvider.get("dialogs", "showhide"));
            this.putValue("ShortDescription", I18n.tr("Toggle visible state of the selected layer."));
            this.putValue("help", "Action/LayerShowHide");
            this.layer = layer;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Layer layer;
            Layer layer2 = layer = this.layer == null ? (Layer)instance.getSelectedValue() : this.layer;
            if (layer == null) {
                return;
            }
            layer.visible = !layer.visible;
            Main.map.mapView.repaint();
            instance.repaint();
        }
    }

    public static final class DeleteLayerAction
    extends AbstractAction {
        private final Layer layer;

        public DeleteLayerAction(Layer layer) {
            super(I18n.tr("Delete"), ImageProvider.get("dialogs", "delete"));
            this.putValue("ShortDescription", I18n.tr("Delete the selected layer."));
            this.putValue("help", "Action/LayerDelete");
            this.layer = layer;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Layer layer;
            int n2 = instance.getSelectedIndex();
            Layer layer2 = layer = this.layer != null ? this.layer : (Layer)instance.getSelectedValue();
            if (layer == null) {
                return;
            }
            if (layer instanceof OsmDataLayer && (((OsmDataLayer)layer).isModified() ? (n = new ExtendedDialog(Main.parent, I18n.tr("Unsaved Changes"), I18n.tr("There are unsaved changes. Delete the layer anwyay?"), new String[]{I18n.tr("Delete Layer"), I18n.tr("Cancel")}, new String[]{"dialogs/delete.png", "cancel.png"}).getValue()) != 1 : !DontShowAgainInfo.show("delete_layer", I18n.tr("Do you really want to delete the whole layer?"), false))) {
                return;
            }
            Main.main.removeLayer(layer);
            if (n2 >= instance.getModel().getSize()) {
                n2 = instance.getModel().getSize() - 1;
            }
            if (instance.getSelectedValue() == null) {
                instance.setSelectedIndex(n2);
            }
            if (Main.map != null) {
                Main.map.mapView.setActiveLayer((Layer)instance.getSelectedValue());
            }
        }
    }
}

