/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import org.openstreetmap.josm.data.coor.Coordinate;

public class EastNorth
extends Coordinate {
    public EastNorth(double d, double d2) {
        super(d, d2);
    }

    public double east() {
        return this.x;
    }

    public double north() {
        return this.y;
    }

    public EastNorth add(double d, double d2) {
        return new EastNorth(this.x + d, this.y + d2);
    }

    public EastNorth interpolate(EastNorth eastNorth, double d) {
        return new EastNorth(this.x + d * (eastNorth.x - this.x), this.y + d * (eastNorth.y - this.y));
    }

    public double heading(EastNorth eastNorth) {
        double d = Math.atan2(eastNorth.east() - this.east(), eastNorth.north() - this.north());
        if (d < 0.0) {
            d = Math.PI * 2 + d;
        }
        return d;
    }

    public EastNorth sub(EastNorth eastNorth) {
        return new EastNorth(eastNorth.east() - this.east(), eastNorth.north() - this.north());
    }

    public EastNorth rotate(EastNorth eastNorth, double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.east() - eastNorth.east();
        double d5 = this.north() - eastNorth.north();
        double d6 = d2 * d4 + d3 * d5 + eastNorth.east();
        double d7 = -d3 * d4 + d2 * d5 + eastNorth.north();
        return new EastNorth(d6, d7);
    }

    public String toString() {
        return "EastNorth[e=" + this.x + ", n=" + this.y + "]";
    }

    public boolean equalsEpsilon(EastNorth eastNorth, double d) {
        return Math.abs(this.x - eastNorth.x) < d && Math.abs(this.y - eastNorth.y) < d;
    }
}

