/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.osm.visitor.NameVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitWayAction
extends JosmAction
implements SelectionChangedListener {
    private Way selectedWay;
    private List<Node> selectedNodes;

    public SplitWayAction() {
        super(I18n.tr("Split Way"), "splitway", I18n.tr("Split a way at the selected node."), Shortcut.registerShortcut("tools:splitway", I18n.tr("Tool: {0}", I18n.tr("Split Way")), 80, 3), true);
        DataSet.selListeners.add(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        HashSet<Node> hashSet;
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        if (!this.checkSelection(collection)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The current selection cannot be used for splitting."));
            return;
        }
        this.selectedWay = null;
        this.selectedNodes = null;
        AbstractVisitor abstractVisitor = new AbstractVisitor(){

            public void visit(Node node) {
                if (SplitWayAction.this.selectedNodes == null) {
                    SplitWayAction.this.selectedNodes = new LinkedList();
                }
                SplitWayAction.this.selectedNodes.add(node);
            }

            public void visit(Way way) {
                SplitWayAction.this.selectedWay = way;
            }

            public void visit(Relation relation) {
            }
        };
        for (OsmPrimitive iterator : collection) {
            iterator.visit(abstractVisitor);
        }
        if (this.selectedWay == null && this.selectedNodes != null) {
            hashSet = new HashMap();
            for (Node node : this.selectedNodes) {
                block2: for (Way way : Main.ds.ways) {
                    int n;
                    if (way.deleted || way.incomplete || (n = way.nodes.size() - 1) <= 0) continue;
                    Boolean bl = way.nodes.get(0).equals(way.nodes.get(n));
                    int n2 = 0;
                    for (Node node2 : way.nodes) {
                        if ((bl.booleanValue() || n2 > 0 && n2 < n) && node.equals(node2)) {
                            Integer n3 = (Integer)((HashMap)((Object)hashSet)).get(way);
                            ((HashMap)((Object)hashSet)).put(way, n3 == null ? 1 : n3 + 1);
                            continue block2;
                        }
                        ++n2;
                    }
                }
            }
            if (((HashMap)((Object)hashSet)).isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.trn("The selected node is not in the middle of any way.", "The selected nodes are not in the middle of any way.", this.selectedNodes.size()));
                return;
            }
            for (Map.Entry entry : ((HashMap)((Object)hashSet)).entrySet()) {
                if (!((Integer)entry.getValue()).equals(this.selectedNodes.size())) continue;
                if (this.selectedWay != null) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.trn("There is more than one way using the node you selected. Please select the way also.", "There is more than one way using the nodes you selected. Please select the way also.", this.selectedNodes.size()));
                    return;
                }
                this.selectedWay = (Way)entry.getKey();
            }
            if (this.selectedWay == null) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The selected nodes do not share the same way."));
                return;
            }
        } else if (this.selectedWay != null && this.selectedNodes != null) {
            hashSet = new HashSet<Node>(this.selectedNodes);
            for (Node node : this.selectedWay.nodes) {
                hashSet.remove(node);
            }
            if (!hashSet.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.trn("The selected way does not contain the selected node.", "The selected way does not contain all the selected nodes.", this.selectedNodes.size()));
                return;
            }
        }
        this.splitWay();
    }

    private boolean checkSelection(Collection<? extends OsmPrimitive> collection) {
        boolean bl = false;
        boolean bl2 = false;
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive instanceof Way && !bl) {
                bl = true;
                continue;
            }
            if (osmPrimitive instanceof Node) {
                bl2 = true;
                continue;
            }
            return false;
        }
        return bl2;
    }

    private void splitWay() {
        Comparable<Boolean> comparable;
        Object object;
        HashSet<Node> hashSet = new HashSet<Node>(this.selectedNodes);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        linkedList.add(arrayList);
        Iterator<Node> iterator = this.selectedWay.nodes.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            boolean bl = arrayList.isEmpty() || !iterator.hasNext();
            arrayList.add(object);
            if (!hashSet.contains(object) || bl) continue;
            arrayList = new ArrayList();
            arrayList.add(object);
            linkedList.add(arrayList);
        }
        object = (List)linkedList.get(linkedList.size() - 1);
        if (linkedList.size() >= 2 && ((List)linkedList.get(0)).get(0) == object.get(object.size() - 1) && !hashSet.contains(((List)linkedList.get(0)).get(0))) {
            if (linkedList.size() == 2) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You must select two or more nodes to split a circular way."));
                return;
            }
            object.remove(object.size() - 1);
            object.addAll((Collection)linkedList.get(0));
            linkedList.remove(linkedList.size() - 1);
            linkedList.set(0, object);
        }
        if (linkedList.size() < 2) {
            if (((List)linkedList.get(0)).get(0) == ((List)linkedList.get(0)).get(((List)linkedList.get(0)).size() - 1)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You must select two or more nodes to split a circular way."));
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The way cannot be split at the selected nodes. (Hint: Select nodes in the middle of the way.)"));
            }
            return;
        }
        ArrayList<Command> arrayList2 = new ArrayList<Command>(linkedList.size());
        ArrayList<Comparable<Boolean>> arrayList3 = new ArrayList<Comparable<Boolean>>(linkedList.size());
        Iterator iterator2 = linkedList.iterator();
        Way way = new Way(this.selectedWay);
        way.nodes.clear();
        way.nodes.addAll((Collection)iterator2.next());
        arrayList2.add(new ChangeCommand(this.selectedWay, way));
        arrayList3.add(this.selectedWay);
        ArrayList<Comparable<Boolean>> arrayList4 = new ArrayList<Comparable<Boolean>>();
        while (iterator2.hasNext()) {
            comparable = new Way();
            if (this.selectedWay.keys != null) {
                ((Way)comparable).keys = new HashMap(this.selectedWay.keys);
            }
            arrayList4.add(comparable);
            ((Way)comparable).nodes.addAll((Collection)iterator2.next());
            arrayList2.add(new AddCommand((OsmPrimitive)comparable));
            arrayList3.add(comparable);
        }
        comparable = false;
        for (Relation relation : Main.ds.relations) {
            if (relation.deleted || relation.incomplete) continue;
            Relation relation2 = null;
            int n = 0;
            for (RelationMember relationMember : relation.members) {
                if (relationMember.member instanceof Way && relationMember.member == this.selectedWay) {
                    if (relation2 == null) {
                        relation2 = new Relation(relation);
                    }
                    for (Way way2 : arrayList4) {
                        RelationMember relationMember2 = new RelationMember();
                        relationMember2.member = way2;
                        relationMember2.role = relationMember.role;
                        if (relationMember2.role.length() > 0) {
                            comparable = true;
                        }
                        relation2.members.add(++n, relationMember2);
                    }
                }
                ++n;
            }
            if (relation2 == null) continue;
            arrayList2.add(new ChangeCommand(relation, relation2));
        }
        if (((Boolean)comparable).booleanValue()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("A role based relation membership was copied to all new ways.\nYou should verify this and correct it when necessary."));
        }
        NameVisitor nameVisitor = new NameVisitor();
        nameVisitor.visit(this.selectedWay);
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Split way {0} into {1} parts", nameVisitor.name, linkedList.size()), arrayList2));
        Main.ds.setSelected(arrayList3);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(this.checkSelection(collection));
    }
}

