/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class PasteAction
extends JosmAction {
    public PasteAction() {
        super(I18n.tr("Paste"), "paste", I18n.tr("Paste contents of paste buffer."), Shortcut.registerShortcut("system:paste", I18n.tr("Edit: {0}", I18n.tr("Paste")), 86, 2), true);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PasteAction.pasteData(Main.pasteBuffer, Main.pasteSource, actionEvent);
    }

    public static void pasteData(DataSet dataSet, Layer layer, ActionEvent actionEvent) {
        Object object;
        Object object2;
        double d = -1.0E100;
        double d2 = 1.0E100;
        double d3 = -1.0E100;
        double d4 = 1.0E100;
        for (Node node : dataSet.nodes) {
            double d5 = node.eastNorth.east();
            double d6 = node.eastNorth.north();
            if (d5 > d) {
                d = d5;
            }
            if (d5 < d2) {
                d2 = d5;
            }
            if (d6 > d3) {
                d3 = d6;
            }
            if (!(d6 < d4)) continue;
            d4 = d6;
        }
        EastNorth eastNorth = (actionEvent.getModifiers() & 2) == 0 ? Main.map.mapView.getCenter() : Main.map.mapView.getEastNorth(Main.map.mapView.lastMEvent.getX(), Main.map.mapView.lastMEvent.getY());
        double d7 = eastNorth.east() - (d + d2) / 2.0;
        double d8 = eastNorth.north() - (d3 + d4) / 2.0;
        HashMap<OsmPrimitive, Object> hashMap = new HashMap<OsmPrimitive, Object>();
        for (Node object32 : dataSet.nodes) {
            object2 = new Node(object32);
            ((Node)object2).id = 0L;
            if (Main.main.editLayer() == layer) {
                ((Node)object2).eastNorth = new EastNorth(((Node)object2).eastNorth.east() + d7, ((Node)object2).eastNorth.north() + d8);
                ((Node)object2).coor = Main.proj.eastNorth2latlon(((Node)object2).eastNorth);
            }
            hashMap.put(object32, object2);
        }
        for (Way way : dataSet.ways) {
            object2 = new Way();
            ((Way)object2).cloneFrom(way);
            ((Way)object2).id = 0L;
            object = new ArrayList();
            for (Node node : way.nodes) {
                object.add((Node)hashMap.get(node));
            }
            ((Way)object2).nodes.clear();
            ((Way)object2).nodes.addAll((Collection<Node>)object);
            hashMap.put(way, object2);
        }
        for (Relation relation : dataSet.relations) {
            object2 = new Relation(relation);
            ((Relation)object2).id = 0L;
            object = new ArrayList();
            for (RelationMember relationMember : relation.members) {
                OsmPrimitive osmPrimitive = (OsmPrimitive)hashMap.get(relationMember.member);
                if (osmPrimitive == null) continue;
                RelationMember relationMember2 = new RelationMember(relationMember);
                relationMember2.member = (OsmPrimitive)hashMap.get(relationMember.member);
                object.add(relationMember2);
            }
            ((Relation)object2).members.clear();
            ((Relation)object2).members.addAll((Collection<RelationMember>)object);
            hashMap.put(relation, object2);
        }
        Collection collection = hashMap.values();
        LinkedList<Command> linkedList = new LinkedList<Command>();
        object2 = collection.iterator();
        while (object2.hasNext()) {
            object = (OsmPrimitive)object2.next();
            linkedList.add(new AddCommand((OsmPrimitive)object));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Paste"), linkedList));
        Main.ds.setSelected(collection);
        Main.map.mapView.repaint();
    }
}

