/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.NmeaReader;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class OpenFileAction
extends DiskAccessAction {
    public OpenFileAction() {
        super(I18n.tr("Open..."), "open", I18n.tr("Open a file."), Shortcut.registerShortcut("system:open", I18n.tr("File: {0}", I18n.tr("Open...")), 79, 2));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = OpenFileAction.createAndOpenFileChooser(true, true, null);
        if (jFileChooser == null) {
            return;
        }
        File[] fileArray = jFileChooser.getSelectedFiles();
        for (int i = fileArray.length; i > 0; --i) {
            this.openFile(fileArray[i - 1]);
        }
    }

    public void openFile(File file) {
        try {
            System.out.println("Open file: " + file.getAbsolutePath() + " (" + file.length() + " bytes)");
            if (this.asGpxData(file.getName())) {
                this.openFileAsGpx(file);
            } else if (this.asNmeaData(file.getName())) {
                this.openFileAsNmea(file);
            } else {
                this.openAsData(file);
            }
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error while parsing {0}", file.getName()) + ": " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not read \"{0}\"", file.getName()) + "\n" + iOException.getMessage());
        }
    }

    private void openAsData(File file) throws SAXException, IOException, FileNotFoundException {
        String string = file.getName();
        if (ExtensionFileFilter.filters[0].acceptName(string)) {
            OsmReader osmReader = OsmReader.parseDataSetOsm(new FileInputStream(file), null, Main.pleaseWaitDlg);
            DataSet dataSet = osmReader.getDs();
            OsmDataLayer osmDataLayer = new OsmDataLayer(dataSet, file.getName(), file);
            Main.main.addLayer(osmDataLayer);
            osmDataLayer.fireDataChange();
            if (osmReader.getParseNotes().length() != 0) {
                String string2 = osmReader.getParseNotes();
                int n = 0;
                for (int i = 0; i < 5; ++i) {
                    n = string2.indexOf(10, n + 1);
                }
                n = n >= 0 ? n : string2.length();
                JOptionPane.showMessageDialog(Main.parent, string2.substring(0, n));
            }
        } else {
            JOptionPane.showMessageDialog(Main.parent, string + ": " + I18n.tr("Unknown file extension: {0}", string.substring(file.getName().lastIndexOf(46) + 1)));
        }
    }

    private void openFileAsGpx(File file) throws SAXException, IOException, FileNotFoundException {
        String string = file.getName();
        if (ExtensionFileFilter.filters[1].acceptName(string)) {
            GpxReader gpxReader = null;
            InputStream inputStream = file.getName().endsWith(".gpx.gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
            if (inputStream.read() != 239 || inputStream.read() != 187 || inputStream.read() != 191) {
                inputStream.close();
                inputStream = file.getName().endsWith(".gpx.gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
            }
            gpxReader = new GpxReader(inputStream, file.getAbsoluteFile().getParentFile());
            gpxReader.data.storageFile = file;
            GpxLayer gpxLayer = new GpxLayer(gpxReader.data, string, true);
            Main.main.addLayer(gpxLayer);
            if (Main.pref.getBoolean("marker.makeautomarkers", true)) {
                MarkerLayer markerLayer = new MarkerLayer(gpxReader.data, I18n.tr("Markers from {0}", string), file, gpxLayer);
                if (markerLayer.data.size() > 0) {
                    Main.main.addLayer(markerLayer);
                }
            }
        } else {
            throw new IllegalStateException();
        }
    }

    private void showNmeaInfobox(boolean bl, NmeaReader nmeaReader) {
        String string = I18n.tr("Coordinates imported: ") + nmeaReader.getNumberOfCoordinates() + "\n" + I18n.tr("Malformed sentences: ") + nmeaReader.getParserMalformed() + "\n" + I18n.tr("Checksum errors: ") + nmeaReader.getParserChecksumErrors() + "\n";
        if (!bl) {
            string = string + I18n.tr("Unknown sentences: ") + nmeaReader.getParserUnknown() + "\n";
        }
        string = string + I18n.tr("Zero coordinates: ") + nmeaReader.getParserZeroCoordinates();
        if (bl) {
            JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("NMEA import success"), 1);
        } else {
            JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("NMEA import faliure!"), 0);
        }
    }

    private void openFileAsNmea(File file) throws IOException, FileNotFoundException {
        NmeaReader nmeaReader;
        String string = file.getName();
        if (ExtensionFileFilter.filters[2].acceptName(string)) {
            nmeaReader = new NmeaReader(new FileInputStream(file), file.getAbsoluteFile().getParentFile());
            if (nmeaReader.getNumberOfCoordinates() > 0) {
                nmeaReader.data.storageFile = file;
                GpxLayer gpxLayer = new GpxLayer(nmeaReader.data, string, true);
                Main.main.addLayer(gpxLayer);
                if (Main.pref.getBoolean("marker.makeautomarkers", true)) {
                    MarkerLayer markerLayer = new MarkerLayer(nmeaReader.data, I18n.tr("Markers from {0}", string), file, gpxLayer);
                    if (markerLayer.data.size() > 0) {
                        Main.main.addLayer(markerLayer);
                    }
                }
            }
        } else {
            throw new IllegalStateException();
        }
        this.showNmeaInfobox(nmeaReader.getNumberOfCoordinates() > 0, nmeaReader);
    }

    private boolean asGpxData(String string) {
        return ExtensionFileFilter.filters[1].acceptName(string);
    }

    private boolean asNmeaData(String string) {
        return ExtensionFileFilter.filters[2].acceptName(string);
    }
}

