/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.PluginDescription;
import org.openstreetmap.josm.plugins.PluginDownloader;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.XmlObjectParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginSelection {
    private Map<String, Boolean> pluginMap;
    private Map<String, PluginDescription> availablePlugins;

    public void updateDescription(JPanel jPanel) {
        int n = PluginDownloader.downloadDescription();
        if (n > 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.trn("Downloaded plugin information from {0} site", "Downloaded plugin information from {0} sites", n, n));
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No plugin information found."));
        }
        this.drawPanel(jPanel);
    }

    public void update(JPanel jPanel) {
        int n = PluginDownloader.downloadDescription();
        Boolean bl = false;
        this.drawPanel(jPanel);
        HashSet<PluginDescription> hashSet = new HashSet<PluginDescription>();
        StringBuilder stringBuilder = new StringBuilder();
        for (PluginProxy pluginProxy : PluginHandler.pluginList) {
            PluginDescription pluginDescription = this.availablePlugins.get(pluginProxy.info.name);
            if (!(pluginDescription != null && (pluginDescription.version == null || pluginDescription.version.equals("")) ? pluginProxy.info.version != null && pluginProxy.info.version.equals("") : !pluginDescription.version.equals(pluginProxy.info.version))) continue;
            hashSet.add(pluginDescription);
            stringBuilder.append(pluginDescription.name + "\n");
        }
        if (hashSet.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("All installed plugins are up to date."));
            bl = true;
        } else {
            int n2 = new ExtendedDialog(Main.parent, I18n.tr("Update"), I18n.tr("Update the following plugins:\n\n{0}", stringBuilder.toString()), new String[]{I18n.tr("Update Plugins"), I18n.tr("Cancel")}, new String[]{"dialogs/refresh.png", "cancel.png"}).getValue();
            if (n2 == 1) {
                PluginDownloader.update(hashSet);
                bl = true;
            }
        }
        if (bl.booleanValue() && n >= 1) {
            Main.pref.put("pluginmanager.lastupdate", Long.toString(System.currentTimeMillis()));
        }
        this.drawPanel(jPanel);
    }

    public Boolean finish() {
        LinkedList<PluginDescription> linkedList = new LinkedList<PluginDescription>();
        String string = "";
        for (Map.Entry<String, Boolean> object : this.pluginMap.entrySet()) {
            if (!object.getValue().booleanValue() || PluginInformation.findPlugin(object.getKey()) != null) continue;
            linkedList.add(this.availablePlugins.get(object.getKey()));
            string = string + object.getKey() + "\n";
        }
        if (!linkedList.isEmpty()) {
            int n = new ExtendedDialog(Main.parent, I18n.tr("Download missing plugins"), I18n.tr("Download the following plugins?\n\n{0}", string), new String[]{I18n.tr("Download Plugins"), I18n.tr("Cancel")}, new String[]{"download.png", "cancel.png"}).getValue();
            if (n != 1) {
                for (PluginDescription pluginDescription : linkedList) {
                    this.pluginMap.put(pluginDescription.name, false);
                }
            } else {
                for (PluginDescription pluginDescription : linkedList) {
                    if (PluginDownloader.downloadPlugin(pluginDescription)) continue;
                    this.pluginMap.put(pluginDescription.name, false);
                }
            }
        }
        LinkedList linkedList2 = new LinkedList();
        for (Map.Entry<String, Boolean> entry : this.pluginMap.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            linkedList2.add(entry.getKey());
        }
        Collections.sort(linkedList2);
        return Main.pref.putCollection("plugins", linkedList2);
    }

    public void drawPanel(JPanel jPanel) {
        this.availablePlugins = this.getAvailablePlugins();
        Collection<String> collection = Main.pref.getCollection("plugins", null);
        if (this.pluginMap == null) {
            this.pluginMap = new HashMap<String, Boolean>();
        } else {
            for (String string : this.pluginMap.keySet()) {
                if (this.availablePlugins.get(string) != null) continue;
                this.pluginMap.remove(string);
            }
        }
        jPanel.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        int n = 0;
        for (final PluginDescription pluginDescription : this.availablePlugins.values()) {
            String string;
            PluginInformation pluginInformation;
            String string2;
            boolean bl;
            boolean bl2 = bl = collection != null && collection.contains(pluginDescription.name);
            if (this.pluginMap.get(pluginDescription.name) == null) {
                this.pluginMap.put(pluginDescription.name, bl);
            }
            if ((string2 = pluginDescription.version) == null || string2.equals("")) {
                string2 = I18n.tr("unknown");
            }
            if ((pluginInformation = PluginInformation.findPlugin(pluginDescription.name)) != null) {
                string = pluginInformation.version != null && !pluginInformation.version.equals("") ? pluginInformation.version : I18n.tr("unknown");
                string = " (" + string + ")";
            } else {
                string = "";
            }
            final JCheckBox jCheckBox = new JCheckBox(I18n.tr("{0}: Version {1}{2}", pluginDescription.name, string2, string), (boolean)this.pluginMap.get(pluginDescription.name));
            gridBagConstraints.gridy = n++;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.fill = 0;
            jPanel.add((Component)jCheckBox, gridBagConstraints);
            jCheckBox.setToolTipText(pluginDescription.resource != null ? "" + pluginDescription.resource : I18n.tr("Plugin bundled with JOSM"));
            JEditorPane jEditorPane = new JEditorPane();
            jEditorPane.setContentType("text/html");
            jEditorPane.setEditable(false);
            jEditorPane.setText("<html><i>" + (pluginDescription.description == null ? I18n.tr("no description available") : pluginDescription.description) + "</i></html>");
            jEditorPane.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            jEditorPane.setBackground(UIManager.getColor("Panel.background"));
            jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        OpenBrowser.displayUrl(hyperlinkEvent.getURL().toString());
                    }
                }
            });
            gridBagConstraints.gridy = n++;
            gridBagConstraints.insets = new Insets(3, 5, 5, 5);
            gridBagConstraints.weighty = 0.9;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)jEditorPane, gridBagConstraints);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jCheckBox.isSelected()) {
                        PluginInformation pluginInformation = PluginInformation.findPlugin(pluginDescription.name);
                        if (PluginSelection.getLoaded(pluginDescription.name) == null && pluginInformation != null) {
                            try {
                                int n = new ExtendedDialog(Main.parent, I18n.tr("Plugin already exists"), I18n.tr("Plugin archive already available. Do you want to download the current version by deleting existing archive?\n\n{0}", pluginInformation.file.getCanonicalPath()), new String[]{I18n.tr("Delete and Download"), I18n.tr("Cancel")}, new String[]{"download.png", "cancel.png"}).getValue();
                                if (n == 1 && !pluginInformation.file.delete()) {
                                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error deleting plugin file: {0}", pluginInformation.file.getCanonicalPath()));
                                }
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error deleting plugin file: {0}", iOException.getMessage()));
                            }
                        }
                    }
                    PluginSelection.this.pluginMap.put(pluginDescription.name, jCheckBox.isSelected());
                }
            });
        }
        jPanel.updateUI();
    }

    private static PluginInformation getLoaded(String string) {
        for (PluginProxy pluginProxy : PluginHandler.pluginList) {
            if (!pluginProxy.info.name.equals(string)) continue;
            return pluginProxy.info;
        }
        return null;
    }

    private Map<String, PluginDescription> getAvailablePlugins() {
        TreeMap<String, PluginDescription> treeMap = new TreeMap<String, PluginDescription>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareToIgnoreCase(string2);
            }
        });
        for (String object : PluginInformation.getPluginLocations()) {
            Object[] objectArray = new File(object).listFiles();
            if (objectArray == null) continue;
            Arrays.sort(objectArray);
            for (Object object2 : objectArray) {
                Object exception;
                if (!((File)object2).isFile()) continue;
                if (((File)object2).getName().endsWith(".jar")) {
                    try {
                        exception = new PluginInformation((File)object2);
                        if (treeMap.containsKey(((PluginInformation)exception).name)) continue;
                        treeMap.put(((PluginInformation)exception).name, new PluginDescription(((PluginInformation)exception).name, ((PluginInformation)exception).description, PluginInformation.fileToURL((File)object2).toString(), ((PluginInformation)exception).version));
                    }
                    catch (PluginException pluginException) {}
                    continue;
                }
                if (!((File)object2).getName().matches("^[0-9]+-site.*\\.xml$")) continue;
                try {
                    exception = new XmlObjectParser.Uniform<PluginDescription>(new FileReader((File)object2), "plugin", PluginDescription.class);
                    Iterator iterator = ((XmlObjectParser.Uniform)exception).iterator();
                    while (iterator.hasNext()) {
                        PluginDescription pluginDescription = (PluginDescription)iterator.next();
                        if (treeMap.containsKey(pluginDescription.name)) continue;
                        treeMap.put(pluginDescription.name, pluginDescription);
                    }
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error reading plugin information file: {0}", ((File)object2).getName()));
                }
            }
        }
        for (PluginProxy pluginProxy : PluginHandler.pluginList) {
            if (treeMap.containsKey(pluginProxy.info.name)) continue;
            treeMap.put(pluginProxy.info.name, new PluginDescription(pluginProxy.info.name, pluginProxy.info.description, pluginProxy.info.file == null ? null : PluginInformation.fileToURL(pluginProxy.info.file).toString(), pluginProxy.info.version));
        }
        return treeMap;
    }
}

