/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.zip.CRC32;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.HelpAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.projection.Projection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatableComponent
extends JComponent
implements HelpAction.Helpful {
    public static final EastNorth world = Main.proj.latlon2eastNorth(new LatLon(85.05112877980659, 180.0));
    public static final int snapDistance = NavigatableComponent.sqr(Main.pref.getInteger("node.snap-distance", 10));
    protected double scale;
    protected EastNorth center = new EastNorth(0.0, 0.0);

    private static int sqr(int n) {
        return n * n;
    }

    public NavigatableComponent() {
        this.setLayout(null);
    }

    protected DataSet getData() {
        return Main.ds;
    }

    public int zoom() {
        double d = this.scale * (double)this.getWidth();
        double d2 = this.scale * (double)this.getHeight();
        int n = 0;
        while (n <= 32) {
            if (d > world.east() || d2 > world.north()) {
                return n;
            }
            ++n;
            d *= 2.0;
            d2 *= 2.0;
        }
        return 32;
    }

    public Integer getViewID() {
        String string = this.center.east() + "_" + this.center.north() + "_" + this.scale + "_" + this.getWidth() + "_" + this.getHeight();
        CRC32 cRC32 = new CRC32();
        cRC32.update(string.getBytes());
        return new Long(cRC32.getValue()).intValue();
    }

    public double getScale() {
        return this.scale;
    }

    public EastNorth getCenter() {
        return this.center;
    }

    public EastNorth getEastNorth(int n, int n2) {
        return new EastNorth(this.center.east() + ((double)n - (double)this.getWidth() / 2.0) * this.scale, this.center.north() - ((double)n2 - (double)this.getHeight() / 2.0) * this.scale);
    }

    public LatLon getLatLon(int n, int n2) {
        return this.getProjection().eastNorth2latlon(this.getEastNorth(n, n2));
    }

    public Point getPoint(EastNorth eastNorth) {
        if (null == eastNorth) {
            return new Point();
        }
        double d = (eastNorth.east() - this.center.east()) / this.scale + (double)(this.getWidth() / 2);
        double d2 = (this.center.north() - eastNorth.north()) / this.scale + (double)(this.getHeight() / 2);
        return new Point((int)d, (int)d2);
    }

    public void zoomTo(EastNorth eastNorth, double d) {
        this.center = eastNorth;
        this.getProjection().eastNorth2latlon(this.center);
        this.scale = d;
        this.repaint();
    }

    public final Node getNearestNode(Point point) {
        double d = snapDistance;
        Node node = null;
        for (Node node2 : this.getData().nodes) {
            if (node2.deleted || node2.incomplete) continue;
            Point point2 = this.getPoint(node2.eastNorth);
            double d2 = point.distanceSq(point2);
            if (d2 < d) {
                d = d2;
                node = node2;
                continue;
            }
            if (d2 != d || node == null || (node2.id != 0L || !node2.selected) && (node.selected || !node2.selected && node2.id != 0L)) continue;
            node = node2;
        }
        return node;
    }

    public final List<WaySegment> getNearestWaySegments(Point point) {
        TreeMap treeMap = new TreeMap();
        for (Way object : this.getData().ways) {
            if (object.deleted || object.incomplete) continue;
            Object object2 = null;
            int n = -2;
            for (Node node : object.nodes) {
                double d;
                ++n;
                if (node.deleted || node.incomplete) continue;
                if (object2 == null) {
                    object2 = node;
                    continue;
                }
                Point point2 = this.getPoint(((Node)object2).eastNorth);
                Point point3 = this.getPoint(node.eastNorth);
                double d2 = point2.distanceSq(point3);
                double d3 = point.distanceSq(point3);
                double d4 = d3 - (d3 - (d = point.distanceSq(point2)) + d2) * (d3 - d + d2) / 4.0 / d2;
                if (d4 < (double)snapDistance && d3 < d2 + (double)snapDistance && d < d2 + (double)snapDistance) {
                    List<WaySegment> list;
                    if (object.selected) {
                        d4 -= 1.0E-5;
                    }
                    if (treeMap.containsKey(d4)) {
                        list = (List)treeMap.get(d4);
                    } else {
                        list = new LinkedList();
                        treeMap.put(d4, list);
                    }
                    list.add(new WaySegment(object, n));
                }
                object2 = node;
            }
        }
        ArrayList arrayList = new ArrayList();
        for (Object object2 : treeMap.values()) {
            arrayList.addAll(object2);
        }
        return arrayList;
    }

    public final WaySegment getNearestWaySegment(Point point, Collection<WaySegment> collection) {
        List<WaySegment> list = this.getNearestWaySegments(point);
        if (collection != null) {
            list.removeAll(collection);
        }
        return list.isEmpty() ? null : list.get(0);
    }

    public final WaySegment getNearestWaySegment(Point point) {
        return this.getNearestWaySegment(point, null);
    }

    public final Way getNearestWay(Point point) {
        WaySegment waySegment = this.getNearestWaySegment(point);
        return waySegment == null ? null : waySegment.way;
    }

    public OsmPrimitive getNearest(Point point) {
        OsmPrimitive osmPrimitive = this.getNearestNode(point);
        if (osmPrimitive == null) {
            osmPrimitive = this.getNearestWay(point);
        }
        return osmPrimitive;
    }

    public Collection<OsmPrimitive> getNearestCollection(Point point) {
        OsmPrimitive osmPrimitive = this.getNearest(point);
        if (osmPrimitive == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(osmPrimitive);
    }

    public Collection<OsmPrimitive> getAllNearest(Point point) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        block0: for (Way osmPrimitive : this.getData().ways) {
            if (osmPrimitive.deleted || osmPrimitive.incomplete) continue;
            Node node = null;
            for (Node node2 : osmPrimitive.nodes) {
                double d;
                if (node2.deleted || node2.incomplete) continue;
                if (node == null) {
                    node = node2;
                    continue;
                }
                Point point2 = this.getPoint(node.eastNorth);
                Point point3 = this.getPoint(node2.eastNorth);
                double d2 = point2.distanceSq(point3);
                double d3 = point.distanceSq(point3);
                double d4 = d3 - (d3 - (d = point.distanceSq(point2)) + d2) * (d3 - d + d2) / 4.0 / d2;
                if (d4 < (double)snapDistance && d3 < d2 + (double)snapDistance && d < d2 + (double)snapDistance) {
                    hashSet.add(osmPrimitive);
                    continue block0;
                }
                node = node2;
            }
        }
        for (Node node : this.getData().nodes) {
            if (node.deleted || node.incomplete || !(this.getPoint(node.eastNorth).distanceSq(point) < (double)snapDistance)) continue;
            hashSet.add(node);
        }
        return hashSet.isEmpty() ? null : hashSet;
    }

    public Collection<Node> getNearestNodes(Point point) {
        HashSet<Node> hashSet = new HashSet<Node>();
        for (Node node : this.getData().nodes) {
            if (node.deleted || node.incomplete || !(this.getPoint(node.eastNorth).distanceSq(point) < (double)snapDistance)) continue;
            hashSet.add(node);
        }
        return hashSet.isEmpty() ? null : hashSet;
    }

    public final Collection<Node> getNearestNodes(Point point, Collection<Node> collection) {
        Collection<Node> collection2 = this.getNearestNodes(point);
        if (collection2 == null) {
            return null;
        }
        if (collection != null) {
            collection2.removeAll(collection);
        }
        return collection2.isEmpty() ? null : collection2;
    }

    protected Projection getProjection() {
        return Main.proj;
    }

    @Override
    public String helpTopic() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }
}

