/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapMover;
import org.openstreetmap.josm.gui.MapScaler;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.SelectionManager;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.tools.I18n;

public class WorldChooser
extends NavigatableComponent
implements DownloadSelection {
    private ImageIcon world;
    private double scaleMax;
    private EastNorth markerMin;
    private EastNorth markerMax;
    private Projection projection;

    public WorldChooser() {
        URL uRL = Main.class.getResource("/images/world.jpg");
        this.world = new ImageIcon(uRL);
        this.center = new EastNorth(this.world.getIconWidth() / 2, this.world.getIconHeight() / 2);
        this.setPreferredSize(new Dimension(400, 200));
        this.projection = new Projection(){

            public EastNorth latlon2eastNorth(LatLon latLon) {
                return new EastNorth((latLon.lon() + 180.0) / 360.0 * (double)WorldChooser.this.world.getIconWidth(), (latLon.lat() + 90.0) / 180.0 * (double)WorldChooser.this.world.getIconHeight());
            }

            public LatLon eastNorth2latlon(EastNorth eastNorth) {
                return new LatLon(eastNorth.north() * 180.0 / (double)WorldChooser.this.world.getIconHeight() - 90.0, eastNorth.east() * 360.0 / (double)WorldChooser.this.world.getIconWidth() - 180.0);
            }

            public String toString() {
                return "WorldChooser";
            }

            public String toCode() {
                return null;
            }

            public String getCacheDirectoryName() {
                throw new UnsupportedOperationException();
            }

            public double scaleFactor() {
                return 1.0 / (double)WorldChooser.this.world.getIconWidth();
            }
        };
        MapScaler mapScaler = new MapScaler(this, this.projection);
        this.add(mapScaler);
        mapScaler.setLocation(10, 10);
        this.setMinimumSize(new Dimension(350, 175));
    }

    public void addGui(final DownloadDialog downloadDialog) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this, "Center");
        jPanel.add((Component)new JLabel(I18n.tr("You can use the mouse or Ctrl+Arrow keys/./ to zoom and pan.")), "South");
        downloadDialog.tabpane.add((Component)jPanel, I18n.tr("Map"));
        new MapMover(this, jPanel);
        SelectionManager.SelectionEnded selectionEnded = new SelectionManager.SelectionEnded(){

            public void selectionEnded(Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
                WorldChooser.this.markerMin = WorldChooser.this.getEastNorth(rectangle.x, rectangle.y + rectangle.height);
                WorldChooser.this.markerMax = WorldChooser.this.getEastNorth(rectangle.x + rectangle.width, rectangle.y);
                LatLon latLon = WorldChooser.this.getProjection().eastNorth2latlon(WorldChooser.this.markerMin);
                LatLon latLon2 = WorldChooser.this.getProjection().eastNorth2latlon(WorldChooser.this.markerMax);
                downloadDialog.minlat = latLon.lat();
                downloadDialog.minlon = latLon.lon();
                downloadDialog.maxlat = latLon2.lat();
                downloadDialog.maxlon = latLon2.lon();
                downloadDialog.boundingBoxChanged(WorldChooser.this);
                WorldChooser.this.repaint();
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }
        };
        SelectionManager selectionManager = new SelectionManager(selectionEnded, false, this);
        selectionManager.register(this);
    }

    public void boundingBoxChanged(DownloadDialog downloadDialog) {
        this.markerMin = this.getProjection().latlon2eastNorth(new LatLon(downloadDialog.minlat, downloadDialog.minlon));
        this.markerMax = this.getProjection().latlon2eastNorth(new LatLon(downloadDialog.maxlat, downloadDialog.maxlon));
        this.repaint();
    }

    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this.scaleMax = this.scale = (double)this.world.getIconWidth() / dimension.getWidth();
    }

    public void paint(Graphics graphics) {
        EastNorth eastNorth = this.getEastNorth(0, 0);
        EastNorth eastNorth2 = this.getEastNorth(this.getWidth(), this.getHeight());
        graphics.drawImage(this.world.getImage(), 0, 0, this.getWidth(), this.getHeight(), (int)eastNorth.east(), (int)eastNorth.north(), (int)eastNorth2.east(), (int)eastNorth2.north(), null);
        if (this.markerMin != null && this.markerMax != null) {
            Point point = this.getPoint(this.markerMin);
            Point point2 = this.getPoint(this.markerMax);
            double d = Math.min(point.x, point2.x);
            double d2 = Math.min(point.y, point2.y);
            double d3 = (double)Math.max(point.x, point2.x) - d;
            double d4 = (double)Math.max(point.y, point2.y) - d2;
            if (d3 < 1.0) {
                d3 = 1.0;
            }
            if (d4 < 1.0) {
                d4 = 1.0;
            }
            graphics.setColor(Color.YELLOW);
            graphics.drawRect((int)d, (int)d2, (int)d3, (int)d4);
        }
        super.paint(graphics);
    }

    public void zoomTo(EastNorth eastNorth, double d) {
        if (this.getWidth() != 0 && d > this.scaleMax) {
            d = this.scaleMax;
            eastNorth = this.center;
        }
        super.zoomTo(eastNorth, d);
    }

    protected Projection getProjection() {
        return this.projection;
    }
}

