/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.io.PushbackReader;
import java.io.StringReader;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openstreetmap.josm.actions.search.PushbackTokenizer;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;

public class SearchCompiler {
    private boolean caseSensitive = false;
    private boolean regexSearch = false;
    private String rxErrorMsg = I18n.marktr("The regex \"{0}\" had a parse error at offset {1}, full error:\n\n{2}");
    private PushbackTokenizer tokenizer;

    public SearchCompiler(boolean bl, boolean bl2, PushbackTokenizer pushbackTokenizer) {
        this.caseSensitive = bl;
        this.regexSearch = bl2;
        this.tokenizer = pushbackTokenizer;
    }

    public static Match compile(String string, boolean bl, boolean bl2) throws ParseError {
        return new SearchCompiler(bl, bl2, new PushbackTokenizer(new PushbackReader(new StringReader(string)))).parse();
    }

    public Match parse() throws ParseError {
        Match match = this.parseJuxta();
        if (!this.tokenizer.readIfEqual(null)) {
            throw new ParseError("Unexpected token: " + this.tokenizer.nextToken());
        }
        return match;
    }

    private Match parseJuxta() throws ParseError {
        Match match;
        Match match2 = new Always();
        while ((match = this.parseOr()) != null) {
            match2 = new And(match, match2);
        }
        return match2;
    }

    private Match parseOr() throws ParseError {
        Match match = this.parseNot();
        if (this.tokenizer.readIfEqual("|")) {
            Match match2 = this.parseNot();
            if (match == null || match2 == null) {
                throw new ParseError(I18n.tr("Missing arguments for or."));
            }
            return new Or(match, match2);
        }
        return match;
    }

    private Match parseNot() throws ParseError {
        if (this.tokenizer.readIfEqual("-")) {
            Match match = this.parseParens();
            if (match == null) {
                throw new ParseError(I18n.tr("Missing argument for not."));
            }
            return new Not(match);
        }
        return this.parseParens();
    }

    private Match parseParens() throws ParseError {
        if (this.tokenizer.readIfEqual("(")) {
            Match match = this.parseJuxta();
            if (!this.tokenizer.readIfEqual(")")) {
                throw new ParseError(I18n.tr("Expected closing parenthesis."));
            }
            return match;
        }
        return this.parsePat();
    }

    private Match parsePat() {
        String string = this.tokenizer.readText();
        if (this.tokenizer.readIfEqual(":")) {
            String string2 = this.tokenizer.readText();
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            return this.parseKV(string, string2);
        }
        if (string == null) {
            return null;
        }
        if (string.equals("modified")) {
            return new Modified();
        }
        if (string.equals("incomplete")) {
            return new Incomplete();
        }
        if (string.equals("untagged")) {
            return new Untagged();
        }
        if (string.equals("selected")) {
            return new Selected();
        }
        return new Any(string);
    }

    private Match parseKV(String string, String string2) {
        if (string.equals("type")) {
            return new ExactType(string2);
        }
        if (string.equals("user")) {
            return new UserMatch(string2);
        }
        if (string.equals("nodes")) {
            try {
                return new NodeCount(Integer.parseInt(string2));
            }
            catch (Exception exception) {
                try {
                    String[] stringArray = string2.split("-", 2);
                    return new NodeCountRange(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
                }
                catch (Exception exception2) {
                    return new NodeCount(0);
                }
            }
        }
        if (string.equals("id")) {
            try {
                return new Id(Long.parseLong(string2));
            }
            catch (NumberFormatException numberFormatException) {
                return new Id(0L);
            }
        }
        return new KeyValue(string, string2);
    }

    public static class ParseError
    extends Exception {
        public ParseError(String string) {
            super(string);
        }
    }

    private static class Untagged
    extends Match {
        private Untagged() {
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return !osmPrimitive.isTagged();
        }

        public String toString() {
            return "untagged";
        }
    }

    private static class Incomplete
    extends Match {
        private Incomplete() {
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive.incomplete;
        }

        public String toString() {
            return "incomplete";
        }
    }

    private static class Selected
    extends Match {
        private Selected() {
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive.selected;
        }

        public String toString() {
            return "selected";
        }
    }

    private static class Modified
    extends Match {
        private Modified() {
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive.modified || osmPrimitive.id == 0L;
        }

        public String toString() {
            return "modified";
        }
    }

    private static class NodeCountRange
    extends Match {
        private int minCount;
        private int maxCount;

        public NodeCountRange(int n, int n2) {
            if (n2 < n) {
                this.minCount = n2;
                this.maxCount = n;
            } else {
                this.minCount = n;
                this.maxCount = n2;
            }
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            if (!(osmPrimitive instanceof Way)) {
                return false;
            }
            int n = ((Way)osmPrimitive).nodes.size();
            return n >= this.minCount && n <= this.maxCount;
        }

        public String toString() {
            return "nodes=" + this.minCount + "-" + this.maxCount;
        }
    }

    private static class NodeCount
    extends Match {
        private int count;

        public NodeCount(int n) {
            this.count = n;
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive instanceof Way && ((Way)osmPrimitive).nodes.size() == this.count;
        }

        public String toString() {
            return "nodes=" + this.count;
        }
    }

    private static class UserMatch
    extends Match {
        private User user;

        public UserMatch(String string) {
            this.user = User.get(string);
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive.user == this.user;
        }

        public String toString() {
            return "user=" + this.user.name;
        }
    }

    private static class ExactType
    extends Match {
        private String type;

        public ExactType(String string) {
            this.type = string;
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            if (osmPrimitive instanceof Node) {
                return this.type.equals("node");
            }
            if (osmPrimitive instanceof Way) {
                return this.type.equals("way");
            }
            if (osmPrimitive instanceof Relation) {
                return this.type.equals("relation");
            }
            throw new IllegalStateException("unknown class " + osmPrimitive.getClass());
        }

        public String toString() {
            return "type=" + this.type;
        }
    }

    private class Any
    extends Match {
        private String s;

        public Any(String string) {
            this.s = string;
        }

        public boolean match(OsmPrimitive osmPrimitive) throws ParseError {
            String string;
            if (osmPrimitive.keys == null) {
                return this.s.equals("");
            }
            Pattern pattern = null;
            if (SearchCompiler.this.regexSearch) {
                string = this.s;
                if (SearchCompiler.this.caseSensitive) {
                    try {
                        pattern = Pattern.compile(string);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw new ParseError(I18n.tr(SearchCompiler.this.rxErrorMsg, patternSyntaxException.getPattern(), patternSyntaxException.getIndex(), patternSyntaxException.getMessage()));
                    }
                } else {
                    try {
                        pattern = Pattern.compile(string, 2);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw new ParseError(I18n.tr(SearchCompiler.this.rxErrorMsg, patternSyntaxException.getPattern(), patternSyntaxException.getIndex(), patternSyntaxException.getMessage()));
                    }
                }
            } else {
                string = SearchCompiler.this.caseSensitive ? this.s : this.s.toLowerCase();
            }
            for (Map.Entry<String, String> entry : osmPrimitive.keys.entrySet()) {
                String string2;
                String string3;
                if (SearchCompiler.this.regexSearch) {
                    string3 = entry.getKey();
                    string2 = entry.getValue();
                    Matcher matcher = pattern.matcher(string3);
                    Matcher matcher2 = pattern.matcher(string2);
                    boolean bl = matcher.find();
                    boolean bl2 = matcher2.find();
                    if (!bl && !bl2) continue;
                    return true;
                }
                string3 = SearchCompiler.this.caseSensitive ? entry.getKey() : entry.getKey().toLowerCase();
                String string4 = string2 = SearchCompiler.this.caseSensitive ? entry.getValue() : entry.getValue().toLowerCase();
                if (string3.indexOf(string) == -1 && string2.indexOf(string) == -1) continue;
                return true;
            }
            if (osmPrimitive.user != null) {
                Object object = osmPrimitive.user.name;
                if (!SearchCompiler.this.caseSensitive) {
                    object = ((String)object).toLowerCase();
                }
                if (((String)object).indexOf(string) != -1) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.s;
        }
    }

    private class KeyValue
    extends Match {
        private String key;
        private String value;

        public KeyValue(String string, String string2) {
            this.key = string;
            this.value = string2;
        }

        public boolean match(OsmPrimitive osmPrimitive) throws ParseError {
            if (SearchCompiler.this.regexSearch) {
                if (osmPrimitive.keys == null) {
                    return false;
                }
                Pattern pattern = null;
                Pattern pattern2 = null;
                if (SearchCompiler.this.caseSensitive) {
                    try {
                        pattern = Pattern.compile(this.key);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw new ParseError(I18n.tr(SearchCompiler.this.rxErrorMsg, patternSyntaxException.getPattern(), patternSyntaxException.getIndex(), patternSyntaxException.getMessage()));
                    }
                    try {
                        pattern2 = Pattern.compile(this.value);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw new ParseError(I18n.tr(SearchCompiler.this.rxErrorMsg, patternSyntaxException.getPattern(), patternSyntaxException.getIndex(), patternSyntaxException.getMessage()));
                    }
                }
                try {
                    pattern = Pattern.compile(this.key, 2);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ParseError(I18n.tr(SearchCompiler.this.rxErrorMsg, patternSyntaxException.getPattern(), patternSyntaxException.getIndex(), patternSyntaxException.getMessage()));
                }
                try {
                    pattern2 = Pattern.compile(this.value, 2);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ParseError(I18n.tr(SearchCompiler.this.rxErrorMsg, patternSyntaxException.getPattern(), patternSyntaxException.getIndex(), patternSyntaxException.getMessage()));
                }
                for (Map.Entry<String, String> entry : osmPrimitive.keys.entrySet()) {
                    Matcher matcher;
                    boolean bl;
                    String string = entry.getKey();
                    String string2 = entry.getValue();
                    Matcher matcher2 = pattern.matcher(string);
                    boolean bl2 = matcher2.find();
                    if (!bl2 || !(bl = (matcher = pattern2.matcher(string2)).find())) continue;
                    return true;
                }
            } else {
                String string = null;
                string = this.key.equals("timestamp") ? DateUtils.fromDate(osmPrimitive.getTimestamp()) : osmPrimitive.get(this.key);
                if (string == null) {
                    return false;
                }
                String string3 = SearchCompiler.this.caseSensitive ? string : string.toLowerCase();
                String string4 = SearchCompiler.this.caseSensitive ? this.value : this.value.toLowerCase();
                return string3.indexOf(string4) != -1;
            }
            return false;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private static class Id
    extends Match {
        private long id;

        public Id(long l) {
            this.id = l;
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive.id == this.id;
        }

        public String toString() {
            return "id=" + this.id;
        }
    }

    private static class Or
    extends Match {
        private Match lhs;
        private Match rhs;

        public Or(Match match, Match match2) {
            this.lhs = match;
            this.rhs = match2;
        }

        public boolean match(OsmPrimitive osmPrimitive) throws ParseError {
            return this.lhs.match(osmPrimitive) || this.rhs.match(osmPrimitive);
        }

        public String toString() {
            return this.lhs + " || " + this.rhs;
        }
    }

    private static class And
    extends Match {
        private Match lhs;
        private Match rhs;

        public And(Match match, Match match2) {
            this.lhs = match;
            this.rhs = match2;
        }

        public boolean match(OsmPrimitive osmPrimitive) throws ParseError {
            return this.lhs.match(osmPrimitive) && this.rhs.match(osmPrimitive);
        }

        public String toString() {
            return this.lhs + " && " + this.rhs;
        }
    }

    private static class Not
    extends Match {
        private final Match match;

        public Not(Match match) {
            this.match = match;
        }

        public boolean match(OsmPrimitive osmPrimitive) throws ParseError {
            return !this.match.match(osmPrimitive);
        }

        public String toString() {
            return "!" + this.match;
        }
    }

    private static class Always
    extends Match {
        private Always() {
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return true;
        }
    }

    public static abstract class Match {
        public abstract boolean match(OsmPrimitive var1) throws ParseError;
    }
}

