/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.io.OsmWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateOsmChangeVisitor
implements Visitor {
    StringBuffer document;
    String currentMode;
    Changeset changeset;
    PrintWriter writer;
    StringWriter swriter = new StringWriter();
    OsmWriter osmwriter;

    public CreateOsmChangeVisitor(Changeset changeset) {
        this.writer = new PrintWriter(this.swriter);
        this.writer.write("<osmChange version=\"");
        this.writer.write(Main.pref.get("osm-server.version", "0.6"));
        this.writer.write("\" generator=\"JOSM\">\n");
        this.changeset = changeset;
        this.osmwriter = new OsmWriter(this.writer, false, changeset);
    }

    @Override
    public void visit(Node node) {
        if (node.deleted) {
            this.switchMode("delete");
            this.writer.write("<node id=\"");
            this.writer.write(Long.toString(node.id));
            this.writer.write("\" version=\"");
            this.writer.write(Long.toString(node.version));
            this.writer.write("\" changeset=\"");
            this.writer.write(Long.toString(this.changeset.id));
            this.writer.write("\" />\n");
        } else {
            this.switchMode(node.id == 0L ? "create" : "modify");
            node.visit(this.osmwriter);
        }
    }

    @Override
    public void visit(Way way) {
        if (way.deleted) {
            this.switchMode("delete");
            this.writer.write("<way id=\"");
            this.writer.write(Long.toString(way.id));
            this.writer.write("\" version=\"");
            this.writer.write(Long.toString(way.version));
            this.writer.write("\" changeset=\"");
            this.writer.write(Long.toString(this.changeset.id));
            this.writer.write("\" />\n");
        } else {
            this.switchMode(way.id == 0L ? "create" : "modify");
            way.visit(this.osmwriter);
        }
    }

    @Override
    public void visit(Relation relation) {
        if (relation.deleted) {
            this.switchMode("delete");
            this.writer.write("<relation id=\"");
            this.writer.write(Long.toString(relation.id));
            this.writer.write("\" version=\"");
            this.writer.write(Long.toString(relation.version));
            this.writer.write("\" changeset=\"");
            this.writer.write(Long.toString(this.changeset.id));
            this.writer.write("\" />\n");
        } else {
            this.switchMode(relation.id == 0L ? "create" : "modify");
            relation.visit(this.osmwriter);
        }
    }

    private void switchMode(String string) {
        if (string != null && !string.equals(this.currentMode) || string == null && this.currentMode != null) {
            if (this.currentMode != null) {
                this.writer.write("</");
                this.writer.write(this.currentMode);
                this.writer.write(">\n");
            }
            if (string != null) {
                this.writer.write("<");
                this.writer.write(string);
                this.writer.write(" version=\"");
                this.writer.write(Main.pref.get("osm-server.version", "0.6"));
                this.writer.write("\" generator=\"JOSM\">\n");
            }
            this.currentMode = string;
        }
    }

    public String getDocument() {
        this.switchMode(null);
        return this.swriter.toString() + "</osmChange>\n";
    }

    public Map<OsmPrimitive, Long> getNewIdMap() {
        return this.osmwriter.usedNewIds;
    }
}

