/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Formatting {
    private static final String STRING_ABBREV = "...";
    private static final DecimalFormat PC_FORMAT = new DecimalFormat("#,###.#%");
    private static final NumberFormat PC_WIDTH_FORMAT = NumberFormat.getInstance(Locale.US);
    private static final DecimalFormat D1_FORMAT;
    private static final DecimalFormat D2_FORMAT;
    private static final DecimalFormat D3_FORMAT;
    private static final DecimalFormat INT_FORMAT;
    private static final DateFormat DATE_FORMAT;
    private static final DateFormat SHORT_DATE_FORMAT;

    private Formatting() {
    }

    public static synchronized String getPercentStr(float aPc) {
        return aPc < 0.0f ? " - " : PC_FORMAT.format(aPc);
    }

    public static synchronized String getPcWidth(float aPc) {
        return PC_WIDTH_FORMAT.format(aPc) + "%";
    }

    public static synchronized String format1d(float val) {
        return D1_FORMAT.format(val);
    }

    public static synchronized String formatFloat(float val) {
        if (val < 0.0f) {
            return "-";
        }
        return D2_FORMAT.format(val);
    }

    public static synchronized String format3d(float val) {
        if (val < 0.0f) {
            return "-";
        }
        return D3_FORMAT.format(val);
    }

    public static synchronized String formatInt(int aVal) {
        return INT_FORMAT.format(aVal);
    }

    public static synchronized String formatDate(Date aDate) {
        return DATE_FORMAT.format(aDate);
    }

    public static synchronized String formatShortDate(Date aDate) {
        return SHORT_DATE_FORMAT.format(aDate);
    }

    public static String restrictLength(String str, int maxlength, boolean prefix) {
        if (str == null) {
            return "";
        }
        int abbrevlength = STRING_ABBREV.length();
        int strlength = str.length();
        if (maxlength < 0 || strlength <= maxlength || strlength <= abbrevlength) {
            return str;
        }
        if (prefix) {
            return STRING_ABBREV + str.substring(strlength - maxlength + abbrevlength);
        }
        return str.substring(0, maxlength - abbrevlength) + STRING_ABBREV;
    }

    public static String pluralizedVal(int value, String word) {
        return value + " " + Formatting.pluralizedWord(value, word);
    }

    public static String pluralizedWord(int value, String word) {
        return word + (value != 1 ? (word.endsWith("s") ? "es" : "s") : "");
    }

    public static NumberFormat getPcFormat() {
        DecimalFormat format = new DecimalFormat("###%");
        format.setMultiplier(1);
        return format;
    }

    static {
        PC_WIDTH_FORMAT.setMaximumFractionDigits(1);
        D1_FORMAT = new DecimalFormat("#,###.#");
        D2_FORMAT = new DecimalFormat("#,###.##");
        D3_FORMAT = new DecimalFormat("#,###.###");
        INT_FORMAT = new DecimalFormat("#,###");
        DATE_FORMAT = new SimpleDateFormat("EEE MMM d yyyy HH:mm:ss z");
        SHORT_DATE_FORMAT = new SimpleDateFormat("d MMM HH:mm:ss");
    }
}

