/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.tasks;

import com.cenqua.clover.Logger;
import com.cenqua.clover.tasks.AbstractInstrTask;
import com.cenqua.clover.tasks.AntInstrumentationConfig;
import com.cenqua.clover.util.ClassPathUtil;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.CloverCompilerAdapter;
import org.apache.tools.ant.types.PatternSet;

public class CloverSetupTask
extends AbstractInstrTask {
    public static final String BUILD_COMPILER = "build.compiler";
    private PatternSet instrPattern;

    public void setEnabled(boolean enabled) {
        this.config.setEnabled(enabled);
    }

    public void setCloverCompiler(String cloverCompiler) {
        this.config.setCompilerDelegate(cloverCompiler);
    }

    public void setPreserve(boolean preserve) {
        this.config.setPreserve(preserve);
    }

    public void addFiles(PatternSet filesPattern) {
        this.instrPattern = filesPattern;
    }

    public void cloverExecute() {
        String cloverJarPath;
        try {
            AntInstrumentationConfig existingCfg = (AntInstrumentationConfig)this.getProject().getReference("clover.config");
            if (existingCfg != null) {
                Logger.getInstance().debug("Existing Clover configuration found with initstring \"" + existingCfg.getInitString() + "\". Overriding.");
            }
        }
        catch (ClassCastException e) {
            Logger.getInstance().warn("Clover error: Unknown type for reference clover.config: ", e);
        }
        String existingBuildCompiler = this.getProject().getProperty(BUILD_COMPILER);
        if ("org.apache.tools.ant.taskdefs.CloverCompilerAdapter".equals(existingBuildCompiler)) {
            String cmpDelegate = this.config.getCompilerDelegate();
            this.getProject().setProperty(BUILD_COMPILER, cmpDelegate == null ? CloverCompilerAdapter.getDefaultAntCompiler() : cmpDelegate);
        }
        this.getProject().addReference("clover.config", (Object)this.config);
        if (!this.config.isEnabled()) {
            this.getProject().log("Clover is disabled.");
            return;
        }
        String runtimeInitString = this.getRuntimeInitString();
        Logger.getInstance().info("Clover is enabled with initstring '" + runtimeInitString + "'");
        String buildCompiler = this.getProject().getProperty(BUILD_COMPILER);
        if (buildCompiler != null && !buildCompiler.equals("org.apache.tools.ant.taskdefs.CloverCompilerAdapter") && this.config.getCompilerDelegate() == null) {
            this.config.setCompilerDelegate(buildCompiler);
        }
        this.getProject().setProperty(BUILD_COMPILER, "org.apache.tools.ant.taskdefs.CloverCompilerAdapter");
        this.getProject().setProperty("clover.initstring", runtimeInitString);
        if (this.config.getCompilerDelegate() != null && this.config.getCompilerDelegate().equals("org.apache.tools.ant.taskdefs.CloverCompilerAdapter")) {
            throw new BuildException("You cannot set clovercompiler to be the Clover compiler adapter. Check the value you are passing to clovercompiler, or the value of the build.compiler Ant property");
        }
        if (this.instrPattern != null) {
            this.getProject().addReference("clover.files", (Object)this.instrPattern);
        }
        if (this.instrFilesets != null) {
            this.getProject().addReference("clover.filesets", (Object)this.instrFilesets);
        }
        if (this.testSources != null) {
            this.getProject().addReference("clover.testfilesets", (Object)this.testSources);
        }
        if ((cloverJarPath = ClassPathUtil.getCloverJarPath()) != null) {
            this.getProject().setProperty("clover.jarpath", cloverJarPath);
        }
    }
}

