/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.tasks;

import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.CoverageDataSpec;
import com.cenqua.clover.PerTestCoverageStrategy;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.console.ConsoleReporter;
import com.cenqua.clover.tasks.AbstractCloverTask;
import com.cenqua.clover.tasks.AntPath;
import com.cenqua.clover.tasks.FilesetFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class CloverLogTask
extends AbstractCloverTask {
    private String outputProperty;
    private List filesets = new ArrayList();
    private String filterSpec;
    private Level level;
    private List packages = new ArrayList();
    private Interval span = Interval.DEFAULT_SPAN;
    private Path sourcepath;

    public void setOutputProperty(String outputProperty) {
        this.outputProperty = outputProperty;
    }

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void setSpan(Interval span) {
        this.span = span;
    }

    public void setFilter(String filterSpec) {
        this.filterSpec = filterSpec;
    }

    public void addPackage(Package packageInfo) {
        this.packages.add(packageInfo);
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void addSourcepath(Path path) {
        if (this.sourcepath == null) {
            this.sourcepath = path;
        } else {
            this.sourcepath.append(path);
        }
    }

    public void cloverExecute() {
        CloverDatabase db;
        String initString = this.resolveInitString();
        ConsoleReporter.Config config = new ConsoleReporter.Config();
        config.setInitString(initString);
        if (this.level != null) {
            config.setLevel(this.level.getValue());
        } else {
            config.setLevel("summary");
        }
        if (!config.validate()) {
            throw new BuildException("configuration is not valid");
        }
        if (this.packages.size() != 0) {
            HashSet<String> packageSet = new HashSet<String>();
            Iterator i = this.packages.iterator();
            while (i.hasNext()) {
                Package packageInfo = (Package)i.next();
                packageSet.add(packageInfo.packageName);
            }
            config.setPackageSet(packageSet);
        }
        ConsoleReporter reporter = new ConsoleReporter(config);
        try {
            HasMetricsFilter filter = this.filesets.size() != 0 ? new FilesetFilter(this.getProject(), this.filesets) : HasMetricsFilter.NO_OP;
            db = new CloverDatabase(initString, filter, this.getProject().getName(), this.filterSpec);
            db.loadCoverageData(new CoverageDataSpec(new Current.DefaultTestFilter(), this.span.getValueInMillis(), false, true, false, false, PerTestCoverageStrategy.IN_MEMORY));
            if (this.sourcepath != null) {
                db.resolve(new AntPath(this.sourcepath));
            }
        }
        catch (CloverException e) {
            throw new BuildException((Throwable)e);
        }
        try {
            Writer out;
            if (this.outputProperty != null) {
                out = new StringWriter();
                reporter.report(new PrintWriter(out), db);
                this.getProject().setProperty(this.outputProperty, out.toString());
            } else {
                out = new OutputStreamWriter((OutputStream)new LogOutputStream((Task)this, 2));
                reporter.report(new PrintWriter(out), db);
                out.flush();
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public static class Package {
        private String packageName;

        public void setName(String packageName) {
            this.packageName = packageName;
        }
    }

    public static class Level
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"summary", "package", "class", "method", "statement"};

        public String[] getValues() {
            return VALUES;
        }
    }
}

