/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.cfg;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StorageSize {
    static Pattern SIZE_REGEX = Pattern.compile("(0|([1-9][0-9]*))([bkmg])?", 2);
    static Map MULTIPLIERS = new HashMap();
    public static final StorageSize ZERO = new StorageSize(0L);
    private long sizeInBytes;

    public StorageSize(long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public static StorageSize fromString(String s) {
        block5: {
            Matcher m = SIZE_REGEX.matcher(s);
            if (m.matches()) {
                try {
                    long value = Long.parseLong(m.group(1));
                    String unit = m.group(3);
                    if (unit != null) {
                        Long mult = (Long)MULTIPLIERS.get(unit.toLowerCase());
                        if (mult != null) {
                            return new StorageSize(value * mult);
                        }
                        break block5;
                    }
                    return new StorageSize(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        throw new IllegalArgumentException("Couldn't parse size string \"" + s + "\"");
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    static {
        MULTIPLIERS.put("b", new Long(1L));
        MULTIPLIERS.put("k", new Long(1000L));
        MULTIPLIERS.put("m", new Long(1000000L));
        MULTIPLIERS.put("g", new Long(1000000000L));
    }
}

