/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.Arrays;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongList;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongListIterator;
import clover.it.unimi.dsi.fastutil.longs.LongArrays;
import clover.it.unimi.dsi.fastutil.longs.LongCollection;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import clover.it.unimi.dsi.fastutil.longs.LongIterators;
import clover.it.unimi.dsi.fastutil.longs.LongList;
import clover.it.unimi.dsi.fastutil.longs.LongListIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class LongArrayList
extends AbstractLongList
implements RandomAccess,
Cloneable,
Serializable {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected static final long ONEOVERPHI = 106039L;
    protected transient long[] a;
    protected int size;
    public static final long serialVersionUID = -7046029254386353130L;
    private static final boolean ASSERTS = false;

    protected LongArrayList(long[] a, boolean dummy) {
        this.a = a;
    }

    public LongArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = new long[capacity];
    }

    public LongArrayList() {
        this(16);
    }

    public LongArrayList(Collection c) {
        this(c.size());
        this.size = LongIterators.unwrap(LongIterators.asLongIterator(c.iterator()), this.a);
    }

    public LongArrayList(LongCollection c) {
        this(c.size());
        this.size = LongIterators.unwrap(c.longIterator(), this.a);
    }

    public LongArrayList(LongList l) {
        this(l.size());
        this.size = l.size();
        l.getElements(0, this.a, 0, this.size);
    }

    public LongArrayList(long[] a) {
        this(a, 0, a.length);
    }

    public LongArrayList(long[] a, int offset, int length) {
        this(length);
        System.arraycopy(a, offset, this.a, 0, length);
        this.size = length;
    }

    public LongArrayList(Iterator i) {
        this(LongIterators.asLongIterator(i));
    }

    public LongArrayList(LongIterator i) {
        this();
        while (i.hasNext()) {
            this.add(i.nextLong());
        }
    }

    public long[] elements() {
        return this.a;
    }

    public static LongArrayList wrap(long[] a, int length) {
        if (length > a.length) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + a.length + ")");
        }
        LongArrayList l = new LongArrayList(a, false);
        l.size = length;
        return l;
    }

    public static LongArrayList wrap(long[] a) {
        return LongArrayList.wrap(a, a.length);
    }

    public void ensureCapacity(int capacity) {
        this.a = LongArrays.ensureCapacity(this.a, capacity, this.size);
    }

    public void add(int index, long k) {
        this.ensureIndex(index);
        this.a = LongArrays.grow(this.a, this.size + 1, this.size);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + 1, this.size - index);
        }
        this.a[index] = k;
        ++this.size;
    }

    public boolean add(long k) {
        this.a = LongArrays.grow(this.a, this.size + 1, this.size);
        this.a[this.size++] = k;
        return true;
    }

    public boolean addAll(int index, LongCollection c) {
        this.ensureIndex(index);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        this.a = LongArrays.grow(this.a, this.size + n, this.size);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + n, this.size - index);
        }
        LongIterator i = c.longIterator();
        this.size += n;
        while (n-- != 0) {
            this.a[index++] = i.nextLong();
        }
        return true;
    }

    public boolean addAll(int index, LongList l) {
        this.ensureIndex(index);
        int n = l.size();
        if (n == 0) {
            return false;
        }
        this.a = LongArrays.grow(this.a, this.size + n, this.size);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + n, this.size - index);
        }
        l.getElements(0, this.a, index, n);
        this.size += n;
        return true;
    }

    public boolean addAll(LongList l) {
        return this.addAll(this.size, l);
    }

    public long getLong(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[index];
    }

    public int indexOf(long k) {
        for (int i = 0; i < this.size; ++i) {
            if (k != this.a[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long k) {
        int i = this.size;
        while (i-- != 0) {
            if (k != this.a[i]) continue;
            return i;
        }
        return -1;
    }

    public long removeLong(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        long old = this.a[index];
        --this.size;
        if (index != this.size) {
            System.arraycopy(this.a, index + 1, this.a, index, this.size - index);
        }
        return old;
    }

    public boolean rem(long k) {
        int index = this.indexOf(k);
        if (index == -1) {
            return false;
        }
        this.removeLong(index);
        return true;
    }

    public long set(int index, long k) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        long old = this.a[index];
        this.a[index] = k;
        return old;
    }

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public void size(int size) {
        if (size > this.a.length) {
            this.ensureCapacity(size);
        }
        if (size > this.size) {
            for (int i = this.size; i < size; ++i) {
                this.a[i] = 0L;
            }
        }
        this.size = size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void trim() {
        this.trim(0);
    }

    public void trim(int n) {
        if (n >= this.a.length || this.size == this.a.length) {
            return;
        }
        long[] t = new long[Math.max(n, this.size)];
        System.arraycopy(this.a, 0, t, 0, this.size);
        this.a = t;
    }

    public void getElements(int from, long[] a, int offset, int length) {
        LongArrays.ensureOffsetLength(a, offset, length);
        System.arraycopy(this.a, from, a, offset, length);
    }

    public void removeElements(int from, int to) {
        Arrays.ensureFromTo(this.size, from, to);
        System.arraycopy(this.a, to, this.a, from, this.size - to);
        this.size -= to - from;
    }

    public void addElements(int index, long[] a, int offset, int length) {
        this.ensureIndex(index);
        LongArrays.ensureOffsetLength(a, offset, length);
        this.a = LongArrays.grow(this.a, this.size + length, this.size);
        System.arraycopy(this.a, index, this.a, index + length, this.size - index);
        System.arraycopy(a, offset, this.a, index, length);
        this.size += length;
    }

    public long[] toLongArray(long[] a) {
        if (a == null || a.length < this.size) {
            a = new long[this.size];
        }
        System.arraycopy(this.a, 0, a, 0, this.size);
        return a;
    }

    public LongListIterator longListIterator(final int index) {
        this.ensureIndex(index);
        return new AbstractLongListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            public boolean hasNext() {
                return this.pos < LongArrayList.this.size;
            }

            public boolean hasPrevious() {
                return this.pos > 0;
            }

            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return LongArrayList.this.a[this.last];
            }

            public long previousLong() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return LongArrayList.this.a[this.pos];
            }

            public int nextIndex() {
                return this.pos;
            }

            public int previousIndex() {
                return this.pos - 1;
            }

            public void add(long k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                LongArrayList.this.add(this.pos++, k);
                this.last = -1;
            }

            public void set(long k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                LongArrayList.this.set(this.last, k);
            }

            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                LongArrayList.this.removeLong(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    public Object clone() {
        LongArrayList c = new LongArrayList(this.size);
        System.arraycopy(this.a, 0, c.a, 0, this.size);
        c.size = this.size;
        return c;
    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean equals(LongArrayList l) {
        if (l == this) {
            return true;
        }
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        long[] a1 = this.a;
        long[] a2 = l.a;
        while (s-- != 0) {
            if (a1[s] == a2[s]) continue;
            return false;
        }
        return true;
    }

    public int compareTo(LongArrayList l) {
        int i2;
        int s1 = this.size();
        int s2 = l.size();
        long[] a1 = this.a;
        long[] a2 = l.a;
        int i1 = 0;
        for (i2 = 0; i1 < s1 && i2 < s2; ++i1, ++i2) {
            int r;
            if ((a1[i1] < a2[i2] ? -1 : (r = a1[i1] == a2[i2] ? 0 : 1)) == 0) continue;
            return r;
        }
        return i2 < s2 ? -1 : (i1 < s1 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            s.writeLong(this.a[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.a = new long[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.a[i] = s.readLong();
        }
    }
}

