/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.ints;

import clover.it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import clover.it.unimi.dsi.fastutil.ints.AbstractIntListIterator;
import clover.it.unimi.dsi.fastutil.ints.IntCollection;
import clover.it.unimi.dsi.fastutil.ints.IntIterator;
import clover.it.unimi.dsi.fastutil.ints.IntList;
import clover.it.unimi.dsi.fastutil.ints.IntListIterator;
import clover.it.unimi.dsi.fastutil.ints.IntStack;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractIntList
extends AbstractIntCollection
implements IntList,
IntStack {
    private static final boolean ASSERTS = false;

    protected AbstractIntList() {
    }

    protected void ensureIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    public void add(int index, int k) {
        throw new UnsupportedOperationException();
    }

    public boolean add(int k) {
        this.add(this.size(), k);
        return true;
    }

    public boolean rem(int k) {
        int index = this.indexOf(k);
        if (index == -1) {
            return false;
        }
        this.removeInt(index);
        return true;
    }

    public int removeInt(int i) {
        throw new UnsupportedOperationException();
    }

    public int set(int index, int k) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        this.ensureIndex(index);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        Iterator i = c.iterator();
        while (n-- != 0) {
            this.add(index++, i.next());
        }
        return true;
    }

    public boolean addAll(int index, IntCollection c) {
        return this.addAll(index, (Collection)c);
    }

    public boolean addAll(int index, IntList l) {
        return this.addAll(index, (IntCollection)l);
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(IntCollection c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(IntList l) {
        return this.addAll(this.size(), l);
    }

    public ListIterator listIterator() {
        return this.intListIterator();
    }

    public ListIterator listIterator(int index) {
        return this.intListIterator(index);
    }

    public IntIterator intIterator() {
        return this.intListIterator();
    }

    public IntListIterator intListIterator() {
        return this.intListIterator(0);
    }

    public IntListIterator intListIterator(final int index) {
        return new AbstractIntListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            public boolean hasNext() {
                return this.pos < AbstractIntList.this.size();
            }

            public boolean hasPrevious() {
                return this.pos > 0;
            }

            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractIntList.this.getInt(this.last);
            }

            public int previousInt() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractIntList.this.getInt(this.pos);
            }

            public int nextIndex() {
                return this.pos;
            }

            public int previousIndex() {
                return this.pos - 1;
            }

            public void add(int k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractIntList.this.add(this.pos++, k);
                this.last = -1;
            }

            public void set(int k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractIntList.this.set(this.last, k);
            }

            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractIntList.this.removeInt(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    public boolean contains(int k) {
        return this.indexOf(k) >= 0;
    }

    public int indexOf(int k) {
        IntListIterator i = this.intListIterator();
        while (i.hasNext()) {
            int e = i.nextInt();
            if (k != e) continue;
            return i.previousIndex();
        }
        return -1;
    }

    public int lastIndexOf(int k) {
        IntListIterator i = this.intListIterator(this.size());
        while (i.hasPrevious()) {
            int e = i.previousInt();
            if (k != e) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public void size(int size) {
        int i = this.size();
        if (size > i) {
            while (i++ < size) {
                this.add(0);
            }
        } else {
            while (i-- != size) {
                this.remove(i);
            }
        }
    }

    public IntList intSubList(int from, int to) {
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new IntSubList(this, from, to);
    }

    public List subList(int from, int to) {
        return this.intSubList(from, to);
    }

    public void removeElements(int from, int to) {
        this.ensureIndex(to);
        IntListIterator i = this.intListIterator(from);
        int n = to - from;
        if (n < 0) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        while (n-- != 0) {
            i.nextInt();
            i.remove();
        }
    }

    public void addElements(int index, int[] a, int offset, int length) {
        this.ensureIndex(index);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        while (length-- != 0) {
            this.add(index++, a[offset++]);
        }
    }

    public void addElements(int index, int[] a) {
        this.addElements(index, a, 0, a.length);
    }

    public void getElements(int from, int[] a, int offset, int length) {
        IntListIterator i = this.intListIterator(from);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        if (from + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (from + length) + ") is greater than list size (" + this.size() + ")");
        }
        while (length-- != 0) {
            a[offset++] = i.nextInt();
        }
    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        ListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (s-- != 0) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (o instanceof IntList) {
            IntList l = (IntList)o;
            IntListIterator i1 = this.intListIterator();
            IntListIterator i2 = l.intListIterator();
            while (i1.hasNext() && i2.hasNext()) {
                int r;
                int e2;
                int e1 = i1.nextInt();
                if ((e1 < (e2 = i2.nextInt()) ? -1 : (r = e1 == e2 ? 0 : 1)) == 0) continue;
                return r;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        List l = (List)o;
        ListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r = ((Comparable)i1.next()).compareTo(i2.next());
            if (r == 0) continue;
            return r;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    public int hashCode() {
        IntIterator i = this.intIterator();
        int h = 1;
        int s = this.size();
        while (s-- != 0) {
            int k = i.nextInt();
            h = 31 * h + k;
        }
        return h;
    }

    public void push(int o) {
        this.add(o);
    }

    public int popInt() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeInt(this.size() - 1);
    }

    public int topInt() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getInt(this.size() - 1);
    }

    public int peekInt(int i) {
        return this.getInt(this.size() - 1 - i);
    }

    public void add(int index, Object ok) {
        this.add(index, (Integer)ok);
    }

    public Object set(int index, Object ok) {
        return new Integer(this.set(index, (Integer)ok));
    }

    public Object get(int index) {
        return new Integer(this.getInt(index));
    }

    public int indexOf(Object ok) {
        return this.indexOf((Integer)ok);
    }

    public int lastIndexOf(Object ok) {
        return this.lastIndexOf((Integer)ok);
    }

    public Object remove(int index) {
        return new Integer(this.removeInt(index));
    }

    public void push(Object o) {
        this.push((Integer)o);
    }

    public Object pop() {
        return new Integer(this.popInt());
    }

    public Object top() {
        return new Integer(this.topInt());
    }

    public Object peek(int i) {
        return new Integer(this.peekInt(i));
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        IntIterator i = this.intIterator();
        int n = this.size();
        boolean first = true;
        s.append("[");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            int k = i.nextInt();
            s.append(String.valueOf(k));
        }
        s.append("]");
        return s.toString();
    }

    public static class IntSubList
    extends AbstractIntList
    implements Serializable {
        protected final IntList l;
        protected final int from;
        protected int to;
        private static final boolean ASSERTS = false;

        public IntSubList(IntList l, int from, int to) {
            this.l = l;
            this.from = from;
            this.to = to;
        }

        private void assertRange() {
        }

        public boolean add(int k) {
            this.l.add(this.to, k);
            ++this.to;
            return true;
        }

        public void add(int index, int k) {
            this.ensureIndex(index);
            this.l.add(this.from + index, k);
            ++this.to;
        }

        public boolean addAll(int index, Collection c) {
            this.ensureIndex(index);
            this.to += c.size();
            return this.l.addAll(this.from + index, c);
        }

        public boolean addAll(int index, IntCollection c) {
            this.ensureIndex(index);
            this.to += c.size();
            return this.l.addAll(this.from + index, c);
        }

        public boolean addAll(int index, IntList l) {
            this.ensureIndex(index);
            this.to += l.size();
            return this.l.addAll(this.from + index, l);
        }

        public int getInt(int index) {
            this.ensureRestrictedIndex(index);
            return this.l.getInt(this.from + index);
        }

        public int removeInt(int index) {
            this.ensureRestrictedIndex(index);
            --this.to;
            return this.l.removeInt(this.from + index);
        }

        public boolean rem(int k) {
            int index = this.indexOf(k);
            if (index == -1) {
                return false;
            }
            --this.to;
            this.l.removeInt(this.from + index);
            return true;
        }

        public int set(int index, int k) {
            this.ensureRestrictedIndex(index);
            return this.l.set(this.from + index, k);
        }

        public void clear() {
            this.removeElements(0, this.size());
        }

        public int size() {
            return this.to - this.from;
        }

        public void getElements(int from, int[] a, int offset, int length) {
            this.ensureIndex(from);
            if (from + length > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + from + length + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + from, a, offset, length);
        }

        public void removeElements(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            this.l.removeElements(this.from + from, this.from + to);
            this.to -= to - from;
        }

        public void addElements(int index, int[] a, int offset, int length) {
            this.ensureIndex(index);
            this.l.addElements(this.from + index, a, offset, length);
            this.to += length;
        }

        public IntListIterator intListIterator(final int index) {
            this.ensureIndex(index);
            return new AbstractIntListIterator(){
                int pos;
                int last;
                {
                    this.pos = index;
                    this.last = -1;
                }

                public boolean hasNext() {
                    return this.pos < IntSubList.this.size();
                }

                public boolean hasPrevious() {
                    return this.pos > 0;
                }

                public int nextInt() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return IntSubList.this.l.getInt(IntSubList.this.from + this.last);
                }

                public int previousInt() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return IntSubList.this.l.getInt(IntSubList.this.from + this.pos);
                }

                public int nextIndex() {
                    return this.pos;
                }

                public int previousIndex() {
                    return this.pos - 1;
                }

                public void add(int k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    IntSubList.this.add(this.pos++, k);
                    this.last = -1;
                }

                public void set(int k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    IntSubList.this.set(this.last, k);
                }

                public void remove() {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    IntSubList.this.removeInt(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1;
                }
            };
        }

        public IntList intSubList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            return new IntSubList(this, from, to);
        }
    }
}

