/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.bytes;

import clover.it.unimi.dsi.fastutil.Iterators;
import clover.it.unimi.dsi.fastutil.bytes.AbstractByteBidirectionalIterator;
import clover.it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import clover.it.unimi.dsi.fastutil.bytes.AbstractByteListIterator;
import clover.it.unimi.dsi.fastutil.bytes.ByteArrayList;
import clover.it.unimi.dsi.fastutil.bytes.ByteArrays;
import clover.it.unimi.dsi.fastutil.bytes.ByteBidirectionalIterator;
import clover.it.unimi.dsi.fastutil.bytes.ByteCollection;
import clover.it.unimi.dsi.fastutil.bytes.ByteIterator;
import clover.it.unimi.dsi.fastutil.bytes.ByteList;
import clover.it.unimi.dsi.fastutil.bytes.ByteListIterator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ByteIterators {
    private ByteIterators() {
    }

    public static ByteListIterator emptyByteIterator() {
        return Iterators.EMPTY_ITERATOR;
    }

    public static ByteListIterator wrap(byte[] array, int offset, int length) {
        ByteArrays.ensureOffsetLength(array, offset, length);
        return new ArrayIterator(array, offset, length);
    }

    public static ByteListIterator wrap(byte[] array) {
        return new ArrayIterator(array, 0, array.length);
    }

    public static int unwrap(ByteIterator i, byte[] array, int offset, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        if (offset < 0 || offset + max > array.length) {
            throw new IllegalArgumentException();
        }
        int j = max;
        while (j-- != 0 && i.hasNext()) {
            array[offset++] = i.nextByte();
        }
        return max - j - 1;
    }

    public static int unwrap(ByteIterator i, byte[] array) {
        return ByteIterators.unwrap(i, array, 0, array.length);
    }

    public static byte[] unwrap(ByteIterator i, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        byte[] array = new byte[16];
        int j = 0;
        while (max-- != 0 && i.hasNext()) {
            if (j == array.length) {
                array = ByteArrays.grow(array, j + 1);
            }
            array[j++] = i.nextByte();
        }
        return ByteArrays.trim(array, j);
    }

    public static byte[] unwrap(ByteIterator i) {
        return ByteIterators.unwrap(i, Integer.MAX_VALUE);
    }

    public static int unwrap(ByteIterator i, ByteCollection c, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j = max;
        while (j-- != 0 && i.hasNext()) {
            c.add(i.nextByte());
        }
        return max - j - 1;
    }

    public static long unwrap(ByteIterator i, ByteCollection c) {
        long n = 0L;
        while (i.hasNext()) {
            c.add(i.nextByte());
            ++n;
        }
        return n;
    }

    public static int pour(ByteIterator i, ByteCollection s, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j = max;
        while (j-- != 0 && i.hasNext()) {
            s.add(i.nextByte());
        }
        return max - j - 1;
    }

    public static int pour(ByteIterator i, ByteCollection s) {
        return ByteIterators.pour(i, s, Integer.MAX_VALUE);
    }

    public static ByteList pour(ByteIterator i, int max) {
        ByteArrayList l = new ByteArrayList();
        ByteIterators.pour(i, l, max);
        l.trim();
        return l;
    }

    public static ByteList pour(ByteIterator i) {
        return ByteIterators.pour(i, Integer.MAX_VALUE);
    }

    public static ByteListIterator asByteIterator(ListIterator i) {
        if (i instanceof ByteListIterator) {
            return (ByteListIterator)i;
        }
        return new ListIteratorWrapper(i);
    }

    public static ByteIterator asByteIterator(Iterator i) {
        if (i instanceof ByteIterator) {
            return (ByteIterator)i;
        }
        return new IteratorWrapper(i);
    }

    public static ByteListIterator fromTo(byte from, byte to) {
        return new IntervalIterator(from, to);
    }

    public static ByteIterator concat(ByteIterator[] a) {
        return ByteIterators.concat(a, 0, a.length);
    }

    public static ByteIterator concat(ByteIterator[] a, int offset, int length) {
        return new IteratorConcatenator(a, offset, length);
    }

    public static ByteIterator unmodifiable(ByteIterator i) {
        return new UnmodifiableIterator(i);
    }

    public static ByteBidirectionalIterator unmodifiable(ByteBidirectionalIterator i) {
        return new UnmodifiableBidirectionalIterator(i);
    }

    public static ByteListIterator unmodifiable(ByteListIterator i) {
        return new UnmodifiableListIterator(i);
    }

    public static class UnmodifiableListIterator
    extends AbstractByteListIterator {
        protected final ByteListIterator i;

        public UnmodifiableListIterator(ByteListIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public byte nextByte() {
            return this.i.nextByte();
        }

        public byte previousByte() {
            return this.i.previousByte();
        }

        public int nextIndex() {
            return this.i.nextIndex();
        }

        public int previousIndex() {
            return this.i.previousIndex();
        }

        public Object next() {
            return this.i.next();
        }

        public Object previous() {
            return this.i.previous();
        }
    }

    public static class UnmodifiableBidirectionalIterator
    extends AbstractByteBidirectionalIterator {
        protected final ByteBidirectionalIterator i;

        public UnmodifiableBidirectionalIterator(ByteBidirectionalIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public byte nextByte() {
            return this.i.nextByte();
        }

        public byte previousByte() {
            return this.i.previousByte();
        }

        public Object next() {
            return this.i.next();
        }

        public Object previous() {
            return this.i.previous();
        }
    }

    public static class UnmodifiableIterator
    extends AbstractByteIterator {
        protected final ByteIterator i;

        public UnmodifiableIterator(ByteIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public byte nextByte() {
            return this.i.nextByte();
        }

        public Object next() {
            return this.i.next();
        }
    }

    private static class IteratorConcatenator
    extends AbstractByteIterator {
        final ByteIterator[] a;
        int offset;
        int length;
        int lastOffset = -1;

        public IteratorConcatenator(ByteIterator[] a, int offset, int length) {
            this.a = a;
            this.offset = offset;
            this.length = length;
            this.advance();
        }

        private void advance() {
            while (this.length != 0 && !this.a[this.offset].hasNext()) {
                --this.length;
                ++this.offset;
            }
        }

        public boolean hasNext() {
            return this.length > 0;
        }

        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastOffset = this.offset;
            byte next = this.a[this.lastOffset].nextByte();
            this.advance();
            return next;
        }

        public void remove() {
            if (this.lastOffset == -1) {
                throw new IllegalStateException();
            }
            this.a[this.lastOffset].remove();
        }

        public int skip(int n) {
            this.lastOffset = -1;
            int skipped = 0;
            while (skipped < n && this.length != 0) {
                skipped += this.a[this.offset].skip(n - skipped);
                if (this.a[this.offset].hasNext()) break;
                --this.length;
                ++this.offset;
            }
            return skipped;
        }
    }

    private static class IntervalIterator
    extends AbstractByteListIterator {
        private final byte from;
        private final byte to;
        byte curr;

        public IntervalIterator(byte from, byte to) {
            this.from = this.curr = from;
            this.to = to;
        }

        public boolean hasNext() {
            return this.curr < this.to;
        }

        public boolean hasPrevious() {
            return this.curr > this.from;
        }

        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte by = this.curr;
            this.curr = (byte)(by + 1);
            return by;
        }

        public byte previousByte() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = (byte)(this.curr - 1);
            return this.curr;
        }

        public int nextIndex() {
            return this.curr - this.from;
        }

        public int previousIndex() {
            return this.curr - this.from - 1;
        }

        public int skip(int n) {
            if (this.curr + n <= this.to) {
                this.curr = (byte)(this.curr + n);
                return n;
            }
            n = this.to - this.curr;
            this.curr = this.to;
            return n;
        }

        public int back(int n) {
            if (this.curr - n >= this.from) {
                this.curr = (byte)(this.curr - n);
                return n;
            }
            n = this.curr - this.from;
            this.curr = this.from;
            return n;
        }
    }

    private static class ListIteratorWrapper
    extends AbstractByteListIterator {
        final ListIterator i;

        public ListIteratorWrapper(ListIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public int nextIndex() {
            return this.i.nextIndex();
        }

        public int previousIndex() {
            return this.i.previousIndex();
        }

        public void set(byte k) {
            this.i.set(new Byte(k));
        }

        public void add(byte k) {
            this.i.add(new Byte(k));
        }

        public void remove() {
            this.i.remove();
        }

        public byte nextByte() {
            return (Byte)this.i.next();
        }

        public byte previousByte() {
            return (Byte)this.i.previous();
        }
    }

    private static class IteratorWrapper
    extends AbstractByteIterator {
        final Iterator i;

        public IteratorWrapper(Iterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public void remove() {
            this.i.remove();
        }

        public byte nextByte() {
            return (Byte)this.i.next();
        }
    }

    private static class ArrayIterator
    extends AbstractByteListIterator {
        private final byte[] array;
        private final int offset;
        private final int length;
        private int curr;

        public ArrayIterator(byte[] array, int offset, int length) {
            this.array = array;
            this.offset = offset;
            this.length = length;
        }

        public boolean hasNext() {
            return this.curr < this.length;
        }

        public boolean hasPrevious() {
            return this.curr > 0;
        }

        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + this.curr++];
        }

        public byte previousByte() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + --this.curr];
        }

        public int skip(int n) {
            if (n <= this.length - this.curr) {
                this.curr += n;
                return n;
            }
            n = this.length - this.curr;
            this.curr = this.length;
            return n;
        }

        public int back(int n) {
            if (n <= this.curr) {
                this.curr -= n;
                return n;
            }
            n = this.curr;
            this.curr = 0;
            return n;
        }

        public int nextIndex() {
            return this.curr;
        }

        public int previousIndex() {
            return this.curr - 1;
        }
    }
}

