/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf.hyphenation;

import clover.com.lowagie.text.pdf.hyphenation.ByteVector;
import clover.com.lowagie.text.pdf.hyphenation.Hyphenation;
import clover.com.lowagie.text.pdf.hyphenation.HyphenationException;
import clover.com.lowagie.text.pdf.hyphenation.PatternConsumer;
import clover.com.lowagie.text.pdf.hyphenation.PatternInternalParser;
import clover.com.lowagie.text.pdf.hyphenation.TernaryTree;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class HyphenationTree
extends TernaryTree
implements PatternConsumer,
Serializable {
    protected ByteVector vspace;
    protected Hashtable stoplist = new Hashtable(23);
    protected TernaryTree classmap = new TernaryTree();
    private transient TernaryTree ivalues;

    public HyphenationTree() {
        this.vspace = new ByteVector();
        this.vspace.alloc(1);
    }

    protected int packValues(String string) {
        int n = string.length();
        int n2 = (n & 1) == 1 ? (n >> 1) + 2 : (n >> 1) + 1;
        int n3 = this.vspace.alloc(n2);
        byte[] byArray = this.vspace.getArray();
        int n4 = 0;
        while (n4 < n) {
            int n5 = n4 >> 1;
            byte by = (byte)(string.charAt(n4) - 48 + 1 & 0xF);
            byArray[n5 + n3] = (n4 & 1) == 1 ? (byte)(byArray[n5 + n3] | by) : (byte)(by << 4);
            ++n4;
        }
        byArray[n2 - 1 + n3] = 0;
        return n3;
    }

    protected String unpackValues(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this.vspace.get(n++);
        while (by != 0) {
            char c = (char)((by >>> 4) - 1 + 48);
            stringBuffer.append(c);
            c = (char)(by & 0xF);
            if (c == '\u0000') break;
            c = (char)(c - '\u0001' + 48);
            stringBuffer.append(c);
            by = this.vspace.get(n++);
        }
        return stringBuffer.toString();
    }

    public void loadInternalPatterns(String string) throws HyphenationException {
        PatternInternalParser patternInternalParser = new PatternInternalParser(this);
        this.ivalues = new TernaryTree();
        patternInternalParser.parse(string);
        this.trimToSize();
        this.vspace.trimToSize();
        this.classmap.trimToSize();
        this.ivalues = null;
    }

    public void loadInternalPatterns(InputStream inputStream) throws HyphenationException {
        PatternInternalParser patternInternalParser = new PatternInternalParser(this);
        this.ivalues = new TernaryTree();
        patternInternalParser.parse(inputStream);
        this.trimToSize();
        this.vspace.trimToSize();
        this.classmap.trimToSize();
        this.ivalues = null;
    }

    public String findPattern(String string) {
        int n = super.find(string);
        if (n >= 0) {
            return this.unpackValues(n);
        }
        return "";
    }

    protected int hstrcmp(char[] cArray, int n, char[] cArray2, int n2) {
        while (cArray[n] == cArray2[n2]) {
            if (cArray[n] == '\u0000') {
                return 0;
            }
            ++n;
            ++n2;
        }
        if (cArray2[n2] == '\u0000') {
            return 0;
        }
        return cArray[n] - cArray2[n2];
    }

    protected byte[] getValues(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this.vspace.get(n++);
        while (by != 0) {
            char c = (char)((by >>> 4) - 1);
            stringBuffer.append(c);
            c = (char)(by & 0xF);
            if (c == '\u0000') break;
            c = (char)(c - '\u0001');
            stringBuffer.append(c);
            by = this.vspace.get(n++);
        }
        byte[] byArray = new byte[stringBuffer.length()];
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = (byte)stringBuffer.charAt(n2);
            ++n2;
        }
        return byArray;
    }

    protected void searchPatterns(char[] cArray, int n, byte[] byArray) {
        int n2 = n;
        char c = cArray[n2];
        char c2 = this.root;
        block0: while (c2 > '\u0000' && c2 < this.sc.length) {
            int n3;
            int n4;
            byte[] byArray2;
            if (this.sc[c2] == '\uffff') {
                if (this.hstrcmp(cArray, n2, this.kv.getArray(), this.lo[c2]) == 0) {
                    byArray2 = this.getValues(this.eq[c2]);
                    n4 = n;
                    n3 = 0;
                    while (n3 < byArray2.length) {
                        if (n4 < byArray.length && byArray2[n3] > byArray[n4]) {
                            byArray[n4] = byArray2[n3];
                        }
                        ++n4;
                        ++n3;
                    }
                }
                return;
            }
            n4 = c - this.sc[c2];
            if (n4 == 0) {
                if (c == '\u0000') break;
                c = cArray[++n2];
                char c3 = c2 = this.eq[c2];
                while (c3 > '\u0000' && c3 < this.sc.length) {
                    if (this.sc[c3] == '\uffff') continue block0;
                    if (this.sc[c3] == '\u0000') {
                        byArray2 = this.getValues(this.eq[c3]);
                        n3 = n;
                        int n5 = 0;
                        while (n5 < byArray2.length) {
                            if (n3 < byArray.length && byArray2[n5] > byArray[n3]) {
                                byArray[n3] = byArray2[n5];
                            }
                            ++n3;
                            ++n5;
                        }
                        continue block0;
                    }
                    c3 = this.lo[c3];
                }
                continue;
            }
            char c4 = c2 = n4 < 0 ? this.lo[c2] : this.hi[c2];
        }
    }

    public Hyphenation hyphenate(String string, int n, int n2) {
        char[] cArray = string.toCharArray();
        return this.hyphenate(cArray, 0, cArray.length, n, n2);
    }

    public Hyphenation hyphenate(char[] cArray, int n, int n2, int n3, int n4) {
        Object object;
        char[] cArray2 = new char[n2 + 3];
        char[] cArray3 = new char[2];
        int n5 = 1;
        while (n5 <= n2) {
            cArray3[0] = cArray[n + n5 - 1];
            int n6 = this.classmap.find(cArray3, 0);
            if (n6 < 0) {
                return null;
            }
            cArray2[n5] = (char)n6;
            ++n5;
        }
        int[] nArray = new int[n2 + 1];
        int n7 = 0;
        String string = new String(cArray2, 1, n2);
        if (this.stoplist.containsKey(string)) {
            object = (Vector)this.stoplist.get(string);
            int n8 = 0;
            n5 = 0;
            while (n5 < ((Vector)object).size()) {
                Object e = ((Vector)object).elementAt(n5);
                if (e instanceof String && (n8 += ((String)e).length()) >= n3 && n8 < n2 - n4) {
                    nArray[n7++] = n8;
                }
                ++n5;
            }
        } else {
            cArray2[0] = 46;
            cArray2[n2 + 1] = 46;
            cArray2[n2 + 2] = '\u0000';
            object = new byte[n2 + 3];
            n5 = 0;
            while (n5 < n2 + 1) {
                this.searchPatterns(cArray2, n5, (byte[])object);
                ++n5;
            }
            n5 = 0;
            while (n5 < n2) {
                if ((object[n5 + 1] & 1) == 1 && n5 >= n3 && n5 < n2 - n4) {
                    nArray[n7++] = n5;
                }
                ++n5;
            }
        }
        if (n7 > 0) {
            object = new int[n7];
            System.arraycopy(nArray, 0, object, 0, n7);
            return new Hyphenation(new String(cArray, n, n2), (int[])object);
        }
        return null;
    }

    public void addClass(String string) {
        if (string.length() > 0) {
            char c = string.charAt(0);
            char[] cArray = new char[2];
            cArray[1] = '\u0000';
            int n = 0;
            while (n < string.length()) {
                cArray[0] = string.charAt(n);
                this.classmap.insert(cArray, 0, c);
                ++n;
            }
        }
    }

    public void addException(String string, Vector vector) {
        this.stoplist.put(string, vector);
    }

    public void addPattern(String string, String string2) {
        int n = this.ivalues.find(string2);
        if (n <= 0) {
            n = this.packValues(string2);
            this.ivalues.insert(string2, (char)n);
        }
        this.insert(string, (char)n);
    }

    public void printStats() {
        System.out.println("Value space size = " + Integer.toString(this.vspace.length()));
        super.printStats();
    }
}

