/*
 * Decompiled with CFR 0.152.
 */
package clover.com.cenqua.license;

import clover.com.cenqua.license.AtlassianLicenseConverter;
import clover.com.cenqua.license.CenquaLicense;
import java.io.IOException;

public class AtlassianLicenseConverterFactory {
    private static AtlassianLicenseConverterFactory instance;
    private static final String CLOVER_CONVERTER = "clover.com.cenqua.license.clover.CloverConverter";
    private static final String FISHEYE_CONVERTER = "clover.com.cenqua.license.fisheye.FishEyeConverter";
    private static final String CRUCIBLE_CONVERTER = "clover.com.cenqua.license.crucible.CrucibleConverter";
    private static String[] CONVERTER_CLASSES;
    private AtlassianLicenseConverter converter;

    public AtlassianLicenseConverterFactory(AtlassianLicenseConverter converter) {
        this.converter = converter;
    }

    private AtlassianLicenseConverterFactory() throws IOException {
        for (int i = 0; i < CONVERTER_CLASSES.length; ++i) {
            try {
                Class<?> cnvClass = Class.forName(CONVERTER_CLASSES[i]);
                if (cnvClass == null) continue;
                this.converter = (AtlassianLicenseConverter)cnvClass.newInstance();
                break;
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        if (this.converter == null) {
            throw new IOException("Unable to read license [E1300]");
        }
    }

    void setConverter(AtlassianLicenseConverter cnv) {
        this.converter = cnv;
    }

    public static void setInstance(AtlassianLicenseConverterFactory instance) {
        AtlassianLicenseConverterFactory.instance = instance;
    }

    public static AtlassianLicenseConverterFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new AtlassianLicenseConverterFactory();
        }
        return instance;
    }

    public CenquaLicense getCenquaLicense(String atlassianLicenseString) throws IOException {
        return this.converter.getCenquaLicense(atlassianLicenseString);
    }

    static {
        CONVERTER_CLASSES = new String[]{CLOVER_CONVERTER, FISHEYE_CONVERTER, CRUCIBLE_CONVERTER};
    }
}

