/*
 * Decompiled with CFR 0.152.
 */
package clover.cenqua_com_licensing.atlassian.license.decoder;

import clover.cenqua_com_licensing.atlassian.license.DefaultLicense;
import clover.cenqua_com_licensing.atlassian.license.License;
import clover.cenqua_com_licensing.atlassian.license.LicenseException;
import clover.cenqua_com_licensing.atlassian.license.LicenseManager;
import clover.cenqua_com_licensing.atlassian.license.LicensePair;
import clover.cenqua_com_licensing.atlassian.license.LicenseType;
import clover.cenqua_com_licensing.atlassian.license.LicenseUtils;
import clover.cenqua_com_licensing.atlassian.license.decoder.LicenseAdaptor;
import clover.cenqua_com_licensing.atlassian.license.ng.AtlassianLicense;
import clover.cenqua_com_licensing.atlassian.license.ng.DefaultAtlassianProduct;
import clover.cenqua_com_licensing.atlassian.license.util.Logger;
import clover.cenqua_com_licensing.atlassian.license.util.StringUtils;
import clover.cenqua_com_licensing.atlassian.time.DateTime;
import clover.cenqua_com_licensing.atlassian.time.MutablePeriod;
import clover.cenqua_com_licensing.atlassian.time.format.DateTimeFormatter;
import clover.cenqua_com_licensing.atlassian.time.format.ISODateTimeFormat;
import clover.cenqua_com_licensing.atlassian.time.format.ISOPeriodFormat;
import clover.cenqua_com_licensing.atlassian.time.format.PeriodFormatter;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

public class LicenseDecoder {
    public static final String DURATION_PREFIX = "Duration:";
    private static Logger.Log log = Logger.getInstance(LicenseDecoder.class);
    public static final String JIRA_APPLICATION_NAME = "JIRA";
    public static final String CONF_APPLICATION_NAME = "CONFLUENCE";

    public static License getLicense(LicensePair pair, String applicationName) {
        try {
            return LicenseDecoder.loadLicense(pair, LicenseDecoder.getPublicKey(applicationName), applicationName);
        }
        catch (LicenseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static boolean isValid(LicensePair pair, String applicationName) {
        return LicenseDecoder.getLicense(pair, applicationName) != null;
    }

    private static PublicKey getPublicKey(String applicationName) throws LicenseException {
        String publicKeyFileName = LicenseDecoder.getPublicKeyFilename(applicationName);
        if (publicKeyFileName == null || "".equals(publicKeyFileName)) {
            throw new LicenseException("The filename for the public key is null. This must be set before a public key can be located.");
        }
        try {
            InputStream keyfis = null;
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            if (contextLoader != null) {
                keyfis = contextLoader.getResourceAsStream(publicKeyFileName);
            }
            if (keyfis == null) {
                keyfis = LicenseDecoder.class.getClassLoader().getResourceAsStream(publicKeyFileName);
            }
            byte[] encKey = LicenseUtils.readKey(keyfis);
            keyfis.close();
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encKey);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return keyFactory.generatePublic(pubKeySpec);
        }
        catch (Exception e) {
            log.error("Exception looking up public key: " + e.getMessage(), e);
            throw new LicenseException("Exception getting verification from file - possible classloader problem, or corrupt JIRA installation ");
        }
    }

    private static License loadLicense(LicensePair pair, PublicKey publicKey, String applicationName) {
        try {
            if (pair.isNG()) {
                return LicenseDecoder.parseNewLicense(pair, applicationName);
            }
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initVerify(publicKey);
            signature.update(pair.getLicense());
            if (signature.verify(pair.getHash())) {
                String messageString = LicenseDecoder.getDecodedMessage(pair.getLicense());
                StringTokenizer tokenizer = new StringTokenizer(messageString, "^");
                if (tokenizer.hasMoreTokens()) {
                    int licenseTypeCode = Integer.parseInt(tokenizer.nextToken());
                    LicenseType licenseType = LicenseManager.getInstance().getLicenseType(applicationName, licenseTypeCode);
                    Date dateCreated = LicenseDecoder.parseDate(tokenizer.nextToken());
                    Date datePurchased = LicenseDecoder.parseDate(tokenizer.nextToken());
                    Date dateExpires = null;
                    if (licenseType.expires()) {
                        dateExpires = LicenseDecoder.parseDate(tokenizer.nextToken());
                    }
                    String organisation = tokenizer.nextToken();
                    String licenseId = LicenseDecoder.getLicenseIdFromLicenseString(pair.getOriginalLicenseString());
                    int users = -1;
                    int clusterCount = 0;
                    if (licenseType.requiresUserLimit()) {
                        String usersAndClustersLimits = tokenizer.nextToken();
                        String[] parts = usersAndClustersLimits.split("\\|");
                        if (parts.length != 1 && parts.length != 2) {
                            throw new LicenseException("License contained invalid user limit:" + usersAndClustersLimits);
                        }
                        users = Integer.parseInt(parts[0]);
                        if (parts.length == 2) {
                            clusterCount = Integer.parseInt(parts[1]);
                        }
                    }
                    String partnerName = null;
                    if (tokenizer.hasMoreTokens()) {
                        partnerName = tokenizer.nextToken();
                    }
                    return new DefaultLicense(dateCreated, datePurchased, dateExpires, organisation, licenseType, users, partnerName, licenseId, clusterCount);
                }
            } else {
                log.warn("Signature did not verify properly.");
            }
        }
        catch (Exception e) {
            log.error(e);
        }
        return null;
    }

    private static Date parseDate(String dateStr) throws LicenseException {
        if (dateStr.startsWith(DURATION_PREFIX)) {
            dateStr = dateStr.substring(DURATION_PREFIX.length());
            return new Date(System.currentTimeMillis() + Long.parseLong(dateStr));
        }
        if (dateStr.startsWith("P")) {
            try {
                MutablePeriod period = new MutablePeriod();
                PeriodFormatter formatter = ISOPeriodFormat.standard();
                formatter.getParser().parseInto(period, dateStr, 0, Locale.ENGLISH);
                DateTime currentTime = new DateTime();
                DateTime targetTime = currentTime.plus(period);
                return targetTime.toDate();
            }
            catch (RuntimeException e) {
                throw new LicenseException("Invalid date format: '" + dateStr + "'", e);
            }
        }
        try {
            return new Date(Long.parseLong(dateStr));
        }
        catch (NumberFormatException e) {
            try {
                DateTimeFormatter parser = ISODateTimeFormat.dateOptionalTimeParser();
                DateTime targetTime = parser.parseDateTime(dateStr);
                return targetTime.toDate();
            }
            catch (RuntimeException ex) {
                throw new LicenseException("Invalid date format: '" + dateStr + "'", ex);
            }
        }
    }

    public static License parseNewLicense(LicensePair pair, String applicationName) throws LicenseException {
        clover.cenqua_com_licensing.atlassian.license.ng.LicenseManager.registerLicense(pair);
        AtlassianLicense license = clover.cenqua_com_licensing.atlassian.license.ng.LicenseManager.getLicense(new DefaultAtlassianProduct(applicationName, applicationName, null));
        LicenseType licenseType = LicenseManager.getInstance().getLicenseType(applicationName, license.getLicenseType());
        return new LicenseAdaptor(license, licenseType);
    }

    private static String getLicenseIdFromLicenseString(String originalLicenseString) {
        if (originalLicenseString != null && originalLicenseString.length() > 70) {
            return StringUtils.replaceAll(StringUtils.replaceAll(StringUtils.replaceAll(originalLicenseString, "\n", ""), "\r", ""), "\t", "").substring(59, 69).toUpperCase();
        }
        return "";
    }

    private static String getDecodedMessage(byte[] message) {
        return new String(message);
    }

    public static boolean isValid(LicensePair pair, PublicKey publicKey, String applicationName) {
        return LicenseDecoder.loadLicense(pair, publicKey, applicationName) != null;
    }

    public static String getPublicKeyFilename(String applicationName) {
        return LicenseManager.getInstance().getLicenseTypeStore(applicationName).getPublicKeyFileName();
    }
}

